/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.path;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.project.path.PathTranslator;

public class DefaultPathTranslator
implements PathTranslator {
    private String FILE_SEPARATOR = "/";

    public void alignToBaseDirectory(Model model, File basedir) {
        Build build = model.getBuild();
        if (build != null) {
            build.setDirectory(this.alignToBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir));
            for (Resource resource : build.getResources()) {
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            for (Resource resource : build.getTestResources()) {
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                for (String filter : build.getFilters()) {
                    filters.add(this.alignToBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
    }

    public String alignToBaseDirectory(String path, File basedir) {
        String s = this.stripBasedirToken(path);
        if (this.requiresBaseDirectoryAlignment(s)) {
            s = new File(new File(basedir, s).toURI().normalize()).getAbsolutePath();
        }
        return s;
    }

    private String stripBasedirToken(String s) {
        String basedirExpr = "${basedir}";
        if (s != null && (s = s.trim()).startsWith(basedirExpr)) {
            s = s.length() > basedirExpr.length() ? s.substring(basedirExpr.length() + 1) : ".";
        }
        return s;
    }

    private boolean requiresBaseDirectoryAlignment(String s) {
        if (s != null) {
            File f = new File(s);
            return !s.startsWith(this.FILE_SEPARATOR) && !f.isAbsolute();
        }
        return false;
    }

    public void unalignFromBaseDirectory(Model model, File basedir) {
        Build build = model.getBuild();
        if (build != null) {
            build.setDirectory(this.unalignFromBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.unalignFromBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.unalignFromBaseDirectory(build.getTestSourceDirectory(), basedir));
            for (Resource resource : build.getResources()) {
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            for (Resource resource : build.getTestResources()) {
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                for (String filter : build.getFilters()) {
                    filters.add(this.unalignFromBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.unalignFromBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.unalignFromBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
    }

    public String unalignFromBaseDirectory(String directory, File basedir) {
        String path = basedir.getPath();
        if (directory.startsWith(path)) {
            directory = directory.substring(path.length() + 1).replace('\\', '/');
        }
        return directory;
    }
}

