/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTree;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SVGNavigatorNode
implements TreeNode,
DocumentElementListener {
    private final SVGNavigatorTree m_nodeTree;
    private final DocumentElement m_de;
    private final TreeNode m_parent;
    private byte m_nodeVisibility;
    private List<SVGNavigatorNode> m_children = null;
    private boolean m_containsError = false;
    private int m_childrenErrorCount = 0;
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final int ATTRIBS_MAX_LEN = 100;

    public SVGNavigatorNode(DocumentElement documentElement, SVGNavigatorTree sVGNavigatorTree, TreeNode treeNode, byte by) {
        this.m_de = documentElement;
        this.m_nodeTree = sVGNavigatorTree;
        this.m_parent = treeNode;
        this.m_nodeVisibility = by;
    }

    public Enumeration<SVGNavigatorNode> children() {
        this.checkChildrenAdapters();
        return Collections.enumeration(this.m_children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        this.checkChildrenAdapters();
        return this.m_children.get(n);
    }

    @Override
    public int getChildCount() {
        this.checkChildrenAdapters();
        return this.m_children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.checkChildrenAdapters();
        return this.m_children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.m_parent;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DocumentElement getDocumentElement() {
        assert (this.m_de != null);
        return this.m_de;
    }

    public byte getNodeVisibility() {
        return this.m_nodeVisibility;
    }

    SVGNavigatorNode findNode(DocumentElement documentElement) {
        SVGNavigatorNode sVGNavigatorNode = null;
        if (this.m_de.equals((Object)documentElement)) {
            sVGNavigatorNode = this;
        } else if (this.m_children != null) {
            for (int i = this.m_children.size() - 1; i >= 0 && (sVGNavigatorNode = this.m_children.get(i).findNode(documentElement)) == null; --i) {
            }
        }
        return sVGNavigatorNode;
    }

    SVGNavigatorNode getChildByElemenent(DocumentElement documentElement) {
        this.checkChildrenAdapters();
        if (this.m_children != null) {
            for (SVGNavigatorNode sVGNavigatorNode : this.m_children) {
                if (sVGNavigatorNode.getDocumentElement() != documentElement) continue;
                return sVGNavigatorNode;
            }
        }
        return null;
    }

    TreePath getNodePath() {
        int n = 0;
        TreeNode treeNode = this;
        do {
            treeNode = treeNode.getParent();
            ++n;
        } while (treeNode != null);
        Object[] objectArray = new TreeNode[n];
        treeNode = this;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            objectArray[i] = treeNode;
            treeNode = treeNode.getParent();
        }
        return new TreePath(objectArray);
    }

    private SVGNavigatorNode getChildTreeNode(DocumentElement documentElement) {
        int n = this.getChildTreeNodeIndex(documentElement);
        if (n != -1) {
            return this.m_children.get(n);
        }
        return null;
    }

    private int getChildTreeNodeIndex(DocumentElement documentElement) {
        this.checkChildrenAdapters();
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            SVGNavigatorNode sVGNavigatorNode = this.m_children.get(i);
            if (!sVGNavigatorNode.getDocumentElement().equals((Object)documentElement)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsError() {
        this.checkChildrenAdapters();
        return this.m_containsError;
    }

    public int getChildrenErrorCount() {
        this.checkChildrenAdapters();
        return this.m_childrenErrorCount;
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean bl) {
        if (SVGNavigatorTree.isTreeElement(this.m_de)) {
            CharSequence charSequence;
            String string = "";
            AttributeSet attributeSet = this.getDocumentElement().getAttributes();
            if (attributeSet.getAttributeCount() > 0) {
                charSequence = this.getAttribsText();
                if (SVGNavigatorTree.showAttributes) {
                    string = ((String)charSequence).length() > 100 ? ((String)charSequence).substring(0, 100) + "..." : ((String)charSequence).toString();
                }
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(bl ? "<html>" : "");
            if (bl) {
                if (this.m_containsError) {
                    ((StringBuffer)charSequence).append("<font color=FF0000><b>");
                } else if (this.m_nodeVisibility == SVGNavigatorTree.VISIBILITY_UNDIRECT) {
                    ((StringBuffer)charSequence).append("<font color=888888>");
                }
            }
            ((StringBuffer)charSequence).append(this.getDocumentElement().getName());
            if (bl) {
                if (this.m_containsError) {
                    ((StringBuffer)charSequence).append("</b></font>");
                } else if (this.m_nodeVisibility == SVGNavigatorTree.VISIBILITY_UNDIRECT) {
                    ((StringBuffer)charSequence).append("</font>");
                }
            }
            ((StringBuffer)charSequence).append(bl ? "<font color=888888>" : "");
            if (string.trim().length() > 0) {
                ((StringBuffer)charSequence).append(" ");
                ((StringBuffer)charSequence).append(string);
            }
            ((StringBuffer)charSequence).append(bl ? "</font>" : "");
            ((StringBuffer)charSequence).append(bl ? "</html>" : "");
            return ((StringBuffer)charSequence).toString();
        }
        return this.m_de.getName() + " [unknown content]";
    }

    public String getToolTipText() {
        return this.getAttribsText();
    }

    public void childrenReordered(DocumentElementEvent documentElementEvent) {
        this.m_nodeTree.getTreeModel().nodeStructureChanged(this);
    }

    public String getAttribsText() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = this.getDocumentElement().getAttributes().getAttributeNames();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.getDocumentElement().getAttributes().getAttribute(string);
                stringBuffer.append(string);
                stringBuffer.append("=\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public void elementAdded(DocumentElementEvent documentElementEvent) {
        final DocumentElement documentElement = documentElementEvent.getChangedChild();
        if (debug) {
            System.out.println(">>> +EVENT called on " + this.hashCode() + " - " + this.m_de + ": element " + documentElement + " is going to be added");
        }
        if (SVGNavigatorTree.isTreeElement(documentElement)) {
            byte by = this.m_nodeTree.checkVisibility(documentElement, true);
            int n = this.getChildTreeNodeIndex(documentElement);
            if (n == -1) {
                if (by != SVGNavigatorTree.VISIBILITY_NO) {
                    String string;
                    SVGNavigatorNode sVGNavigatorNode = new SVGNavigatorNode(documentElement, this.m_nodeTree, this, by);
                    int n2 = this.getVisibleChildIndex(documentElement);
                    if (this.m_children.size() < n2) {
                        this.m_nodeTree.getTreeModel().nodeStructureChanged(this);
                    } else {
                        this.m_children.add(n2, sVGNavigatorNode);
                        int n3 = this.getIndex(sVGNavigatorNode);
                        this.m_nodeTree.getTreeModel().nodesWereInserted(this, new int[]{n3});
                    }
                    if (debug) {
                        System.out.println("<<<EVENT finished (node " + sVGNavigatorNode + " added)");
                    }
                    if ((string = this.m_nodeTree.getSelectedId()) != null && this.m_nodeTree.isSelectionEmpty() && string.equals(SVGFileModel.getIdAttribute(documentElement))) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SVGNavigatorNode.this.m_nodeTree.selectNode(string, documentElement);
                            }
                        });
                    }
                }
            } else if (by == SVGNavigatorTree.VISIBILITY_NO) {
                SVGNavigatorNode sVGNavigatorNode = this.m_children.remove(n);
                this.m_nodeTree.getTreeModel().nodesWereRemoved(this, new int[]{n}, new Object[]{sVGNavigatorNode});
            }
        } else if (SVGFileModel.isError(documentElement)) {
            this.markNodeAsError(this);
        }
        if (this.m_de.equals((Object)this.m_de.getDocumentModel().getRootElement())) {
            this.m_nodeTree.expandPath(new TreePath(this));
        }
    }

    private void debugError(DocumentElementEvent documentElementEvent) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("An inconsistency between XML navigator and XML DocumentModel occured when adding a new element in the XML DocumentModel! Please report the problem and add following debug messages to the issue along with the XML document you are editing.");
        stringBuffer.append("Debug for Node " + this + ":\n");
        stringBuffer.append("Children of current node:\n");
        Iterator<SVGNavigatorNode> iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append(((SVGNavigatorNode)object).toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nChildren of DocumentElement (" + this.getDocumentElement() + ") wrapped by the current node:\n");
        object = this.getDocumentElement().getChildren().iterator();
        while (iterator.hasNext()) {
            DocumentElement documentElement = (DocumentElement)iterator.next();
            stringBuffer.append(documentElement.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("------------");
        ErrorManager.getDefault().log(1, stringBuffer.toString());
    }

    private void markNodeAsError(SVGNavigatorNode sVGNavigatorNode) {
        sVGNavigatorNode.m_containsError = true;
        SVGNavigatorNode sVGNavigatorNode2 = sVGNavigatorNode;
        this.m_nodeTree.getTreeModel().nodeChanged(sVGNavigatorNode);
        while ((sVGNavigatorNode2 = (SVGNavigatorNode)sVGNavigatorNode2.getParent()) != null) {
            if (sVGNavigatorNode2.getParent() != null) {
                ++sVGNavigatorNode2.m_childrenErrorCount;
            }
            this.m_nodeTree.getTreeModel().nodeChanged(sVGNavigatorNode2);
        }
    }

    private int getVisibleChildIndex(DocumentElement documentElement) {
        int n = 0;
        for (DocumentElement documentElement2 : this.getDocumentElement().getChildren()) {
            if (documentElement2.equals((Object)documentElement)) {
                return n;
            }
            if (!SVGNavigatorTree.isTreeElement(documentElement2)) continue;
            ++n;
        }
        return -1;
    }

    public void elementRemoved(DocumentElementEvent documentElementEvent) {
        DocumentElement documentElement = documentElementEvent.getChangedChild();
        if (debug) {
            System.out.println(">>> -EVENT on " + this.hashCode() + " - " + this.m_de + ": element " + documentElement + " is going to be removed ");
        }
        if (SVGNavigatorTree.isTreeElement(documentElement)) {
            if (debug) {
                System.out.println(">>> removing tag element");
            }
            SVGNavigatorNode sVGNavigatorNode = this.getChildTreeNode(documentElement);
            int n = this.getIndex(sVGNavigatorNode);
            if (sVGNavigatorNode != null) {
                this.m_children.remove(sVGNavigatorNode);
                this.m_nodeTree.getTreeModel().nodesWereRemoved(this, new int[]{n}, new Object[]{sVGNavigatorNode});
            } else if (debug) {
                System.out.println("Warning: TreeNode for removed element doesn't exist!!!");
            }
        } else if (SVGFileModel.isError(documentElement)) {
            this.unmarkNodeAsError(this);
        }
        if (debug) {
            System.out.println("<<<EVENT finished (node removed)");
        }
    }

    private void unmarkNodeAsError(SVGNavigatorNode sVGNavigatorNode) {
        sVGNavigatorNode.m_containsError = false;
        SVGNavigatorNode sVGNavigatorNode2 = sVGNavigatorNode;
        this.m_nodeTree.getTreeModel().nodeChanged(sVGNavigatorNode);
        while ((sVGNavigatorNode2 = (SVGNavigatorNode)sVGNavigatorNode2.getParent()) != null) {
            if (sVGNavigatorNode2.getParent() != null) {
                --sVGNavigatorNode2.m_childrenErrorCount;
            }
            this.m_nodeTree.getTreeModel().nodeChanged(sVGNavigatorNode2);
        }
    }

    public void attributesChanged(DocumentElementEvent documentElementEvent) {
        if (debug) {
            System.out.println("Attributes of treenode " + this + " has changed.");
        }
        this.m_nodeTree.getTreeModel().nodeChanged(this);
    }

    public void contentChanged(DocumentElementEvent documentElementEvent) {
        if (debug) {
            System.out.println("treenode " + this + " changed.");
        }
        this.m_nodeTree.getTreeModel().nodeChanged(this);
    }

    public synchronized void refresh() {
        if (this.m_children != null) {
            int n;
            Object[] objectArray;
            int n2;
            List list = this.m_de.getChildren();
            int n3 = list.size();
            int n4 = this.m_children.size();
            boolean[] blArray = new boolean[n3];
            SVGNavigatorNode[] sVGNavigatorNodeArray = new SVGNavigatorNode[n4];
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (SVGNavigatorTree.isTreeElement((DocumentElement)list.get(n2))) continue;
                ++n6;
                blArray[n2] = true;
            }
            block1: for (n2 = n4 - 1; n2 >= 0; --n2) {
                objectArray = this.m_children.get(n2);
                for (n = 0; n < n3; ++n) {
                    DocumentElement documentElement;
                    if (blArray[n] || !objectArray.m_de.equals((Object)(documentElement = (DocumentElement)list.get(n)))) continue;
                    byte by = this.m_nodeTree.checkVisibility(documentElement, true);
                    if (by == SVGNavigatorTree.VISIBILITY_NO) {
                        this.m_children.remove(n2);
                        sVGNavigatorNodeArray[n2] = objectArray;
                        ++n5;
                    } else {
                        if (objectArray.m_nodeVisibility != by) {
                            objectArray.m_nodeVisibility = by;
                        }
                        objectArray.refresh();
                    }
                    ++n6;
                    blArray[n] = true;
                    continue block1;
                }
            }
            if (n5 > 0) {
                int[] nArray = new int[n5];
                objectArray = new Object[n5];
                int n7 = 0;
                for (n = 0; n < n4; ++n) {
                    if (sVGNavigatorNodeArray[n] == null) continue;
                    objectArray[n7] = sVGNavigatorNodeArray[n];
                    nArray[n7++] = n;
                }
                this.m_nodeTree.getTreeModel().nodesWereRemoved(this, nArray, objectArray);
                n4 -= n5;
            }
            assert (n4 == this.m_children.size());
            if (n6 < n3) {
                int n8 = 0;
                int n9 = 0;
                int[] nArray = new int[n3 - n6];
                int n10 = 0;
                block4: while (n8 < n4 || n9 < n3) {
                    DocumentElement documentElement = n8 < n4 ? this.m_children.get((int)n8).m_de : null;
                    while (n9 < n3) {
                        byte by;
                        DocumentElement documentElement2 = this.m_de.getElement(n9);
                        if (documentElement2.equals((Object)documentElement)) {
                            ++n8;
                            ++n9;
                            continue block4;
                        }
                        if (!blArray[n9] && (by = this.m_nodeTree.checkVisibility(documentElement2, true)) != SVGNavigatorTree.VISIBILITY_NO) {
                            SVGNavigatorNode sVGNavigatorNode = new SVGNavigatorNode(documentElement2, this.m_nodeTree, this, by);
                            this.m_children.add(n8, sVGNavigatorNode);
                            nArray[n10++] = n8++;
                            ++n4;
                        }
                        ++n9;
                    }
                }
                if (n10 > 0) {
                    if (n10 < nArray.length) {
                        int[] nArray2 = nArray;
                        nArray = new int[n10];
                        System.arraycopy(nArray2, 0, nArray, 0, n10);
                    }
                    this.m_nodeTree.getTreeModel().nodesWereInserted(this, nArray);
                }
            }
        }
    }

    private synchronized void checkChildrenAdapters() {
        if (this.m_children == null) {
            this.m_de.addDocumentElementListener((DocumentElementListener)this);
            this.m_children = new ArrayList<SVGNavigatorNode>();
            for (DocumentElement documentElement : this.m_de.getChildren()) {
                if (SVGNavigatorTree.isTreeElement(documentElement)) {
                    byte by = this.m_nodeTree.checkVisibility(documentElement, true);
                    int n = this.getChildTreeNodeIndex(documentElement);
                    if (n == -1) {
                        if (by == SVGNavigatorTree.VISIBILITY_NO) continue;
                        SVGNavigatorNode sVGNavigatorNode = new SVGNavigatorNode(documentElement, this.m_nodeTree, this, by);
                        this.m_children.add(sVGNavigatorNode);
                        continue;
                    }
                    if (by != SVGNavigatorTree.VISIBILITY_NO) continue;
                    this.m_children.remove(n);
                    continue;
                }
                if (!SVGFileModel.isError(documentElement)) continue;
                this.markNodeAsError(this);
            }
        }
    }
}

