/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items.form;

import java.io.IOException;
import java.util.Collection;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.api.snippets.SVGSnippetsProvider;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.items.form.SVGComponentDrop;
import org.netbeans.modules.mobility.svgcore.items.form.SVGSnipetsProviderClassic;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreSettings;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class SVGFormElement
extends SVGComponentDrop {
    private static final String ID_PATTERN = "%%COMPONENT_ID%%";
    private String myIdPrefix;
    private String mySnippetPath;

    public SVGFormElement(String string, String string2) {
        assert (string != null && string2 != null) : "id prefix or snippet path == null";
        this.myIdPrefix = string;
        this.mySnippetPath = string2;
    }

    protected SVGFormElement(String string) {
        assert (string != null) : "snippet path == null";
        this.myIdPrefix = "";
        this.mySnippetPath = string;
    }

    protected boolean doTransfer(SVGDataObject sVGDataObject) {
        SVGFileModel sVGFileModel = sVGDataObject.getModel();
        try {
            String string = sVGFileModel.createUniqueId(this.myIdPrefix, false);
            String string2 = this.getSnippet(string);
            sVGFileModel.mergeImage(string2, false);
            this.setSelection(string);
            return true;
        }
        catch (Exception exception) {
            SceneManager.error("Error during image merge", exception);
            return false;
        }
    }

    protected boolean doTransfer(JTextComponent jTextComponent) {
        SVGDataObject sVGDataObject = SVGDataObject.getActiveDataObject(jTextComponent);
        final SVGFileModel sVGFileModel = sVGDataObject.getModel();
        try {
            String string = sVGFileModel.createUniqueId(this.myIdPrefix, false);
            String string2 = this.getSnippet(string);
            SVGFormElement.insertToTextComponent(string2, jTextComponent);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    sVGFileModel.forceUpdateModel();
                }
            });
            return true;
        }
        catch (Exception exception) {
            SceneManager.error("Error during image merge", exception);
            return false;
        }
    }

    protected final String loadSnippetString() throws IOException {
        Class clazz = SVGFormElement.getCurrentSnippetsProviderClass();
        return SVGFormElement.loadSnippetString(clazz, this.mySnippetPath);
    }

    private String getSnippet(String string) throws IOException {
        String string2 = this.loadSnippetString();
        String string3 = string2.replace(ID_PATTERN, string);
        return this.replaceCoordinates(string3);
    }

    private static final Class getCurrentSnippetsProviderClass() {
        String string = SvgcoreSettings.getDefault().getCurrentSnippet();
        if (string == null) {
            return SVGSnipetsProviderClassic.class;
        }
        Collection collection = Lookup.getDefault().lookupAll(SVGSnippetsProvider.class);
        for (SVGSnippetsProvider sVGSnippetsProvider : collection) {
            if (!string.equals(sVGSnippetsProvider.getDisplayName())) continue;
            return sVGSnippetsProvider.getClass();
        }
        return SVGSnipetsProviderClassic.class;
    }
}

