/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.j2d.Box;
import java.awt.Color;
import java.awt.Graphics;
import org.w3c.dom.svg.SVGRect;

public abstract class GraphicUtils {
    public static void drawRoundSelectorCorner(Graphics graphics, Color color, Color color2, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.fillOval(n - n3, n2 - n3, n3 * 2 + 1, n3 * 2 + 1);
        graphics.setColor(color2);
        graphics.drawOval(n - (n3 - 1), n2 - (n3 - 1), (n3 - 1) * 2, (n3 - 1) * 2);
    }

    public static void drawDiamondSelectorCorner(Graphics graphics, Color color, Color color2, int n, int n2, int n3) {
        int[] nArray = new int[]{n, n + n3, n, n - n3};
        int[] nArray2 = new int[]{n2 - n3, n2, n2 + n3, n2};
        graphics.setColor(color2);
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.setColor(color);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
    }

    public static boolean areNear(float f, float f2, float f3, float f4, float f5) {
        float f6 = f - f3;
        float f7 = f2 - f4;
        return f6 * f6 + f7 * f7 <= f5;
    }

    public static boolean isNearLine(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        double d = Math.sqrt(f7);
        if ((double)f + d < (double)Math.min(f3, f5) || (double)f - d > (double)Math.max(f3, f5)) {
            return false;
        }
        if ((double)f2 + d < (double)Math.min(f4, f6) || (double)f2 - d > (double)Math.max(f4, f6)) {
            return false;
        }
        double d2 = GraphicUtils.getPointToLineDistance(f, f2, f3, f4, f5, f6);
        return d2 * d2 <= d;
    }

    private static double getPointToLineDistance(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (f4 - f6) * f + (f5 - f3) * f2 + (f3 * f6 - f5 * f4);
        double d = Math.sqrt((f5 - f3) * (f5 - f3) + (f6 - f4) * (f6 - f4));
        return Math.abs((double)f7 / d);
    }

    public static boolean areEqual(SVGRect sVGRect, SVGRect sVGRect2) {
        if (sVGRect == sVGRect2) {
            return true;
        }
        if (sVGRect == null || sVGRect2 == null) {
            return false;
        }
        return sVGRect.getX() == sVGRect2.getX() && sVGRect.getY() == sVGRect2.getY() && sVGRect.getWidth() == sVGRect2.getWidth() && sVGRect.getHeight() == sVGRect2.getHeight();
    }

    public static SVGRect scale(SVGRect sVGRect, float f) {
        return new Box(sVGRect.getX() * f, sVGRect.getY() * f, sVGRect.getWidth() * f, sVGRect.getHeight() * f);
    }

    public static float calcAngle(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        double d = 0.0;
        d = (double)f5 == 0.0 ? ((double)f6 == 0.0 ? 0.0 : ((double)f6 > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : ((double)f6 == 0.0 ? ((double)f5 > 0.0 ? 0.0 : Math.PI) : ((double)f5 < 0.0 ? Math.atan(f6 / f5) + Math.PI : ((double)f6 < 0.0 ? Math.atan(f6 / f5) + Math.PI * 2 : Math.atan(f6 / f5))));
        d = d * 180.0 / Math.PI;
        return (float)d;
    }
}

