/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NewProjectIterator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectProjectPanel
extends BasicWizardIterator.Panel {
    private NewProjectIterator.DataModel data;
    private final Object EMPTY = SelectProjectPanel.getMessage("MSG_No_Projects");
    private JButton btnProject;
    private JComboBox comProject;
    private JLabel lblProject;
    private JPanel pnlHeightAdjuster;

    public SelectProjectPanel(WizardDescriptor wizardDescriptor, NewProjectIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", SelectProjectPanel.getMessage("LBL_ProjectWizardTitle"));
        this.loadComboBox();
        this.comProject.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SelectProjectPanel.this.checkValidity();
            }
        });
        this.comProject.setRenderer(UIUtil.createProjectRenderer());
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SelectProjectPanel.class, (String)string);
    }

    private void initComponents() {
        this.lblProject = new JLabel();
        this.comProject = new JComboBox();
        this.btnProject = new JButton();
        this.pnlHeightAdjuster = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblProject.setLabelFor(this.comProject);
        Mnemonics.setLocalizedText((JLabel)this.lblProject, (String)NbBundle.getMessage(SelectProjectPanel.class, (String)"LBL_Project_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.lblProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.comProject, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnProject, (String)NbBundle.getMessage(SelectProjectPanel.class, (String)"LBL_Browse"));
        this.btnProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectProjectPanel.this.btnProjectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.btnProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.pnlHeightAdjuster, gridBagConstraints);
    }

    private void btnProjectActionPerformed(ActionEvent actionEvent) {
        File file;
        FileObject fileObject;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        int n = jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this));
        if (n == 0 && (fileObject = FileUtil.toFileObject((File)(file = jFileChooser.getSelectedFile()))) != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comProject.getModel();
                defaultComboBoxModel.addElement(project);
                defaultComboBoxModel.setSelectedItem(project);
                if (this.EMPTY == defaultComboBoxModel.getElementAt(0)) {
                    defaultComboBoxModel.removeElement(this.EMPTY);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected void storeToDataModel() {
        this.data.setTemplate((Project)this.comProject.getSelectedItem());
    }

    protected void readFromDataModel() {
        this.checkValidity();
    }

    private void loadComboBox() {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(projectArray, Util.projectDisplayNameComparator());
        for (int i = 0; i < projectArray.length; ++i) {
            if (projectArray[i] == this.data.getProject()) continue;
            defaultComboBoxModel.addElement(projectArray[i]);
        }
        if (defaultComboBoxModel.getSize() == 0) {
            defaultComboBoxModel.addElement(this.EMPTY);
        }
        this.comProject.setModel(defaultComboBoxModel);
    }

    private void checkValidity() {
        Object object = this.comProject.getModel().getSelectedItem();
        if (object == this.EMPTY) {
            this.setError(SelectProjectPanel.getMessage("MSG_NoProjectSelected"));
            return;
        }
        Sources sources = ProjectUtils.getSources((Project)((Project)object));
        if (sources.getSourceGroups("generic").length > 1) {
            this.setError(SelectProjectPanel.getMessage("MSG_NoExternalRoots"));
            return;
        }
        this.markValid();
    }

    protected String getPanelName() {
        return SelectProjectPanel.getMessage("LBL_ProjectSelection_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(SelectProjectPanel.class);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(SelectProjectPanel.getMessage("ACS_SelectProjectPanel"));
        this.btnProject.getAccessibleContext().setAccessibleDescription(SelectProjectPanel.getMessage("ACS_CTL_btnProject"));
        this.comProject.getAccessibleContext().setAccessibleDescription(SelectProjectPanel.getMessage("ACS_CTL_comProject"));
    }
}

