/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.TypeChooserPanelImpl;
import org.netbeans.modules.apisupport.project.ui.wizard.spi.ModuleTypePanel;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BasicInfoVisualPanel
extends BasicVisualPanel.NewTemplatePanel
implements PropertyChangeListener {
    private boolean locationUpdated;
    private boolean nameUpdated;
    private boolean mainProjectTouched;
    private static int validityCounter = 0;
    private int validityId = ++validityCounter;
    private boolean internalUpdate = false;
    private JButton browseButton;
    private JLabel filler;
    private JLabel folderLbl;
    private JTextField folderValue;
    private JPanel infoPanel;
    private JLabel locationLbl;
    private JTextField locationValue;
    private JCheckBox mainProject;
    private JButton manageSuitePlatform;
    private ButtonGroup moduleTypeGroup;
    private JLabel nameLbl;
    JTextField nameValue;
    private JPanel pnlThouShaltBeholdLayout;
    private JSeparator separator3;
    private JLabel suitePlatform;
    private JComboBox suitePlatformValue;
    private JPanel typeChooserPanelContainer;
    private TypeChooserPanelImpl typeChooserPanel;

    BasicInfoVisualPanel(NewModuleProjectData newModuleProjectData) {
        super(newModuleProjectData);
        this.initComponents();
        BasicInfoVisualPanel.initPlatformCombo(this.suitePlatformValue);
        this.initPanels();
        this.setComponentsVisibility();
        switch (newModuleProjectData.getWizardType()) {
            case SUITE: 
            case APPLICATION: 
            case LIBRARY_MODULE: {
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                if (TypeChooserPanelImpl.getDefaultSuitesComboBox().getItemCount() <= 0) break;
                this.mainProject.setSelected(false);
                break;
            }
            default: {
                assert (false) : "Unknown wizard type = " + (Object)((Object)newModuleProjectData.getWizardType());
                break;
            }
        }
        this.attachDocumentListeners();
        this.setInitialLocation();
        this.setInitialProjectName();
        this.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
    }

    protected static boolean isNetBeansOrgFolder(File file) {
        return ModuleList.findNetBeansOrg(file) != null;
    }

    protected static void initPlatformCombo(JComboBox jComboBox) {
        if (jComboBox == null) {
            return;
        }
        if (jComboBox.getItemCount() <= 0) {
            return;
        }
        boolean bl = false;
        String string = ModuleUISettings.getDefault().getLastUsedPlatformID();
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!((NbPlatform)jComboBox.getItemAt(i)).getID().equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            NbPlatform nbPlatform = NbPlatform.getDefaultPlatform();
            jComboBox.setSelectedItem(nbPlatform == null ? jComboBox.getItemAt(0) : nbPlatform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (ModuleTypePanel.isPanelUpdated(propertyChangeEvent) && !this.internalUpdate && validityCounter == this.validityId) {
            try {
                this.internalUpdate = true;
                boolean bl = ModuleTypePanel.isStandalone(this.getSettings());
                boolean bl2 = ModuleTypePanel.isSuiteComponent(this.getSettings());
                if (!bl && !bl2) {
                    return;
                }
                if (!this.mainProjectTouched) {
                    this.mainProject.setSelected(bl);
                }
                if (!this.locationUpdated) {
                    this.setInitialLocation();
                }
                if (!this.nameUpdated) {
                    this.setInitialProjectName();
                }
            }
            finally {
                this.internalUpdate = false;
            }
            this.updateAndCheck();
        }
    }

    private void setInitialLocation() {
        if (ModuleTypePanel.isSuiteComponent(this.getSettings())) {
            this.computeAndSetLocation(ModuleTypePanel.getSuiteRoot(this.getSettings()), true);
        } else {
            String string = this.computeLocationValue(ProjectChooser.getProjectsFolder().getAbsolutePath());
            File file = new File(string);
            if (SuiteUtils.isSuite(file)) {
                this.computeAndSetLocation(file.getParent(), true);
            } else {
                this.setLocation(string, true);
            }
        }
    }

    private void initPanels() {
        if (this.typeChooserPanel != null) {
            this.typeChooserPanelContainer.remove(this.typeChooserPanel);
            this.typeChooserPanel = null;
        }
        this.typeChooserPanel = new TypeChooserPanelImpl(this.getSettings(), this.getData().getWizardType());
        this.typeChooserPanelContainer.add(this.typeChooserPanel);
        this.typeChooserPanelContainer.validate();
        this.validate();
    }

    private void setComponentsVisibility() {
        boolean bl = this.isSuiteWizard();
        boolean bl2 = this.isSuiteComponentWizard();
        boolean bl3 = this.isLibraryWizard();
        this.typeChooserPanel.setVisible(!bl);
        this.suitePlatform.setVisible(bl);
        this.suitePlatformValue.setVisible(bl);
        this.manageSuitePlatform.setVisible(bl);
        this.mainProject.setVisible(!bl3);
        this.mainProject.setSelected(!bl3);
        if (this.typeChooserPanel != null) {
            this.typeChooserPanel.setComponentsVisibility(bl2, bl3);
        }
    }

    private String getNameValue() {
        return this.nameValue.getText().trim();
    }

    private String getLocationValue() {
        return this.locationValue.getText().trim();
    }

    private File getLocationFile() {
        return new File(this.getLocationValue());
    }

    void updateAndCheck() {
        this.updateGUI();
        if ("".equals(this.getNameValue())) {
            this.setInfo(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_NameCannotBeEmpty"), false);
        } else if ("".equals(this.getLocationValue())) {
            this.setInfo(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LocationCannotBeEmpty"), false);
        } else if (this.isLibraryWizard() && this.isNetBeansOrgFolder()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LibraryWrapperForNBOrgUnsupported"));
        } else if (!ModuleTypePanel.validate(this.getSettings())) {
            this.setError((String)this.getSettings().getProperty("WizardPanel_errorMessage"));
        } else if (this.isSuiteWizard() && (this.suitePlatformValue.getSelectedItem() == null || !((NbPlatform)this.suitePlatformValue.getSelectedItem()).isValid())) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_ChosenPlatformIsInvalid"));
        } else if (this.getFolder().exists()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_ProjectFolderExists"));
        } else if (!this.getLocationFile().exists()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LocationMustExist"));
        } else if (!this.getLocationFile().canWrite()) {
            this.setError(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_LocationNotWritable"));
        } else {
            this.markValid();
        }
    }

    private void updateGUI() {
        if (this.internalUpdate) {
            return;
        }
        this.folderValue.setText(this.getFolder().getPath());
        Logger.getLogger(BasicInfoVisualPanel.class.getName()).log(Level.FINE, "(" + this.validityId + ") Setting project folder to '" + this.getFolder().getPath() + "'");
        ModuleTypePanel.setProjectFolder(this.getSettings(), this.getFolder());
    }

    private void setProjectName(String string, int n) {
        String string2;
        while ((string2 = this.validFreeModuleName(string, n)) == null) {
            ++n;
        }
        this.nameValue.setText(string2);
    }

    private String validFreeModuleName(String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file = new File(this.getLocationValue(), string2);
        return file.exists() ? null : string2;
    }

    void storeData() {
        this.getData().setProjectName(this.getNameValue());
        this.getData().setProjectLocation(this.getLocationValue());
        this.getData().setProjectFolder(this.folderValue.getText());
        this.getData().setMainProject(this.mainProject.isSelected());
        this.getData().setNetBeansOrg(this.isNetBeansOrgFolder());
        this.getData().setStandalone(ModuleTypePanel.isStandalone(this.getSettings()));
        this.getData().setSuiteRoot(ModuleTypePanel.getSuiteRoot(this.getSettings()));
        if (this.isSuiteWizard() && this.suitePlatformValue.getSelectedItem() != null) {
            this.getData().setPlatformID(((NbPlatform)this.suitePlatformValue.getSelectedItem()).getID());
        } else if (ModuleTypePanel.getActivePlatformId(this.getSettings()) != null) {
            this.getData().setPlatformID(ModuleTypePanel.getActivePlatformId(this.getSettings()));
        }
    }

    void refreshData() {
        if (this.getData().getProjectName() != null) {
            this.nameValue.setText(this.getData().getProjectName());
        } else {
            this.setInitialProjectName();
        }
    }

    private void setInitialProjectName() {
        String string = null;
        int n = 0;
        switch (this.getData().getWizardType()) {
            case SUITE: 
            case APPLICATION: {
                n = ModuleUISettings.getDefault().getNewSuiteCounter() + 1;
                string = "TXT_Suite";
                this.getData().setSuiteCounter(n);
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                n = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                string = "TXT_Module";
                this.getData().setModuleCounter(n);
                break;
            }
            case LIBRARY_MODULE: {
                n = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                string = "TXT_Library";
                this.getData().setModuleCounter(n);
                break;
            }
            default: {
                assert (false) : "Unknown wizard type = " + (Object)((Object)this.getData().getWizardType());
                break;
            }
        }
        this.setProjectName(NbBundle.getMessage(BasicInfoVisualPanel.class, string), n);
        this.nameValue.select(0, this.nameValue.getText().length());
        this.nameUpdated = false;
    }

    private void attachDocumentListeners() {
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.nameValue.getDocument().addDocumentListener(documentAdapter);
        this.nameValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicInfoVisualPanel.this.nameUpdated = true;
            }
        });
        this.locationValue.getDocument().addDocumentListener(documentAdapter);
        this.locationValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicInfoVisualPanel.this.locationUpdated = true;
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.suitePlatformValue.addActionListener(actionListener);
        this.getSettings().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.getSettings()));
    }

    private File getFolder() {
        StringBuffer stringBuffer = new StringBuffer(this.getLocationValue());
        if (stringBuffer.length() != 0) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(this.getNameValue());
        return FileUtil.normalizeFile((File)new File(stringBuffer.toString()));
    }

    private boolean isNetBeansOrgFolder() {
        return BasicInfoVisualPanel.isNetBeansOrgFolder(this.getFolder());
    }

    private void setLocation(String string, boolean bl) {
        boolean bl2 = bl && !this.locationUpdated;
        this.locationValue.setText(string);
        this.locationUpdated = bl2 ^ true;
    }

    private void computeAndSetLocation(String string, boolean bl) {
        this.setLocation(this.computeLocationValue(string), bl);
    }

    private String computeLocationValue(String string) {
        File file;
        if (string == null) {
            string = System.getProperty("user.home");
        }
        if (!(file = new File(string)).exists() && file.getParent() != null) {
            return this.computeLocationValue(file.getParent());
        }
        return file.exists() ? string : System.getProperty("user.home");
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.infoPanel = new JPanel();
        this.nameLbl = new JLabel();
        this.locationLbl = new JLabel();
        this.folderLbl = new JLabel();
        this.nameValue = new JTextField();
        this.locationValue = new JTextField();
        this.browseButton = new JButton();
        this.filler = new JLabel();
        this.folderValue = new JTextField();
        this.suitePlatform = new JLabel();
        this.suitePlatformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.manageSuitePlatform = new JButton();
        this.separator3 = new JSeparator();
        this.mainProject = new JCheckBox();
        this.pnlThouShaltBeholdLayout = new JPanel();
        this.typeChooserPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.nameLbl.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.nameLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.nameLbl, gridBagConstraints);
        this.locationLbl.setLabelFor(this.locationValue);
        Mnemonics.setLocalizedText((JLabel)this.locationLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.locationLbl, gridBagConstraints);
        this.folderLbl.setLabelFor(this.folderValue);
        Mnemonics.setLocalizedText((JLabel)this.folderLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.folderLbl, gridBagConstraints);
        this.nameValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.nameValue, gridBagConstraints);
        this.nameValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_NameValue"));
        this.nameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_NameValue"));
        this.locationValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.locationValue, gridBagConstraints);
        this.locationValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_LocationValue"));
        this.locationValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_LocationValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.browseLocation(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_BrowseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_BrowseButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        this.infoPanel.add((Component)this.filler, gridBagConstraints);
        this.folderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.infoPanel.add((Component)this.folderValue, gridBagConstraints);
        this.folderValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_FolderValue"));
        this.folderValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_FolderValue"));
        this.suitePlatform.setLabelFor(this.suitePlatformValue);
        Mnemonics.setLocalizedText((JLabel)this.suitePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.suitePlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.suitePlatformValue, gridBagConstraints);
        this.suitePlatformValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_SuitePlatformValue"));
        this.suitePlatformValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_SuitePlatformValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageSuitePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_ManagePlatforms_g"));
        this.manageSuitePlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.manageSuitePlatformActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.manageSuitePlatform, gridBagConstraints);
        this.manageSuitePlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_ManageSuitePlatform"));
        this.manageSuitePlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_ManageSuitePlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.infoPanel.add((Component)this.separator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoPanel, gridBagConstraints);
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_SetAsMainProject"));
        this.mainProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.mainProjectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.mainProject, gridBagConstraints);
        this.mainProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_MainProject"));
        this.mainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_CTL_MainProject"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlThouShaltBeholdLayout, gridBagConstraints);
        this.typeChooserPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.typeChooserPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_BasicInfoVisualPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"ACS_BasicInfoVisualPanel"));
    }

    private void manageSuitePlatformActionPerformed(ActionEvent actionEvent) {
        this.managePlatform(this.suitePlatformValue);
    }

    private void mainProjectActionPerformed(ActionEvent actionEvent) {
        this.mainProjectTouched = true;
    }

    private void managePlatform(JComboBox jComboBox) {
        NbPlatformCustomizer.showCustomizer();
        jComboBox.setModel(new PlatformComponentFactory.NbPlatformListModel());
        jComboBox.requestFocus();
        this.updateAndCheck();
    }

    private void browseLocation(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.getLocationValue());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.computeAndSetLocation(jFileChooser.getSelectedFile().getAbsolutePath(), false);
        }
    }
}

