/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ModuleProjectClassPathExtender
extends ProjectClassPathModifierImplementation {
    private static final String LAYOUT_MODULE = "org.jdesktop.layout";
    private static final String JUNIT_MODULE = "org.netbeans.libs.junit4";
    private static final String NBJUNIT_MODULE = "org.netbeans.modules.nbjunit";
    private final NbModuleProject project;

    public ModuleProjectClassPathExtender(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    protected SourceGroup[] getExtensibleSourceGroups() {
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>(2);
        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) {
            if (sourceGroup.getRootFolder() != this.project.getSourceDirectory() && sourceGroup.getRootFolder() != this.project.getTestSourceDirectory("unit")) continue;
            arrayList.add(sourceGroup);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile"};
    }

    protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        boolean bl = false;
        if (libraryArray.length == 0) {
            return false;
        }
        for (Library library : libraryArray) {
            Object object;
            String string2 = library.getName();
            if ("swing-layout".equals(string2)) {
                object = this.project.getModuleList().getEntry(LAYOUT_MODULE);
                if (object != null) {
                    boolean bl2 = Util.addDependency(this.project, LAYOUT_MODULE);
                    bl = bl || bl2;
                    continue;
                }
                IOException iOException = new IOException("no module org.jdesktop.layout");
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_could_not_find_module", (Object)LAYOUT_MODULE));
                throw iOException;
            }
            if ("junit_4".equals(string2)) {
                try {
                    ModuleProjectClassPathExtender.resolveJUnitDependencies(this.project, "unit", true);
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().indexOf(NBJUNIT_MODULE) != -1) {
                        ModuleProjectClassPathExtender.resolveJUnitDependencies(this.project, "unit", false);
                    }
                    throw iOException;
                }
                bl = true;
                continue;
            }
            object = new IOException("unknown lib " + string2);
            Exceptions.attachLocalizedMessage((Throwable)object, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_unsupported_library", (Object)library.getDisplayName()));
            throw object;
        }
        if (bl) {
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        return bl;
    }

    protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2;
        UnsupportedOperationException unsupportedOperationException;
        block3: {
            unsupportedOperationException = new UnsupportedOperationException("not implemented: " + Arrays.asList(uRLArray));
            String string3 = string2 = uRLArray.length > 0 ? uRLArray[0].toString() : "<nothing>";
            if (uRLArray.length > 0 && "file".equals(uRLArray[0].getProtocol())) {
                try {
                    string2 = new File(uRLArray[0].toURI()).getAbsolutePath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)uRISyntaxException);
                }
            }
        }
        Exceptions.attachLocalizedMessage((Throwable)unsupportedOperationException, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)string2));
        throw unsupportedOperationException;
    }

    protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2;
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("not implemented: " + Arrays.asList(uRIArray));
        String string3 = string2 = uRIArray.length > 0 ? uRIArray[0].toString() : "<nothing>";
        if (uRIArray.length > 0 && "file".equals(uRIArray[0].getScheme())) {
            string2 = new File(uRIArray[0]).getAbsolutePath();
        }
        Exceptions.attachLocalizedMessage((Throwable)unsupportedOperationException, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)string2));
        throw unsupportedOperationException;
    }

    protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static void resolveJUnitDependencies(NbModuleProject nbModuleProject, String string, boolean bl) throws IOException {
        ModuleList moduleList = nbModuleProject.getModuleList();
        ModuleEntry moduleEntry = moduleList.getEntry(JUNIT_MODULE);
        ModuleEntry moduleEntry2 = moduleList.getEntry(NBJUNIT_MODULE);
        if (moduleEntry == null || bl && moduleEntry2 == null) {
            String string2 = moduleEntry == null ? JUNIT_MODULE : NBJUNIT_MODULE;
            IOException iOException = new IOException("no module " + string2);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_could_not_find_module", (Object)string2));
            throw iOException;
        }
        ProjectXMLManager projectXMLManager = new ProjectXMLManager(nbModuleProject);
        projectXMLManager.addTestDependency(string, new TestModuleDependency(moduleEntry, false, false, true));
        if (bl) {
            projectXMLManager.addTestDependency(string, new TestModuleDependency(moduleEntry2, false, true, true));
        }
    }
}

