/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreatedModifiedFiles {
    private final SortedSet<String> createdPaths = new TreeSet<String>();
    private final SortedSet<String> modifiedPaths = new TreeSet<String>();
    private final SortedSet<String> invalidPaths = new TreeSet<String>();
    private final Project project;
    private final List<Operation> operations = new ArrayList<Operation>();
    private LayerUtils.LayerHandle layerHandle;

    LayerUtils.LayerHandle getLayerHandle() {
        if (this.layerHandle == null) {
            this.layerHandle = LayerUtils.layerForProject(this.project);
        }
        return this.layerHandle;
    }

    public CreatedModifiedFiles(Project project) {
        this.project = project;
    }

    public void add(Operation operation) {
        this.operations.add(operation);
        this.createdPaths.addAll(Arrays.asList(operation.getCreatedPaths()));
        this.modifiedPaths.addAll(Arrays.asList(operation.getModifiedPaths()));
        this.invalidPaths.addAll(Arrays.asList(operation.getInvalidPaths()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        boolean bl = false;
        if (this.layerHandle != null) {
            bl = this.layerHandle.isAutosave();
            this.layerHandle.setAutosave(false);
        }
        try {
            for (Operation operation : this.operations) {
                operation.run();
            }
            if (this.layerHandle != null) {
                this.layerHandle.save();
            }
        }
        finally {
            if (this.layerHandle != null) {
                this.layerHandle.setAutosave(bl);
            }
        }
    }

    public String[] getCreatedPaths() {
        if (this.createdPaths == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.createdPaths.size()];
        return this.createdPaths.toArray(stringArray);
    }

    public String[] getModifiedPaths() {
        if (this.modifiedPaths == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.modifiedPaths.size()];
        return this.modifiedPaths.toArray(stringArray);
    }

    public String[] getInvalidPaths() {
        if (this.invalidPaths == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.invalidPaths.size()];
        return this.invalidPaths.toArray(stringArray);
    }

    public static FileObject getTemplate(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)("Templates/NetBeansModuleDevelopment-files/" + string));
        assert (fileObject != null) : string;
        return fileObject;
    }

    public Operation createFile(String string, FileObject fileObject) {
        return CreatedModifiedFilesFactory.createFile(this.project, string, fileObject);
    }

    public Operation createFileWithSubstitutions(String string, FileObject fileObject, Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return CreatedModifiedFilesFactory.createFileWithSubstitutions(this.project, string, fileObject, map);
    }

    public Operation bundleKey(String string, String string2, String string3) {
        return CreatedModifiedFilesFactory.bundleKey(this.project, string2, string3, string);
    }

    public Operation bundleKeyDefaultBundle(String string, String string2) {
        return CreatedModifiedFilesFactory.bundleKeyDefaultBundle(this.project, string, string2);
    }

    public Operation addLoaderSection(String string, String string2) {
        return CreatedModifiedFilesFactory.addLoaderSection(this.project, string, string2);
    }

    public Operation addLookupRegistration(String string, String string2, boolean bl) {
        return CreatedModifiedFilesFactory.addLookupRegistration(this.project, string, string2, bl);
    }

    public Operation addModuleDependency(String string, String string2, SpecificationVersion specificationVersion, boolean bl) {
        return CreatedModifiedFilesFactory.addModuleDependency(this.project, string, string2, specificationVersion, bl);
    }

    public Operation addModuleDependency(String string) {
        return this.addModuleDependency(string, null, null, true);
    }

    public Operation createLayerEntry(String string, FileObject fileObject, Map<String, String> map, String string2, Map<String, Object> map2) {
        return CreatedModifiedFilesFactory.createLayerEntry(this, this.project, string, fileObject, map, string2, map2);
    }

    public Operation manifestModification(String string, Map<String, String> map) {
        return CreatedModifiedFilesFactory.manifestModification(this.project, string, map);
    }

    public Operation propertiesModification(String string, Map<String, String> map) {
        return CreatedModifiedFilesFactory.propertiesModification(this.project, string, map);
    }

    public Operation createLayerAttribute(final String string, final String string2, final Object object) {
        return this.layerModifications(new LayerOperation(){

            public void run(FileSystem fileSystem) throws IOException {
                FileObject fileObject = fileSystem.findResource(string);
                if (fileObject == null) {
                    throw new IOException(string);
                }
                fileObject.setAttribute(string2, object);
            }
        }, Collections.<String>emptySet());
    }

    public Operation orderLayerEntry(final String string, final String string2, final String string3, final String string4) {
        return this.layerModifications(new LayerOperation(){

            public void run(FileSystem fileSystem) throws IOException {
                FileObject fileObject = fileSystem.findResource(string);
                if (fileObject == null) {
                    throw new IOException("No such folder " + string);
                }
                FileObject fileObject2 = LayerUtils.getEffectiveSystemFilesystem(CreatedModifiedFiles.this.project).findResource(string);
                assert (fileObject2 != null) : string;
                Integer n = this.getPosition(fileObject2, string2);
                Integer n2 = this.getPosition(fileObject2, string4);
                if (n != null && n2 != null) {
                    fileObject.getFileObject(string3).setAttribute("position", (Object)((n + n2) / 2));
                } else if (n != null) {
                    fileObject.getFileObject(string3).setAttribute("position", (Object)(n + 100));
                } else if (n2 != null) {
                    fileObject.getFileObject(string3).setAttribute("position", (Object)(n2 - 100));
                } else {
                    if (string2 != null) {
                        fileObject.setAttribute(string2 + '/' + string3, (Object)true);
                    }
                    if (string4 != null) {
                        fileObject.setAttribute(string3 + '/' + string4, (Object)true);
                    }
                }
            }

            private Integer getPosition(FileObject fileObject, String string5) {
                if (string5 == null) {
                    return null;
                }
                FileObject fileObject2 = fileObject.getFileObject(string5);
                if (fileObject2 == null) {
                    return null;
                }
                Object object = fileObject2.getAttribute("position");
                return object instanceof Integer ? (Integer)object : null;
            }
        }, Collections.<String>emptySet());
    }

    public Operation layerModifications(LayerOperation layerOperation, Set<String> set) {
        return CreatedModifiedFilesFactory.layerModifications(this.project, layerOperation, set, this);
    }

    public Operation packageInfo(String string, Map<String, Map<String, Object>> map) {
        return CreatedModifiedFilesFactory.packageInfo(this.project, string, map);
    }

    public static interface LayerOperation {
        public void run(FileSystem var1) throws IOException;
    }

    public static interface Operation {
        public void run() throws IOException;

        public String[] getModifiedPaths();

        public String[] getCreatedPaths();

        public String[] getInvalidPaths();
    }
}

