/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.DocumentProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.parsing.api.Source;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileObject
implements DocumentProvider,
FileObjects.InferableJavaFileObject {
    final FileObject file;
    final FileObject root;
    private final JavaFileObject.Kind kind;
    private URI uri;
    private volatile String text;
    private TokenHierarchy<?> tokens;
    private final JavaFileFilterImplementation filter;
    private static Logger log = Logger.getLogger(SourceFileObject.class.getName());

    public static SourceFileObject create(FileObject fileObject, FileObject fileObject2) {
        try {
            return new SourceFileObject(fileObject, fileObject2, null, false);
        }
        catch (IOException iOException) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            return null;
        }
    }

    public SourceFileObject(FileObject fileObject, FileObject fileObject2, JavaFileFilterImplementation javaFileFilterImplementation, CharSequence charSequence) throws IOException {
        this(fileObject, fileObject2, javaFileFilterImplementation);
        this.update(charSequence);
    }

    public SourceFileObject(FileObject fileObject, FileObject fileObject2, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl) throws IOException {
        this(fileObject, fileObject2, javaFileFilterImplementation);
        if (bl) {
            this.update();
        }
    }

    private SourceFileObject(FileObject fileObject, FileObject fileObject2, JavaFileFilterImplementation javaFileFilterImplementation) {
        assert (fileObject != null);
        this.file = fileObject;
        this.root = fileObject2;
        this.filter = javaFileFilterImplementation;
        String string = this.file.getExt();
        this.kind = javaFileFilterImplementation == null ? FileObjects.getKind(string) : JavaFileObject.Kind.SOURCE;
    }

    public void update() throws IOException {
        if (this.kind != JavaFileObject.Kind.CLASS) {
            this.getContent(true);
        }
    }

    public void update(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.update();
        } else {
            this.text = this.toString(charSequence);
        }
        this.tokens = null;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        assert (string != null);
        return this.kind == kind && this.getNameWithoutExtension().equals(string);
    }

    @Override
    public CharBuffer getCharContent(boolean bl) throws IOException {
        String string = this.text;
        if (string == null) {
            string = this.getContent(false);
        }
        return CharBuffer.wrap(string);
    }

    public TokenHierarchy<?> getTokenHierarchy() throws IOException {
        if (this.tokens == null) {
            CharBuffer charBuffer = this.getCharContent(true);
            this.tokens = TokenHierarchy.create((CharSequence)charBuffer, (boolean)false, (Language)JavaTokenId.language(), null, null);
        }
        return this.tokens;
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), FileEncodingQuery.getEncoding((FileObject)this.file));
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        String string = this.text;
        if (string == null) {
            string = this.getContent(false);
        }
        return new StringReader(string);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return new LckStream(this.file);
        }
        return new DocumentStream(styledDocument);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        String string = this.text;
        if (string == null) {
            string = this.getContent(false);
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete() {
        boolean bl;
        if (this.isModified() != null) {
            return false;
        }
        FileLock fileLock = this.file.lock();
        try {
            this.file.delete(fileLock);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                fileLock.releaseLock();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        fileLock.releaseLock();
        return bl;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.file.getNameExt();
    }

    public String getNameWithoutExtension() {
        return this.file.getName();
    }

    @Override
    public synchronized URI toUri() {
        block3: {
            if (this.uri == null) {
                try {
                    this.uri = URI.create(this.file.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if (!log.isLoggable(Level.SEVERE)) break block3;
                    log.log(Level.SEVERE, fileStateInvalidException.getMessage(), fileStateInvalidException);
                }
            }
        }
        return this.uri;
    }

    @Override
    public long getLastModified() {
        if (this.isModified() == null) {
            try {
                if (this.file.getFileSystem() instanceof JarFileSystem) {
                    return 0L;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return this.file.lastModified().getTime();
        }
        return System.currentTimeMillis();
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public String inferBinaryName() {
        if (this.root == null) {
            return null;
        }
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.file);
        assert (string != null) : "root=" + FileUtil.getFileDisplayName((FileObject)this.root) + ", file=" + FileUtil.getFileDisplayName((FileObject)this.file);
        int n = string.lastIndexOf(46);
        assert (n > 0);
        String string2 = string.substring(0, n).replace('/', '.');
        return string2;
    }

    public String toString() {
        return this.file.getPath();
    }

    public boolean equals(Object object) {
        if (object instanceof SourceFileObject) {
            SourceFileObject sourceFileObject = (SourceFileObject)object;
            return this.file.equals(sourceFileObject.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public StyledDocument getDocument() {
        Source source = Source.create((FileObject)this.file);
        if (source == null) {
            return null;
        }
        Document document = source.getDocument(false);
        return document instanceof StyledDocument ? (StyledDocument)document : null;
    }

    @Override
    public void runAtomic(Runnable runnable) {
        assert (runnable != null);
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            throw new IllegalStateException();
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
    }

    private EditorCookie isModified() {
        DataObject.Registry registry = DataObject.getRegistry();
        Set set = registry.getModifiedSet();
        for (DataObject dataObject : set) {
            if (!this.file.equals(dataObject.getPrimaryFile())) continue;
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            return editorCookie;
        }
        return null;
    }

    private String getContent(boolean bl) throws IOException {
        Source source = Source.create((FileObject)this.file);
        if (source == null) {
            throw new IOException("No source for: " + FileUtil.getFileDisplayName((FileObject)this.file));
        }
        CharSequence charSequence = this.toString(source.createSnapshot().getText());
        if (source.getDocument(false) != null && this.filter != null) {
            charSequence = this.filter.filterCharSequence(charSequence);
        }
        String string = this.toString(charSequence);
        if (bl) {
            this.text = string;
        }
        return string;
    }

    private String toString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument styledDocument) {
            assert (styledDocument != null);
            this.doc = styledDocument;
            this.data = new byte[2048];
            this.pos = 0;
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureSize(n2);
            System.arraycopy(byArray, n, this.data, this.pos, n2);
            this.pos += n2;
        }

        public synchronized void write(byte[] byArray) throws IOException {
            this.ensureSize(byArray.length);
            System.arraycopy(byArray, 0, this.data, this.pos, byArray.length);
            this.pos += byArray.length;
        }

        public synchronized void write(int n) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(n & 0xFF);
        }

        private void ensureSize(int n) {
            int n2 = this.pos + n;
            if (this.data.length < n2) {
                int n3;
                for (n3 = this.data.length + 2048; n3 < n2; n3 += 2048) {
                }
                byte[] byArray = new byte[n3];
                System.arraycopy(this.data, 0, byArray, 0, this.pos);
                this.data = byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            try {
                NbDocument.runAtomic((StyledDocument)this.doc, (Runnable)new Runnable(){

                    public void run() {
                        block4: {
                            try {
                                DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                                DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, FileEncodingQuery.getEncoding((FileObject)SourceFileObject.this.file).name()), null);
                            }
                            catch (BadLocationException badLocationException) {
                                if (log.isLoggable(Level.SEVERE)) {
                                    log.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                                }
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                if (!log.isLoggable(Level.SEVERE)) break block4;
                                log.log(Level.SEVERE, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                            }
                        }
                    }
                });
            }
            finally {
                SourceFileObject.this.text = null;
            }
        }
    }

    private class LckStream
    extends OutputStream {
        private final OutputStream delegate;
        private final FileLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LckStream(FileObject fileObject) throws IOException {
            assert (fileObject != null);
            this.lock = fileObject.lock();
            try {
                this.delegate = fileObject.getOutputStream(this.lock);
            }
            finally {
                if (this.delegate == null) {
                    this.lock.releaseLock();
                }
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.delegate.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate.write(byArray);
        }

        public void write(int n) throws IOException {
            this.delegate.write(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.lock.releaseLock();
                SourceFileObject.this.text = null;
            }
        }
    }
}

