/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FastJar;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingArchive
implements Archive {
    private static final Logger LOGGER = Logger.getLogger(CachingArchive.class.getName());
    private final File archiveFile;
    private final boolean keepOpened;
    private ZipFile zipFile;
    byte[] names;
    private int nameOffset = 0;
    static final int[] EMPTY = new int[0];
    private Map<String, Folder> folders;

    public CachingArchive(File file, boolean bl) {
        this.archiveFile = file;
        this.keepOpened = bl;
    }

    @Override
    public Iterable<JavaFileObject> getFiles(String string, ClassPath.Entry entry, Set<JavaFileObject.Kind> set, JavaFileFilterImplementation javaFileFilterImplementation) throws IOException {
        Map<String, Folder> map = this.doInit();
        Folder folder = map.get(string);
        if (folder == null) {
            return Collections.emptyList();
        }
        assert (!this.keepOpened || this.zipFile != null);
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>(folder.idx / folder.delta);
        for (int i = 0; i < folder.idx; i += folder.delta) {
            this.create(string, folder, i, set, arrayList);
        }
        return arrayList;
    }

    private String getString(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.names, n, byArray, 0, n2);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("No UTF-8");
        }
    }

    static long join(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private void create(String string, Folder folder, int n, Set<JavaFileObject.Kind> set, List<? super JavaFileObject> list) {
        String string2 = this.getString(folder.indices[n], folder.indices[n + 1]);
        if (set == null || set.contains((Object)FileObjects.getKind(FileObjects.getExtension(string2)))) {
            long l = CachingArchive.join(folder.indices[n + 3], folder.indices[n + 2]);
            if (this.zipFile == null) {
                if (folder.delta == 4) {
                    list.add(FileObjects.zipFileObject(this.archiveFile, string, string2, l));
                } else {
                    assert (folder.delta == 6);
                    long l2 = CachingArchive.join(folder.indices[n + 5], folder.indices[n + 4]);
                    list.add(FileObjects.zipFileObject(this.archiveFile, string, string2, l, l2));
                }
            } else {
                list.add(FileObjects.zipFileObject(this.zipFile, string, string2, l));
            }
        }
    }

    @Override
    public synchronized void clear() {
        this.folders = null;
        this.names = null;
        this.nameOffset = 0;
    }

    synchronized Map<String, Folder> doInit() {
        block5: {
            if (this.folders == null) {
                try {
                    this.names = new byte[16384];
                    this.folders = this.createMap(this.archiveFile);
                    this.trunc();
                }
                catch (IOException iOException) {
                    LOGGER.warning("Broken zip file: " + this.archiveFile.getAbsolutePath());
                    LOGGER.log(Level.FINE, null, iOException);
                    this.names = new byte[0];
                    this.nameOffset = 0;
                    this.folders = new HashMap<String, Folder>();
                    if (this.zipFile == null) break block5;
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException iOException2) {
                        LOGGER.warning("Cannot close archive: " + this.archiveFile.getAbsolutePath());
                        LOGGER.log(Level.FINE, null, iOException2);
                    }
                }
            }
        }
        return this.folders;
    }

    private void trunc() {
        byte[] byArray = new byte[this.nameOffset];
        System.arraycopy(this.names, 0, byArray, 0, this.nameOffset);
        this.names = byArray;
        Iterator<Folder> iterator = this.folders.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().trunc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Folder> createMap(File file) throws IOException {
        Folder folder;
        String string;
        String string2;
        int n;
        String string3;
        Object object;
        Object object2;
        Object object3;
        if (!file.canRead()) {
            return Collections.emptyMap();
        }
        HashMap<String, Folder> hashMap = null;
        if (!this.keepOpened) {
            hashMap = new HashMap<String, Folder>();
            try {
                object3 = FastJar.list(file);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    string3 = ((FastJar.Entry)object).name;
                    n = string3.lastIndexOf(47);
                    string2 = n == -1 ? "" : string3.substring(0, n);
                    string = string3.substring(n + 1);
                    if (string.length() == 0) {
                        string = null;
                    }
                    if ((folder = (Folder)hashMap.get(string2)) == null) {
                        folder = new Folder(true);
                        hashMap.put(new String(string2).intern(), folder);
                    }
                    if (string == null) continue;
                    folder.appendEntry(this, string, ((FastJar.Entry)object).getTime(), ((FastJar.Entry)object).offset);
                }
            }
            catch (IOException iOException) {
                hashMap = null;
                Logger.getLogger(CachingArchive.class.getName()).warning("Fallback to ZipFile: " + file.getPath());
            }
        }
        if (hashMap == null) {
            block18: {
                hashMap = new HashMap();
                object3 = new ZipFile(file);
                try {
                    object2 = ((ZipFile)object3).entries();
                    while (object2.hasMoreElements()) {
                        object = (ZipEntry)object2.nextElement();
                        string3 = ((ZipEntry)object).getName();
                        n = string3.lastIndexOf(47);
                        string2 = n == -1 ? "" : string3.substring(0, n);
                        string = string3.substring(n + 1);
                        if (string.length() == 0) {
                            string = null;
                        }
                        if ((folder = (Folder)hashMap.get(string2)) == null) {
                            folder = new Folder(false);
                            hashMap.put(new String(string2).intern(), folder);
                        }
                        if (string == null) continue;
                        folder.appendEntry(this, string, ((ZipEntry)object).getTime(), -1L);
                    }
                    Object var12_12 = null;
                    if (!this.keepOpened) break block18;
                    this.zipFile = object3;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (this.keepOpened) {
                        this.zipFile = object3;
                    } else {
                        try {
                            ((ZipFile)object3).close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    throw throwable;
                }
            }
            try {
                ((ZipFile)object3).close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return hashMap;
    }

    int putName(byte[] byArray) {
        int n = this.nameOffset;
        if (n + byArray.length > this.names.length) {
            byte[] byArray2 = new byte[this.names.length * 2 + byArray.length];
            System.arraycopy(this.names, 0, byArray2, 0, n);
            this.names = byArray2;
        }
        System.arraycopy(byArray, 0, this.names, n, byArray.length);
        this.nameOffset += byArray.length;
        return n;
    }

    private static class Folder {
        int[] indices = EMPTY;
        int idx = 0;
        private final int delta;

        public Folder(boolean bl) {
            this.delta = bl ? 6 : 4;
        }

        void appendEntry(CachingArchive cachingArchive, String string, long l, long l2) {
            Object[] objectArray;
            if (this.idx + this.delta > this.indices.length) {
                objectArray = new int[2 * this.indices.length + this.delta];
                System.arraycopy(this.indices, 0, objectArray, 0, this.idx);
                this.indices = objectArray;
            }
            try {
                objectArray = string.getBytes("UTF-8");
                this.indices[this.idx++] = cachingArchive.putName((byte[])objectArray);
                this.indices[this.idx++] = objectArray.length;
                this.indices[this.idx++] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                this.indices[this.idx++] = (int)(l >> 32);
                if (this.delta == 6) {
                    this.indices[this.idx++] = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
                    this.indices[this.idx++] = (int)(l2 >> 32);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("No UTF-8");
            }
        }

        void trunc() {
            if (this.indices.length > this.idx) {
                int[] nArray = new int[this.idx];
                System.arraycopy(this.indices, 0, nArray, 0, this.idx);
                this.indices = nArray;
            }
        }
    }
}

