/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSourceTaskFactory {
    private static final Logger LOG = Logger.getLogger(JavaSourceTaskFactory.class.getName());
    static final String BEFORE_ADDING_REMOVING_TASKS = "beforeAddingRemovingTasks";
    static final String FILEOBJECTS_COMPUTATION = "fileObjectsComputation";
    private final JavaSource.Phase phase;
    private final JavaSource.Priority priority;
    static boolean SYNCHRONOUS_EVENTS = false;
    private final Map<FileObject, CancellableTask<CompilationInfo>> file2Task;
    private final Map<FileObject, JavaSource> file2JS;
    private static RequestProcessor WORKER = new RequestProcessor("JavaSourceTaskFactory", 1);
    static Accessor2 ACCESSOR2;

    protected JavaSourceTaskFactory(@NonNull JavaSource.Phase phase, @NonNull JavaSource.Priority priority) {
        this.phase = phase;
        this.priority = priority;
        this.file2Task = new HashMap<FileObject, CancellableTask<CompilationInfo>>();
        this.file2JS = new HashMap<FileObject, JavaSource>();
    }

    @NonNull
    protected abstract CancellableTask<CompilationInfo> createTask(FileObject var1);

    @NonNull
    protected abstract Collection<FileObject> getFileObjects();

    protected final void fileObjectsChanged() {
        LOG.log(Level.FINEST, FILEOBJECTS_COMPUTATION);
        final ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.getFileObjects());
        if (SYNCHRONOUS_EVENTS) {
            this.stateChangedImpl(arrayList);
        } else {
            WORKER.post(new Runnable(){

                public void run() {
                    JavaSourceTaskFactory.this.stateChangedImpl(arrayList);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(List<FileObject> list) {
        HashMap<JavaSource, CancellableTask<CompilationInfo>> hashMap = new HashMap<JavaSource, CancellableTask<CompilationInfo>>();
        HashMap<JavaSource, CancellableTask<CompilationInfo>> hashMap2 = new HashMap<JavaSource, CancellableTask<CompilationInfo>>();
        Iterator iterator = this;
        synchronized (iterator) {
            JavaSource javaSource;
            Map.Entry entry = new ArrayList<FileObject>(list);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.file2Task.keySet());
            entry.removeAll(this.file2Task.keySet());
            arrayList.removeAll(list);
            for (FileObject fileObject : arrayList) {
                javaSource = this.file2JS.remove(fileObject);
                if (javaSource == null) continue;
                hashMap.put(javaSource, this.file2Task.remove(fileObject));
            }
            Iterator iterator2 = entry.iterator();
            while (iterator2.hasNext()) {
                FileObject fileObject;
                fileObject = (FileObject)iterator2.next();
                if (fileObject == null || !fileObject.isValid() || (javaSource = JavaSource.forFileObject(fileObject)) == null) continue;
                CancellableTask<CompilationInfo> cancellableTask = this.createTask(fileObject);
                if (cancellableTask == null) {
                    throw new IllegalStateException("createTask(FileObject) returned null for factory: " + this.getClass().getName());
                }
                hashMap2.put(javaSource, cancellableTask);
                this.file2Task.put(fileObject, cancellableTask);
                this.file2JS.put(fileObject, javaSource);
            }
        }
        LOG.log(Level.FINEST, BEFORE_ADDING_REMOVING_TASKS);
        for (Map.Entry entry : hashMap.entrySet()) {
            ACCESSOR2.removePhaseCompletionTask((JavaSource)entry.getKey(), (CancellableTask)entry.getValue());
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            try {
                ACCESSOR2.addPhaseCompletionTask((JavaSource)entry.getKey(), (CancellableTask)entry.getValue(), this.phase, this.priority);
            }
            catch (FileObjects.InvalidFileException invalidFileException) {
                LOG.info("JavaSource.addPhaseCompletionTask called on deleted file");
            }
            catch (IOException iOException) {
                if (!LOG.isLoggable(Level.SEVERE)) continue;
                LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    protected final synchronized void reschedule(FileObject fileObject) throws IllegalArgumentException {
        JavaSource javaSource = this.file2JS.get(fileObject);
        if (javaSource == null) {
            return;
        }
        CancellableTask<CompilationInfo> cancellableTask = this.file2Task.get(fileObject);
        if (cancellableTask == null) {
            return;
        }
        ACCESSOR2.rescheduleTask(javaSource, cancellableTask);
    }

    static {
        JavaSourceTaskFactoryManager.ACCESSOR = new JavaSourceTaskFactoryManager.Accessor(){

            public void fireChangeEvent(JavaSourceTaskFactory javaSourceTaskFactory) {
                javaSourceTaskFactory.fileObjectsChanged();
            }
        };
        ACCESSOR2 = new Accessor2(){

            @Override
            public void addPhaseCompletionTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask, JavaSource.Phase phase, JavaSource.Priority priority) throws IOException {
                JavaSourceAccessor.getINSTANCE().addPhaseCompletionTask(javaSource, cancellableTask, phase, priority);
            }

            @Override
            public void removePhaseCompletionTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask) {
                JavaSourceAccessor.getINSTANCE().removePhaseCompletionTask(javaSource, cancellableTask);
            }

            @Override
            public void rescheduleTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask) {
                JavaSourceAccessor.getINSTANCE().rescheduleTask(javaSource, cancellableTask);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Accessor2 {
        public void addPhaseCompletionTask(JavaSource var1, CancellableTask<CompilationInfo> var2, JavaSource.Phase var3, JavaSource.Priority var4) throws IOException;

        public void removePhaseCompletionTask(JavaSource var1, CancellableTask<CompilationInfo> var2);

        public void rescheduleTask(JavaSource var1, CancellableTask<CompilationInfo> var2);
    }
}

