/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentCollector {
    private static CommentCollector instance = null;
    private static Logger log = Logger.getLogger(CommentCollector.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommentCollector getInstance() {
        Class<CommentsCollection> clazz = CommentsCollection.class;
        synchronized (CommentsCollection.class) {
            if (instance == null) {
                instance = new CommentCollector();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CommentCollector() {
    }

    public void collect(WorkingCopy workingCopy) throws IOException {
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)workingCopy.getCompilationUnit();
        TokenSequence tokenSequence = ((SourceFileObject)jCCompilationUnit.getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
        this.collect((TokenSequence<JavaTokenId>)tokenSequence, workingCopy);
    }

    public void collect(TokenSequence<JavaTokenId> tokenSequence, CompilationInfo compilationInfo) {
        CommentHandlerService commentHandlerService = CommentHandlerService.instance(compilationInfo.impl.getJavacTask().getContext());
        TreeUtilities treeUtilities = new TreeUtilities(compilationInfo);
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationInfo.getCompilationUnit();
        EndPosTable endPosTable = jCCompilationUnit.endPositions;
        List list = jCCompilationUnit.getTypeDecls();
        Tree tree = list.isEmpty() ? compilationInfo.getCompilationUnit() : (Tree)list.get(0);
        CommentsCollection commentsCollection = null;
        tokenSequence.move(0);
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() == JavaTokenId.WHITESPACE) {
                n += this.numberOfNL((Token<JavaTokenId>)token);
                continue;
            }
            if (this.isComment((JavaTokenId)token.id())) {
                if (commentsCollection != null) {
                    this.attachComments(commentsCollection, tree, commentHandlerService, (Map<JCTree, Integer>)((Object)endPosTable), tokenSequence);
                }
                commentsCollection = this.getCommentsCollection(tokenSequence, n);
                if (token.id() == JavaTokenId.LINE_COMMENT) {
                    n = 1;
                    continue;
                }
                n = 0;
                continue;
            }
            this.skipEvil(tokenSequence);
            Tree tree2 = this.getTree(treeUtilities, tokenSequence);
            if (tree2 != null && commentsCollection != null) {
                int[] nArray = commentsCollection.getBounds();
                double d = this.belongsTo(nArray[0], nArray[1], tokenSequence);
                if (tree2.getKind() == Tree.Kind.COMPILATION_UNIT && d == 0.0) {
                    this.attachComments(commentsCollection, tree, commentHandlerService, (Map<JCTree, Integer>)((Object)endPosTable), tokenSequence);
                } else if (d >= 0.0) {
                    this.attachComments(commentsCollection, tree2, commentHandlerService, (Map<JCTree, Integer>)((Object)endPosTable), tokenSequence);
                } else {
                    this.attachComments(commentsCollection, tree, commentHandlerService, (Map<JCTree, Integer>)((Object)endPosTable), tokenSequence);
                }
                commentsCollection = null;
            }
            tree = tree2;
            n = 0;
        }
    }

    private void skipEvil(TokenSequence<JavaTokenId> tokenSequence) {
        do {
            JavaTokenId javaTokenId = (JavaTokenId)tokenSequence.token().id();
            switch (javaTokenId) {
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOID: 
                case VOLATILE: 
                case NATIVE: 
                case STRICTFP: 
                case WHITESPACE: 
                case INT: 
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case CONST: 
                case LONG: {
                    break;
                }
                default: {
                    return;
                }
            }
        } while (tokenSequence.moveNext());
    }

    private double belongsTo(int n, int n2, TokenSequence<JavaTokenId> tokenSequence) {
        int n3 = tokenSequence.index();
        double d = this.getForwardWeight(n2, tokenSequence) - this.getBackwardWeight(n, tokenSequence);
        tokenSequence.moveIndex(n3);
        tokenSequence.moveNext();
        return d;
    }

    private double getForwardWeight(int n, TokenSequence<JavaTokenId> tokenSequence) {
        double d = 0.0;
        tokenSequence.move(n);
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                int n2 = this.numberOfNL((Token<JavaTokenId>)tokenSequence.token());
                d = n2 == 0 ? 1.0 : (double)(1 / n2);
                continue;
            }
            if (!this.isComment((JavaTokenId)tokenSequence.token().id())) break;
            if (tokenSequence.token().id() == JavaTokenId.LINE_COMMENT) {
                return 1.0;
            }
            d = 0.0;
            break;
        }
        return d;
    }

    private double getBackwardWeight(int n, TokenSequence<JavaTokenId> tokenSequence) {
        double d = 0.0;
        tokenSequence.move(n);
        while (tokenSequence.movePrevious()) {
            if (tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                int n2 = this.numberOfNL((Token<JavaTokenId>)tokenSequence.token());
                d = n2 == 0 ? 0.0 : (double)(1 / n2);
                continue;
            }
            if (!this.isComment((JavaTokenId)tokenSequence.token().id())) break;
            d = 0.0;
            break;
        }
        return d;
    }

    private void attachComments(CommentsCollection commentsCollection, Tree tree, CommentHandler commentHandler, Map<JCTree, Integer> map, TokenSequence<JavaTokenId> tokenSequence) {
        Object object;
        if (commentsCollection.isEmpty()) {
            return;
        }
        int[] nArray = this.getBounds((JCTree)tree, map);
        CommentSet.RelativePosition relativePosition = tree instanceof BlockTree ? ((object = (BlockTree)tree).getStatements().isEmpty() && nArray[0] >= commentsCollection.getBounds()[0] && nArray[1] <= commentsCollection.getBounds()[1] ? CommentSet.RelativePosition.INNER : this.computePositioning(nArray, commentsCollection, tokenSequence)) : this.computePositioning(nArray, commentsCollection, tokenSequence);
        object = this.createCommentSet(commentHandler, tree);
        for (Token<JavaTokenId> token : commentsCollection) {
            this.attachComment(relativePosition, (CommentSet)object, token);
        }
    }

    private void attachComment(CommentSet.RelativePosition relativePosition, CommentSet commentSet, Token<JavaTokenId> token) {
        Comment comment = Comment.create(this.getStyle((JavaTokenId)token.id()), token.offset(null), this.getEndPos(token), -2, this.getText(token));
        commentSet.addComment(relativePosition, comment);
    }

    private String getText(Token<JavaTokenId> token) {
        return String.valueOf(token.text());
    }

    private int getEndPos(Token<JavaTokenId> token) {
        return token.offset(null) + token.length();
    }

    private Comment.Style getStyle(JavaTokenId javaTokenId) {
        switch (javaTokenId) {
            case JAVADOC_COMMENT: {
                return Comment.Style.JAVADOC;
            }
            case LINE_COMMENT: {
                return Comment.Style.LINE;
            }
            case BLOCK_COMMENT: {
                return Comment.Style.BLOCK;
            }
        }
        return Comment.Style.WHITESPACE;
    }

    private CommentSet.RelativePosition computePositioning(int[] nArray, CommentsCollection commentsCollection, TokenSequence<JavaTokenId> tokenSequence) {
        int[] nArray2 = commentsCollection.getBounds();
        if (nArray2[1] < nArray[0]) {
            return CommentSet.RelativePosition.PRECEDING;
        }
        if (nArray2[0] > nArray[1]) {
            TokenSequence tokenSequence2 = tokenSequence.subSequence(nArray[1], nArray2[0]);
            tokenSequence2.move(0);
            if (!tokenSequence2.moveNext()) {
                return CommentSet.RelativePosition.INLINE;
            }
            switch ((JavaTokenId)tokenSequence2.token().id()) {
                case WHITESPACE: {
                    if (this.numberOfNL((Token<JavaTokenId>)tokenSequence2.token()) > 0) {
                        return CommentSet.RelativePosition.TRAILING;
                    }
                    return CommentSet.RelativePosition.INLINE;
                }
            }
            return CommentSet.RelativePosition.TRAILING;
        }
        if (nArray2[0] > nArray[0] && nArray2[1] < nArray[1]) {
            return CommentSet.RelativePosition.INNER;
        }
        return CommentSet.RelativePosition.TRAILING;
    }

    private int[] getBounds(JCTree jCTree, Map<JCTree, Integer> map) {
        return new int[]{TreeInfo.getStartPos(jCTree), TreeInfo.getEndPos((JCTree)jCTree, map)};
    }

    private Tree getTree(TreeUtilities treeUtilities, TokenSequence<JavaTokenId> tokenSequence) {
        TreePath treePath;
        int n = tokenSequence.offset();
        if (tokenSequence.token().length() > 0) {
            ++n;
        }
        if ((treePath = treeUtilities.pathFor(n)) != null) {
            return treePath.getLeaf();
        }
        return null;
    }

    private int numberOfNL(Token<JavaTokenId> token) {
        int n = 0;
        CharSequence charSequence = token.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if ('\n' != c) continue;
            ++n;
        }
        return n;
    }

    private CommentsCollection getCommentsCollection(TokenSequence<JavaTokenId> tokenSequence, int n) {
        CommentsCollection commentsCollection = new CommentsCollection();
        Token token = tokenSequence.token();
        commentsCollection.add((Token<JavaTokenId>)token);
        boolean bl = token.id() == JavaTokenId.LINE_COMMENT;
        int n2 = tokenSequence.index();
        int n3 = tokenSequence.offset();
        int n4 = tokenSequence.offset() + tokenSequence.token().length();
        while (tokenSequence.moveNext()) {
            token = tokenSequence.token();
            if (this.isComment((JavaTokenId)token.id())) {
                commentsCollection.add((Token<JavaTokenId>)token);
                n3 = Math.min(tokenSequence.offset(), n3);
                n4 = Math.max(tokenSequence.offset() + token.length(), n4);
                bl = token.id() == JavaTokenId.LINE_COMMENT;
                n2 = tokenSequence.index();
                continue;
            }
            if (token.id() == JavaTokenId.WHITESPACE && this.numberOfNL((Token<JavaTokenId>)token) + (bl ? 1 : 0) <= n) continue;
        }
        tokenSequence.moveIndex(n2);
        tokenSequence.moveNext();
        commentsCollection.setBounds(new int[]{n3, n4});
        return commentsCollection;
    }

    private CommentSet createCommentSet(CommentHandler commentHandler, Tree tree) {
        return commentHandler.getComments(tree);
    }

    private boolean isComment(JavaTokenId javaTokenId) {
        switch (javaTokenId) {
            case JAVADOC_COMMENT: 
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentsCollection
    implements Iterable<Token<JavaTokenId>> {
        private final int[] bounds = new int[]{-2, -2};
        private final List<Token<JavaTokenId>> comments = new LinkedList<Token<JavaTokenId>>();

        private CommentsCollection() {
        }

        void add(Token<JavaTokenId> token) {
            this.comments.add(token);
        }

        boolean isEmpty() {
            return this.comments.isEmpty();
        }

        @Override
        public Iterator<Token<JavaTokenId>> iterator() {
            return this.comments.iterator();
        }

        void setBounds(int[] nArray) {
            this.bounds[0] = nArray[0];
            this.bounds[1] = nArray[1];
        }

        public int[] getBounds() {
            return (int[])this.bounds.clone();
        }

        public void merge(CommentsCollection commentsCollection) {
            this.comments.addAll(commentsCollection.comments);
            this.bounds[0] = Math.min(this.bounds[0], commentsCollection.bounds[0]);
            this.bounds[1] = Math.max(this.bounds[1], commentsCollection.bounds[1]);
        }
    }
}

