/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

public final class Comment {
    private Style style;
    private int pos;
    private int endPos;
    private int indent;
    private String text;

    public static Comment create(String string) {
        return new Comment(Style.BLOCK, -2, -2, -2, string);
    }

    public static Comment create(Style style, int n, int n2, int n3, String string) {
        return new Comment(style, n, n2, n3, string);
    }

    public static Comment create(Style style, String string) {
        return new Comment(style, -2, -2, -2, string);
    }

    private Comment(Style style, int n, int n2, int n3, String string) {
        this.style = style;
        this.pos = n;
        this.endPos = n2;
        this.indent = n3;
        this.text = string;
    }

    public Style style() {
        return this.style;
    }

    public int pos() {
        return this.pos;
    }

    public int endPos() {
        return this.endPos;
    }

    public int indent() {
        return this.indent;
    }

    public boolean isDocComment() {
        return this.style == Style.JAVADOC;
    }

    public String getText() {
        return this.text;
    }

    public boolean isNew() {
        return this.pos == -2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.style.toString());
        stringBuilder.append(" pos=");
        stringBuilder.append(this.pos);
        stringBuilder.append(" endPos=");
        stringBuilder.append(this.endPos);
        stringBuilder.append(" indent=");
        stringBuilder.append(this.indent);
        stringBuilder.append(' ');
        stringBuilder.append(this.text);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Comment)) {
            return false;
        }
        Comment comment = (Comment)object;
        return comment.style == this.style && comment.pos == this.pos && comment.endPos == this.endPos && comment.indent == this.indent && comment.text.equals(this.text);
    }

    public int hashCode() {
        return this.style.hashCode() + this.pos + this.endPos + this.indent + this.text.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        LINE,
        BLOCK,
        JAVADOC,
        WHITESPACE;

    }
}

