/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.manager;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.modules.server.ui.wizard.AddServerInstanceWizard;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ServerManagerPanel
extends JPanel
implements PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private static final String SERVERS_ICON = "org/netbeans/modules/server/ui/resources/servers.png";
    private static final Logger LOGGER = Logger.getLogger(ServerManagerPanel.class.getName());
    private static final Dimension MINIMUM_SIZE = new Dimension(750, 450);
    private ServersChildren children;
    private ExplorerManager manager;
    private ServerInstance initialInstance;
    private JButton addButton;
    private JPanel cardsPanel;
    private JPanel clientPanel;
    private JPanel customizerPanel;
    private JPanel emptyPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel3;
    private JButton removeButton;
    private JTextField serverName;
    private JTextField serverType;
    private JLabel serversLabel;
    private BeanTreeView serversView;

    public ServerManagerPanel(ServerInstance serverInstance) {
        this.initComponents();
        this.serverName.setColumns(30);
        this.serverType.setColumns(30);
        this.serversView.setPreferredSize(new Dimension(200, 200));
        this.initialInstance = serverInstance;
        this.setPreferredSize(MINIMUM_SIZE);
    }

    public void addNotify() {
        super.addNotify();
        this.expandServers(this.initialInstance);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length != 1) {
                this.selectServer(null);
            } else {
                this.selectServer(nodeArray[0]);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length != 1) {
            throw new PropertyVetoException("Invalid length", propertyChangeEvent);
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new ServersNode(Children.create((ChildFactory)this.getChildren(), (boolean)false)));
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
        }
        return this.manager;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.serversView = new BeanTreeView();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.cardsPanel = new JPanel();
        this.emptyPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.serverName = new JTextField();
        this.jLabel2 = new JLabel();
        this.serverType = new JTextField();
        this.clientPanel = new JPanel();
        this.serversLabel = new JLabel();
        this.serversView.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        this.serversView.setPopupAllowed(false);
        this.serversView.setPreferredSize(new Dimension(220, 400));
        this.serversView.setSelectionMode(0);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_AddServer"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerManagerPanel.this.addServer(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerManagerPanel.this.removeServer(actionEvent);
            }
        });
        this.cardsPanel.setLayout(new CardLayout());
        this.emptyPanel.setLayout(new GridBagLayout());
        this.cardsPanel.add((Component)this.emptyPanel, "card3");
        this.customizerPanel.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.serverName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_ServerName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.customizerPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerName"));
        this.serverName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.customizerPanel.add((Component)this.serverName, gridBagConstraints);
        this.serverName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerName"));
        this.serverName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerName"));
        this.jLabel2.setLabelFor(this.serverType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_ServerType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.customizerPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerType"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerType"));
        this.serverType.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.customizerPanel.add((Component)this.serverType, gridBagConstraints);
        this.serverType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerType"));
        this.serverType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerType"));
        this.clientPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.customizerPanel.add((Component)this.clientPanel, gridBagConstraints);
        this.cardsPanel.add((Component)this.customizerPanel, "card2");
        this.serversLabel.setLabelFor((Component)this.serversView);
        Mnemonics.setLocalizedText((JLabel)this.serversLabel, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_Servers"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serversLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.serversView, -2, 0, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton))).addPreferredGap(1).add((Component)this.cardsPanel, -1, 267, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.serversLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.cardsPanel, -1, 271, Short.MAX_VALUE).add(1, (Component)this.serversView, -1, 271, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton)).addContainerGap()));
        this.serversView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_InstalledServers"));
        this.serversView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_InstalledServers"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_AddServer"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_AddServer"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_Remove"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_Remove"));
        this.serversLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSN_ServerList"));
        this.serversLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSD_ServerList"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSN_ServerManager"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSD_ServerManager"));
    }

    private void removeServer(ActionEvent actionEvent) {
        ServerInstance serverInstance;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray[0] instanceof ServerNode && (serverInstance = ((ServerNode)nodeArray[0]).getServerInstance()).isRemovable()) {
            serverInstance.remove();
            this.getChildren().refresh();
            this.expandServers(null);
        }
    }

    private void addServer(ActionEvent actionEvent) {
        ServerInstance serverInstance = AddServerInstanceWizard.showAddServerInstanceWizard();
        if (serverInstance != null) {
            this.getChildren().refresh();
            this.expandServers(serverInstance);
        }
    }

    private synchronized ServersChildren getChildren() {
        if (this.children == null) {
            this.children = new ServersChildren();
        }
        return this.children;
    }

    private void selectServer(Node node) {
        Serializable serializable;
        JComponent jComponent;
        this.clientPanel.removeAll();
        ServerInstance serverInstance = null;
        if (node instanceof ServerNode) {
            serverInstance = ((ServerNode)node).getServerInstance();
            this.serverName.setText(serverInstance.getDisplayName());
            this.serverType.setText(serverInstance.getServerDisplayName());
            if (!serverInstance.isRemovable()) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        } else {
            this.removeButton.setEnabled(false);
            ((CardLayout)this.cardsPanel.getLayout()).first(this.cardsPanel);
            return;
        }
        if (serverInstance.getCustomizer() != null && (jComponent = serverInstance.getCustomizer()) != null) {
            ServerManagerPanel.addComponent(this.clientPanel, jComponent);
        }
        int n = this.getHeight();
        int n2 = this.getWidth();
        this.setPreferredSize(null);
        this.revalidate();
        Dimension dimension = this.getPreferredSize();
        int n3 = (int)(dimension.getWidth() > MINIMUM_SIZE.getWidth() ? dimension.getWidth() : MINIMUM_SIZE.getWidth());
        int n4 = (int)(dimension.getHeight() > MINIMUM_SIZE.getHeight() ? dimension.getHeight() : MINIMUM_SIZE.getHeight());
        if (n4 > n || n3 > n2) {
            this.setPreferredSize(new Dimension(n3 > n2 ? n3 : n2, n4 > n ? n4 : n));
            for (serializable = this.getParent(); serializable != null; serializable = ((Component)serializable).getParent()) {
                if (!(serializable instanceof Window)) continue;
                ((Window)serializable).pack();
                break;
            }
        }
        serializable = (CardLayout)this.cardsPanel.getLayout();
        ((CardLayout)serializable).last(this.cardsPanel);
    }

    private static void addComponent(Container container, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void expandServers(ServerInstance serverInstance) {
        ExplorerManager explorerManager = this.getExplorerManager();
        Node node = explorerManager.getRootContext();
        ServerManagerPanel.expandAllNodes(this.serversView, node, explorerManager, serverInstance);
    }

    private static void expandAllNodes(BeanTreeView beanTreeView, Node node, ExplorerManager explorerManager, ServerInstance serverInstance) {
        Children children = node.getChildren();
        if (serverInstance != null && children == Children.LEAF && node instanceof ServerNode) {
            try {
                if (((ServerNode)node).getServerInstance() == serverInstance) {
                    explorerManager.setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                LOGGER.log(Level.FINE, null, propertyVetoException);
            }
        }
        if (serverInstance == null && children == Children.LEAF && explorerManager.getSelectedNodes().length == 0) {
            try {
                explorerManager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                LOGGER.log(Level.FINE, null, propertyVetoException);
            }
        }
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerManagerPanel.expandAllNodes(beanTreeView, nodeArray[i], explorerManager, serverInstance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceComparator
    implements Comparator<ServerInstance>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(ServerInstance serverInstance, ServerInstance serverInstance2) {
            return serverInstance.getDisplayName().compareTo(serverInstance2.getDisplayName());
        }
    }

    private static class ServerNode
    extends FilterNode {
        private final ServerInstance serverInstance;

        public ServerNode(ServerInstance serverInstance) {
            super(serverInstance.getBasicNode());
            this.serverInstance = serverInstance;
            this.setChildren(FilterNode.Children.LEAF);
        }

        public ServerInstance getServerInstance() {
            return this.serverInstance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServersChildren
    extends ChildFactory<ServerInstance> {
        private static final Comparator<ServerInstance> COMPARATOR = new InstanceComparator();

        protected final void refresh() {
            this.refresh(true);
        }

        protected Node createNodeForKey(ServerInstance serverInstance) {
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (null != serverInstance.getBasicNode()) {
                return new ServerNode(serverInstance);
            }
            if (bl) {
                LOGGER.log(Level.WARNING, "Server instance {0} return null basic node.While this may be ok it is usually a bug.", serverInstance);
            }
            return null;
        }

        protected boolean createKeys(List<ServerInstance> list) {
            ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
            for (ServerInstanceProvider serverInstanceProvider : ServerRegistry.getInstance().getProviders()) {
                for (ServerInstance serverInstance : serverInstanceProvider.getInstances()) {
                    if (null != serverInstance.getDisplayName()) {
                        arrayList.add(serverInstance);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Found server instance with a null display name {0} {1}", new Object[]{serverInstance.getServerDisplayName(), serverInstance.toString()});
                }
            }
            Collections.sort(arrayList, COMPARATOR);
            list.addAll(arrayList);
            return true;
        }
    }

    private static class ServersNode
    extends AbstractNode {
        public ServersNode(Children children) {
            super(children);
            this.setName("");
            this.setDisplayName(NbBundle.getMessage(ServerManagerPanel.class, (String)"Server_Registry_Node_Name"));
            this.setShortDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"Server_Registry_Node_Short_Description"));
            this.setIconBaseWithExtension(ServerManagerPanel.SERVERS_ICON);
        }
    }
}

