/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.glassfish.v3;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishV3JaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String[] METRO_LIBRARIES = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "javax.activation.jar"};
    private static final String[] METRO_LIBRARIES15 = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "woodstox(|-osgi).jar", "javax.activation.jar"};
    private static final String GFV3_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxWs jaxWs;

    public GlassFishV3JaxWsStack(String string) {
        this.gfRootStr = string;
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        if (this.isMetroInstalled()) {
            return WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)1);
        }
        return WSStackVersion.valueOf((int)2, (int)1, (int)3, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (tool == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (tool == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.WSIT && this.isMetroInstalled()) {
            return true;
        }
        if (feature == JaxWs.Feature.JSR109 && this.isMetroInstalled()) {
            return true;
        }
        return feature == JaxWs.Feature.TESTER_PAGE;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                if (bl) {
                    return string2 + "/" + string3;
                }
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?Tester";
            }
        };
    }

    protected boolean isMetroInstalled() {
        File file = GlassFishV3JaxWsStack.getWsJarName(this.gfRootStr, METRO_LIBRARIES[0]);
        return file != null && file.exists();
    }

    public static File getWsJarName(String string, String string2) {
        File[] fileArray;
        File[] fileArray2;
        File file = new File(string + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            fileArray2 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            file = new File(file, (String)fileArray2);
        }
        if ((fileArray2 = file.listFiles(new VersionFilter(string2))) != null && fileArray2.length > 0) {
            return fileArray2[0];
        }
        File file2 = new File(file, "endorsed");
        if (file2 != null && file2.isDirectory() && (fileArray = file2.listFiles(new VersionFilter(string2))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String string) {
            this.pattern = Pattern.compile(string);
        }

        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    protected class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (GlassFishV3JaxWsStack.this.isMetroInstalled()) {
                String[] stringArray;
                String string = System.getProperty("java.version");
                for (String string2 : stringArray = string.compareTo("1.6") < 0 ? METRO_LIBRARIES15 : METRO_LIBRARIES) {
                    File file = GlassFishV3JaxWsStack.getWsJarName(GlassFishV3JaxWsStack.this.gfRootStr, string2);
                    if (file == null || !file.exists()) continue;
                    try {
                        arrayList.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }
    }
}

