/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws;

import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.impl.IdeJaxWsStack;
import org.netbeans.modules.websvc.wsstack.jaxws.impl.JdkJaxWsStack;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsStackProvider {
    private static WSStack<JaxWs> jdkJaxWsStack;
    private static WSStack<JaxWs> ideJaxWsStack;

    public static WSStack<JaxWs> getJaxWsStack(J2eePlatform j2eePlatform) {
        return WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class);
    }

    public static WSTool getJaxWsStackTool(J2eePlatform j2eePlatform, JaxWs.Tool tool) {
        WSStack wSStack = WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class);
        if (wSStack != null) {
            return wSStack.getWSTool((WSStack.Tool)tool);
        }
        return null;
    }

    public static synchronized WSStack<JaxWs> getJdkJaxWsStack() {
        String string;
        if (jdkJaxWsStack == null && (string = JaxWsStackProvider.getJaxWsStackVersion(System.getProperty("java.version"))) != null) {
            jdkJaxWsStack = WSStackFactory.createWSStack(JaxWs.class, new JdkJaxWsStack(string), (WSStack.Source)WSStack.Source.JDK);
        }
        return jdkJaxWsStack;
    }

    public static synchronized WSStack<JaxWs> getIdeJaxWsStack() {
        if (ideJaxWsStack == null) {
            ideJaxWsStack = WSStackFactory.createWSStack(JaxWs.class, new IdeJaxWsStack(), (WSStack.Source)WSStack.Source.IDE);
        }
        return ideJaxWsStack;
    }

    private static String getJaxWsStackVersion(String string) {
        if (string.startsWith("1.6")) {
            int n = string.indexOf("_");
            if (n > 0) {
                String string2 = JaxWsStackProvider.parseReleaseVersion(string.substring(n + 1));
                Integer n2 = Integer.valueOf(string2);
                if (n2 >= 4) {
                    return "2.1.1";
                }
                return "2.0";
            }
            return null;
        }
        try {
            Float f = Float.valueOf(string.substring(0, 3));
            if ((double)f.floatValue() > 1.6) {
                return "2.1.3";
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String parseReleaseVersion(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() && Character.isDigit(c = string.charAt(i)); ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

