/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SelectConnectionPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class SQLExecutionBaseAction
extends AbstractAction
implements ContextAwareAction,
HelpCtx.Provider {
    public SQLExecutionBaseAction() {
        String string;
        this.initialize();
        if (this.getValue("Name") == null) {
            this.putValue("Name", this.getDisplayName(null));
        }
        if ((string = this.getIconBase()) != null) {
            this.putValue("iconBase", string);
        }
    }

    protected void initialize() {
    }

    protected abstract String getDisplayName(SQLExecution var1);

    protected String getIconBase() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(SQLExecution sQLExecution) {
        return !sQLExecution.isExecuting();
    }

    protected abstract void actionPerformed(SQLExecution var1);

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAwareDelegate(this, lookup);
    }

    public static void notifyNoDatabaseConnection() {
        String string = NbBundle.getMessage(SQLExecutionBaseAction.class, (String)"LBL_NoDatabaseConnection");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static DatabaseConnection selectDatabaseConnection() {
        return SelectConnectionPanel.selectConnection(false);
    }

    static class ContextAwareDelegate
    extends AbstractAction
    implements Presenter.Toolbar,
    HelpCtx.Provider {
        private final SQLExecutionBaseAction parent;
        private final Lookup.Result<SQLExecution> result;
        private SQLExecution sqlExecution;
        private PropertyChangeListener listener;

        public ContextAwareDelegate(SQLExecutionBaseAction sQLExecutionBaseAction, Lookup lookup) {
            this.parent = sQLExecutionBaseAction;
            this.result = lookup.lookup(new Lookup.Template(SQLExecution.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ContextAwareDelegate.this.resultChanged();
                }
            });
            this.resultChanged();
        }

        protected synchronized void setSQLExecution(SQLExecution sQLExecution) {
            this.sqlExecution = sQLExecution;
        }

        protected synchronized SQLExecution getSQLExecution() {
            return this.sqlExecution;
        }

        private synchronized void resultChanged() {
            Iterator iterator;
            if (this.sqlExecution != null) {
                this.sqlExecution.removePropertyChangeListener(this.listener);
            }
            if ((iterator = this.result.allInstances().iterator()).hasNext()) {
                this.setSQLExecution((SQLExecution)iterator.next());
                this.listener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        ContextAwareDelegate.this.propertyChanged(propertyChangeEvent.getPropertyName());
                    }
                };
                this.sqlExecution.addPropertyChangeListener(this.listener);
                this.propertyChanged(null);
                if (iterator.hasNext()) {
                    Logger.getLogger("global").log(Level.WARNING, "Multiple SQLExecution instances in the action context. Will only use the first one.");
                }
            } else {
                this.setSQLExecution(null);
                this.listener = null;
                this.propertyChanged(null);
            }
        }

        private void propertyChanged(String string) {
            if (string == null || "executing".equals(string)) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        boolean bl = false;
                        SQLExecution sQLExecution = ContextAwareDelegate.this.getSQLExecution();
                        if (sQLExecution != null) {
                            bl = ContextAwareDelegate.this.parent.enable(sQLExecution);
                        }
                        String string = ContextAwareDelegate.this.parent.getDisplayName(sQLExecution);
                        ContextAwareDelegate.this.setEnabled(bl);
                        ContextAwareDelegate.this.putValue("Name", string);
                    }
                });
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SQLExecution sQLExecution = this.getSQLExecution();
            if (sQLExecution != null) {
                this.parent.actionPerformed(sQLExecution);
            }
        }

        public Object getValue(String string) {
            Object object = super.getValue(string);
            if (object == null) {
                object = this.parent.getValue(string);
            }
            return object;
        }

        public HelpCtx getHelpCtx() {
            return this.parent.getHelpCtx();
        }

        public Component getToolbarPresenter() {
            JButton jButton = new JButton();
            Actions.connect((AbstractButton)jButton, (Action)this);
            return jButton;
        }
    }
}

