/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.awt.Container;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionQuery;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (n == 1 || n == 9) {
            DatabaseConnection databaseConnection = SQLCompletionProvider.findDBConn(jTextComponent);
            if (databaseConnection == null) {
                Completion.get().hideAll();
                SQLExecutionBaseAction.notifyNoDatabaseConnection();
                return null;
            }
            return new AsyncCompletionTask((AsyncCompletionQuery)new SQLCompletionQuery(databaseConnection), jTextComponent);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        if (!".".equals(string)) {
            return 0;
        }
        if (!SQLCompletionProvider.isDotAtOffset(jTextComponent, jTextComponent.getSelectionStart() - 1)) {
            return 0;
        }
        DatabaseConnection databaseConnection = SQLCompletionProvider.findDBConn(jTextComponent);
        if (databaseConnection == null) {
            String string2 = NbBundle.getMessage(SQLCompletionProvider.class, (String)"MSG_NoDatabaseConnection");
            StatusDisplayer.getDefault().setStatusText(string2);
            return 0;
        }
        if (databaseConnection.getJDBCConnection() == null) {
            String string3 = NbBundle.getMessage(SQLCompletionProvider.class, (String)"MSG_NotConnected");
            StatusDisplayer.getDefault().setStatusText(string3);
            return 0;
        }
        return 1;
    }

    private static DatabaseConnection findDBConn(JTextComponent jTextComponent) {
        Lookup lookup = SQLCompletionProvider.findContext(jTextComponent);
        if (lookup == null) {
            return null;
        }
        SQLExecution sQLExecution = (SQLExecution)lookup.lookup(SQLExecution.class);
        if (sQLExecution == null) {
            return null;
        }
        return sQLExecution.getDatabaseConnection();
    }

    private static Lookup findContext(JTextComponent jTextComponent) {
        for (Container container = jTextComponent; container != null; container = container.getParent()) {
            Lookup lookup;
            if (!(container instanceof Lookup.Provider) || (lookup = ((Lookup.Provider)container).getLookup()) == null) continue;
            return lookup;
        }
        return null;
    }

    private static boolean isDotAtOffset(JTextComponent jTextComponent, final int n) {
        final Document document = jTextComponent.getDocument();
        final boolean[] blArray = new boolean[]{false};
        document.render(new Runnable(){

            public void run() {
                TokenSequence tokenSequence = SQLCompletionProvider.getSQLTokenSequence(document);
                if (tokenSequence == null) {
                    return;
                }
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return;
                }
                if (tokenSequence.offset() != n) {
                    return;
                }
                blArray[0] = tokenSequence.token().id() == SQLTokenId.DOT;
            }
        });
        return blArray[0];
    }

    private static TokenSequence<SQLTokenId> getSQLTokenSequence(Document document) {
        if (document.getProperty(Language.class) == null) {
            document.putProperty(Language.class, SQLTokenId.language());
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        return tokenHierarchy.tokenSequence(SQLTokenId.language());
    }
}

