/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class SQLCompletionItem
implements CompletionItem {
    private static final String CATALOG_COLOR = "<font color=#515fc5>";
    private static final String SCHEMA_COLOR = "<font color=#006666>";
    private static final String TABLE_COLOR = "<font color=#cc7800>";
    private static final String COLUMN_COLOR = "<font color=#0707ab>";
    private static final String KEYWORD_COLOR = "<font color=#005180>";
    private static final String COLOR_END = "</font>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private static final ImageIcon CATALOG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/catalog.png", (boolean)false);
    private static final ImageIcon SCHEMA_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/schema.png", (boolean)false);
    private static final ImageIcon TABLE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/table.png", (boolean)false);
    private static final ImageIcon ALIAS_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/alias.png", (boolean)false);
    private static final ImageIcon COLUMN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/column.png", (boolean)false);
    private static final ImageIcon KEYWORD_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/keyword.png", (boolean)false);
    private final SubstitutionHandler substHandler;
    private final String substText;
    private final int substOffset;

    public static SQLCompletionItem catalog(String string, String string2, int n, SubstitutionHandler substitutionHandler) {
        return new Catalog(string, string2, n, substitutionHandler);
    }

    public static SQLCompletionItem schema(String string, String string2, int n, SubstitutionHandler substitutionHandler) {
        return new Schema(string, string2, n, substitutionHandler);
    }

    public static SQLCompletionItem table(String string, String string2, int n, SubstitutionHandler substitutionHandler) {
        return new Table(string, string2, n, substitutionHandler);
    }

    public static SQLCompletionItem alias(String string, QualIdent qualIdent, String string2, int n, SubstitutionHandler substitutionHandler) {
        return new Alias(string, qualIdent, string2, n, substitutionHandler);
    }

    public static SQLCompletionItem column(QualIdent qualIdent, String string, String string2, int n, SubstitutionHandler substitutionHandler) {
        return new Column(qualIdent, string, string2, n, substitutionHandler);
    }

    public static SQLCompletionItem keyword(String string, int n, SubstitutionHandler substitutionHandler) {
        return new Keyword(string, n, substitutionHandler);
    }

    protected SQLCompletionItem(String string, int n, SubstitutionHandler substitutionHandler) {
        this.substText = string;
        this.substOffset = n;
        this.substHandler = substitutionHandler;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion.get().hideDocumentation();
        Completion.get().hideCompletion();
        this.substHandler.substituteText(jTextComponent, this.substOffset, this.substText);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getImageIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return null;
    }

    public CharSequence getInsertPrefix() {
        return this.substText;
    }

    protected abstract ImageIcon getImageIcon();

    protected abstract String getLeftHtmlText();

    protected abstract String getRightHtmlText();

    private void substituteText(JTextComponent jTextComponent, int n, int n2) {
    }

    private static class Keyword
    extends SQLCompletionItem {
        private final String keyword;
        private String leftText;

        public Keyword(String string, int n, SubstitutionHandler substitutionHandler) {
            super(string, n, substitutionHandler);
            this.keyword = string;
        }

        protected ImageIcon getImageIcon() {
            return KEYWORD_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.KEYWORD_COLOR);
                stringBuilder.append(SQLCompletionItem.BOLD);
                stringBuilder.append(this.keyword);
                stringBuilder.append(SQLCompletionItem.BOLD_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return "Keyword " + this.keyword;
        }
    }

    private static class Column
    extends SQLCompletionItem {
        private final QualIdent tableName;
        private final String columnName;
        private String leftText;
        private String rightText;

        public Column(QualIdent qualIdent, String string, String string2, int n, SubstitutionHandler substitutionHandler) {
            super(string2, n, substitutionHandler);
            this.tableName = qualIdent;
            this.columnName = string;
        }

        protected String getColumnName() {
            return this.columnName;
        }

        protected ImageIcon getImageIcon() {
            return COLUMN_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.COLUMN_COLOR);
                stringBuilder.append(SQLCompletionItem.BOLD);
                stringBuilder.append(this.columnName);
                stringBuilder.append(SQLCompletionItem.BOLD_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.TABLE_COLOR);
                stringBuilder.append(this.tableName.toString());
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.rightText = MessageFormat.format(NbBundle.getMessage(SQLCompletionItem.class, (String)"MSG_Table"), stringBuilder.toString());
            }
            return this.rightText;
        }

        public String toString() {
            return MessageFormat.format("Column {0} in table {1}", this.columnName, this.tableName);
        }
    }

    private static final class Alias
    extends SQLCompletionItem {
        private final String alias;
        private final QualIdent tableName;
        private String rightText;

        public Alias(String string, QualIdent qualIdent, String string2, int n, SubstitutionHandler substitutionHandler) {
            super(string2, n, substitutionHandler);
            this.alias = string;
            this.tableName = qualIdent;
        }

        protected ImageIcon getImageIcon() {
            return ALIAS_ICON;
        }

        protected String getLeftHtmlText() {
            return this.alias;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.TABLE_COLOR);
                stringBuilder.append(this.tableName.toString());
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.rightText = MessageFormat.format(NbBundle.getMessage(SQLCompletionItem.class, (String)"MSG_Alias"), stringBuilder.toString());
            }
            return this.rightText;
        }

        public String toString() {
            return MessageFormat.format("Alias {0} to {1}", this.alias, this.tableName);
        }
    }

    private static final class Table
    extends SQLCompletionItem {
        private final String tableName;
        private String leftText;

        public Table(String string, String string2, int n, SubstitutionHandler substitutionHandler) {
            super(string2, n, substitutionHandler);
            this.tableName = string;
        }

        protected ImageIcon getImageIcon() {
            return TABLE_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.TABLE_COLOR);
                stringBuilder.append(this.tableName);
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Table {0}", this.tableName);
        }
    }

    private static final class Schema
    extends SQLCompletionItem {
        private final String schemaName;
        private String leftText;

        public Schema(String string, String string2, int n, SubstitutionHandler substitutionHandler) {
            super(string2, n, substitutionHandler);
            this.schemaName = string;
        }

        protected ImageIcon getImageIcon() {
            return SCHEMA_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.SCHEMA_COLOR);
                stringBuilder.append(this.schemaName);
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Schema {0}", this.schemaName);
        }
    }

    private static final class Catalog
    extends SQLCompletionItem {
        private final String catalogName;
        private String leftText;

        public Catalog(String string, String string2, int n, SubstitutionHandler substitutionHandler) {
            super(string2, n, substitutionHandler);
            this.catalogName = string;
        }

        protected ImageIcon getImageIcon() {
            return CATALOG_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.CATALOG_COLOR);
                stringBuilder.append(this.catalogName);
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Catalog {0}", this.catalogName);
        }
    }
}

