/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.beans.Beans;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.adaptors.DatabaseMetaDataAdaptor;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.CommentTable;
import org.netbeans.lib.ddl.impl.CommentView;
import org.netbeans.lib.ddl.impl.CreateFunction;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.CreateProcedure;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.CreateTrigger;
import org.netbeans.lib.ddl.impl.CreateView;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.ModifyColumn;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.RenameColumn;
import org.netbeans.lib.ddl.impl.RenameTable;
import org.netbeans.lib.ddl.impl.RenameView;
import org.netbeans.lib.ddl.impl.SetDefaultDatabase;
import org.netbeans.lib.ddl.impl.SetDefaultSchema;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.openide.util.NbBundle;

public class Specification
implements DatabaseSpecification {
    private HashMap desc;
    private Connection jdbccon;
    SpecificationFactory factory;
    String adaptorClass;
    DatabaseMetaData dmdAdaptor;
    public static final String CREATE_TABLE = "CreateTableCommand";
    public static final String RENAME_TABLE = "RenameTableCommand";
    public static final String DROP_TABLE = "DropTableCommand";
    public static final String COMMENT_TABLE = "CommentTableCommand";
    public static final String ADD_COLUMN = "AddColumnCommand";
    public static final String MODIFY_COLUMN = "ModifyColumnCommand";
    public static final String RENAME_COLUMN = "RenameColumnCommand";
    public static final String REMOVE_COLUMN = "RemoveColumnCommand";
    public static final String CREATE_INDEX = "CreateIndexCommand";
    public static final String DROP_INDEX = "DropIndexCommand";
    public static final String ADD_CONSTRAINT = "AddConstraintCommand";
    public static final String DROP_CONSTRAINT = "DropConstraintCommand";
    public static final String CREATE_VIEW = "CreateViewCommand";
    public static final String RENAME_VIEW = "RenameViewCommand";
    public static final String COMMENT_VIEW = "CommentViewCommand";
    public static final String DROP_VIEW = "DropViewCommand";
    public static final String CREATE_PROCEDURE = "CreateProcedureCommand";
    public static final String DROP_PROCEDURE = "DropProcedureCommand";
    public static final String CREATE_FUNCTION = "CreateFunctionCommand";
    public static final String DROP_FUNCTION = "DropFunctionCommand";
    public static final String CREATE_TRIGGER = "CreateTriggerCommand";
    public static final String DROP_TRIGGER = "DropTriggerCommand";
    public static final String DEFAULT_DATABASE = "SetDefaultDatabaseCommand";
    public static final String DEFAULT_SCHEMA = "SetDefaultSchemaCommand";

    public Specification(HashMap description) {
        this.desc = description;
    }

    public Specification(HashMap description, Connection c) {
        this.desc = description;
        this.jdbccon = c;
    }

    public Map getProperties() {
        return this.desc;
    }

    public Map getCommandProperties(String command) {
        return (Map)this.desc.get(command);
    }

    public DBConnection getConnection() {
        return (DBConnection)this.desc.get("connection");
    }

    public DatabaseSpecificationFactory getSpecificationFactory() {
        return this.factory;
    }

    public void setSpecificationFactory(DatabaseSpecificationFactory fac) {
        this.factory = (SpecificationFactory)fac;
    }

    public String getMetaDataAdaptorClassName() {
        if (this.adaptorClass == null || this.adaptorClass.length() == 0) {
            this.adaptorClass = "org.netbeans.lib.ddl.adaptors.DefaultAdaptor";
        }
        return this.adaptorClass;
    }

    public void setMetaDataAdaptorClassName(String name) {
        this.adaptorClass = name.startsWith("Database.Adaptors.") ? name : "Database.Adaptors." + name;
        this.dmdAdaptor = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (this.dmdAdaptor != null || this.jdbccon == null) return this.dmdAdaptor;
            String adc = this.getMetaDataAdaptorClassName();
            if (adc == null) throw new ClassNotFoundException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_AdaptorUnspecClass"));
            ClassLoader loader = Class.forName(adc).getClassLoader();
            this.dmdAdaptor = (DatabaseMetaData)Beans.instantiate(loader, adc);
            if (!(this.dmdAdaptor instanceof DatabaseMetaDataAdaptor)) throw new ClassNotFoundException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_AdaptorInterface"));
            ((DatabaseMetaDataAdaptor)this.dmdAdaptor).setConnection(this.jdbccon);
            return this.dmdAdaptor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException(ex.getMessage());
        }
    }

    public Connection openJDBCConnection() throws DDLException {
        if (this.jdbccon != null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ConnOpen"));
        }
        DBConnection dbcon = this.getConnection();
        if (dbcon == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ConnNot"));
        }
        try {
            this.jdbccon = dbcon.createJDBCConnection();
        }
        catch (Exception e) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ConnNot"));
        }
        return this.jdbccon;
    }

    public Connection getJDBCConnection() {
        return this.jdbccon;
    }

    public void closeJDBCConnection() throws DDLException {
        if (this.jdbccon == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ConnNot"));
        }
        try {
            this.jdbccon.close();
            this.jdbccon = null;
        }
        catch (SQLException e) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ConnUnableClose"));
        }
    }

    public DDLCommand createCommand(String commandName) throws CommandNotSupportedException {
        return this.createCommand(commandName, null);
    }

    public DDLCommand createCommand(String commandName, String tableName) throws CommandNotSupportedException {
        AbstractCommand cmd;
        HashMap cprops = (HashMap)this.desc.get(commandName);
        if (cprops == null) {
            throw new CommandNotSupportedException(commandName, MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_CommandNotSupported"), commandName));
        }
        String classname = (String)cprops.get("Class");
        try {
            Class<?> cmdclass = Class.forName(classname);
            cmd = (AbstractCommand)cmdclass.newInstance();
        }
        catch (Exception e) {
            throw new CommandNotSupportedException(commandName, MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableFindOrInitCommand"), classname, commandName, e.getMessage()));
        }
        cmd.setObjectName(tableName);
        cmd.setSpecification(this);
        cmd.setFormat((String)cprops.get("Format"));
        return cmd;
    }

    public CreateTable createCommandCreateTable(String tableName) throws CommandNotSupportedException {
        return (CreateTable)this.createCommand(CREATE_TABLE, tableName);
    }

    public CommentTable createCommandCommentTable(String tableName, String comment) throws CommandNotSupportedException {
        CommentTable cmd = (CommentTable)this.createCommand(COMMENT_TABLE, tableName);
        cmd.setComment(comment);
        return cmd;
    }

    public AbstractCommand createCommandDropTable(String tableName) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_TABLE, tableName);
    }

    public RenameTable createCommandRenameTable(String tableName, String newName) throws CommandNotSupportedException {
        RenameTable cmd = (RenameTable)this.createCommand(RENAME_TABLE, tableName);
        cmd.setNewName(newName);
        return cmd;
    }

    public AddColumn createCommandAddColumn(String tableName) throws CommandNotSupportedException {
        return (AddColumn)this.createCommand(ADD_COLUMN, tableName);
    }

    public ModifyColumn createCommandModifyColumn(String tableName) throws CommandNotSupportedException {
        ModifyColumn cmd = (ModifyColumn)this.createCommand(MODIFY_COLUMN, tableName);
        return cmd;
    }

    public RenameColumn createCommandRenameColumn(String tableName) throws CommandNotSupportedException {
        RenameColumn cmd = (RenameColumn)this.createCommand(RENAME_COLUMN, tableName);
        return cmd;
    }

    public RemoveColumn createCommandRemoveColumn(String tableName) throws CommandNotSupportedException {
        RemoveColumn rcol = (RemoveColumn)this.createCommand(REMOVE_COLUMN, tableName);
        return rcol;
    }

    public CreateIndex createCommandCreateIndex(String tableName) throws CommandNotSupportedException {
        CreateIndex cicmd = (CreateIndex)this.createCommand(CREATE_INDEX, tableName);
        return cicmd;
    }

    public DropIndex createCommandDropIndex(String tablename) throws CommandNotSupportedException {
        DropIndex dcmd = (DropIndex)this.createCommand(DROP_INDEX, tablename);
        return dcmd;
    }

    public CreateView createCommandCreateView(String viewname) throws CommandNotSupportedException {
        return (CreateView)this.createCommand(CREATE_VIEW, viewname);
    }

    public RenameView createCommandRenameView(String tableName, String newName) throws CommandNotSupportedException {
        RenameView cmd = (RenameView)this.createCommand(RENAME_VIEW, tableName);
        cmd.setNewName(newName);
        return cmd;
    }

    public CommentView createCommandCommentView(String viewName, String comment) throws CommandNotSupportedException {
        CommentView cmd = (CommentView)this.createCommand(COMMENT_VIEW, viewName);
        cmd.setComment(comment);
        return cmd;
    }

    public AbstractCommand createCommandDropView(String viewname) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_VIEW, viewname);
    }

    public CreateProcedure createCommandCreateProcedure(String name) throws CommandNotSupportedException {
        return (CreateProcedure)this.createCommand(CREATE_PROCEDURE, name);
    }

    public AbstractCommand createCommandDropProcedure(String name) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_PROCEDURE, name);
    }

    public CreateFunction createCommandCreateFunction(String name) throws CommandNotSupportedException {
        return (CreateFunction)this.createCommand(CREATE_FUNCTION, name);
    }

    public AbstractCommand createCommandDropFunction(String name) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_FUNCTION, name);
    }

    public CreateTrigger createCommandCreateTrigger(String name, String tablename, int timing) throws CommandNotSupportedException {
        CreateTrigger ctrig = (CreateTrigger)this.createCommand(CREATE_TRIGGER, name);
        ctrig.setTableName(tablename);
        ctrig.setTiming(timing);
        return ctrig;
    }

    public AbstractCommand createCommandDropTrigger(String name) throws CommandNotSupportedException {
        return (AbstractCommand)this.createCommand(DROP_TRIGGER, name);
    }

    public SetDefaultDatabase createSetDefaultDatabase(String dbname) throws CommandNotSupportedException {
        SetDefaultDatabase dcmd = (SetDefaultDatabase)this.createCommand(DEFAULT_DATABASE);
        dcmd.setDatabase(dbname);
        dcmd.setObjectName(dbname);
        return dcmd;
    }

    public SetDefaultSchema createSetDefaultSchema(String schemaName) throws CommandNotSupportedException {
        SetDefaultSchema dcmd = (SetDefaultSchema)this.createCommand(DEFAULT_SCHEMA);
        dcmd.setSchema(schemaName);
        dcmd.setObjectName(schemaName);
        return dcmd;
    }

    public Map getTypeMap() {
        return (Map)this.desc.get("TypeMap");
    }

    public String getType(int type) {
        String typestr = "";
        Map typemap = this.getTypeMap();
        switch (type) {
            case 2003: {
                typestr = "ARRAY";
                break;
            }
            case -5: {
                typestr = "BIGINT";
                break;
            }
            case -2: {
                typestr = "BINARY";
                break;
            }
            case -7: {
                typestr = "BIT";
                break;
            }
            case 2004: {
                typestr = "BLOB";
                break;
            }
            case 1: {
                typestr = "CHAR";
                break;
            }
            case 2005: {
                typestr = "CLOB";
                break;
            }
            case 91: {
                typestr = "DATE";
                break;
            }
            case 3: {
                typestr = "DECIMAL";
                break;
            }
            case 2001: {
                typestr = "DISTINCT";
                break;
            }
            case 8: {
                typestr = "DOUBLE";
                break;
            }
            case 6: {
                typestr = "FLOAT";
                break;
            }
            case 4: {
                typestr = "INTEGER";
                break;
            }
            case 2000: {
                typestr = "JAVA_OBJECT";
                break;
            }
            case -4: {
                typestr = "LONGVARBINARY";
                break;
            }
            case -1: {
                typestr = "LONGVARCHAR";
                break;
            }
            case 2: {
                typestr = "NUMERIC";
                break;
            }
            case 1111: {
                typestr = "OTHER";
                break;
            }
            case 7: {
                typestr = "REAL";
                break;
            }
            case 2006: {
                typestr = "REF";
                break;
            }
            case 5: {
                typestr = "SMALLINT";
                break;
            }
            case 92: {
                typestr = "TIME";
                break;
            }
            case 93: {
                typestr = "TIMESTAMP";
                break;
            }
            case -6: {
                typestr = "TINYINT";
                break;
            }
            case -3: {
                typestr = "VARBINARY";
                break;
            }
            case 12: {
                typestr = "VARCHAR";
            }
        }
        String ret = (String)typemap.get("java.sql.Types." + typestr);
        if (ret == null) {
            ret = typestr;
        }
        return ret;
    }

    public static int getType(String type) {
        if (type.equals("java.sql.Types.ARRAY")) {
            return 2003;
        }
        if (type.equals("java.sql.Types.BIGINT")) {
            return -5;
        }
        if (type.equals("java.sql.Types.BINARY")) {
            return -2;
        }
        if (type.equals("java.sql.Types.BIT")) {
            return -7;
        }
        if (type.equals("java.sql.Types.BLOB")) {
            return 2004;
        }
        if (type.equals("java.sql.Types.CHAR")) {
            return 1;
        }
        if (type.equals("java.sql.Types.CLOB")) {
            return 2005;
        }
        if (type.equals("java.sql.Types.DATE")) {
            return 91;
        }
        if (type.equals("java.sql.Types.DECIMAL")) {
            return 3;
        }
        if (type.equals("java.sql.Types.DISTINCT")) {
            return 2001;
        }
        if (type.equals("java.sql.Types.DOUBLE")) {
            return 8;
        }
        if (type.equals("java.sql.Types.FLOAT")) {
            return 6;
        }
        if (type.equals("java.sql.Types.INTEGER")) {
            return 4;
        }
        if (type.equals("java.sql.Types.JAVA_OBJECT")) {
            return 2000;
        }
        if (type.equals("java.sql.Types.LONGVARBINARY")) {
            return -4;
        }
        if (type.equals("java.sql.Types.LONGVARCHAR")) {
            return -1;
        }
        if (type.equals("java.sql.Types.NUMERIC")) {
            return 2;
        }
        if (type.equals("java.sql.Types.OTHER")) {
            return 1111;
        }
        if (type.equals("java.sql.Types.REAL")) {
            return 7;
        }
        if (type.equals("java.sql.Types.REF")) {
            return 2006;
        }
        if (type.equals("java.sql.Types.SMALLINT")) {
            return 5;
        }
        if (type.equals("java.sql.Types.TIME")) {
            return 92;
        }
        if (type.equals("java.sql.Types.TIMESTAMP")) {
            return 93;
        }
        if (type.equals("java.sql.Types.TINYINT")) {
            return -6;
        }
        if (type.equals("java.sql.Types.VARBINARY")) {
            return -3;
        }
        if (type.equals("java.sql.Types.VARCHAR")) {
            return 12;
        }
        return -1;
    }
}

