/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.menu.MenuEditLayer;

public class KeyboardMenuNavigator
extends KeyAdapter {
    MenuEditLayer menuEditLayer;
    private RADVisualContainer menuBarRAD;
    private RADVisualContainer currentMenuRAD;
    KeyboardFinishListener listener;

    public KeyboardMenuNavigator(MenuEditLayer menuEditLayer) {
        this.menuEditLayer = menuEditLayer;
        this.configure();
    }

    public void setCurrentMenuRAD(RADVisualContainer rADVisualContainer) {
        this.currentMenuRAD = rADVisualContainer;
        this.menuBarRAD = this.getMenuBarRad(rADVisualContainer);
    }

    private RADVisualContainer getMenuBarRad(RADComponent rADComponent) {
        if (JMenuBar.class.isAssignableFrom(rADComponent.getBeanClass())) {
            return (RADVisualContainer)rADComponent;
        }
        if (rADComponent.getParentComponent() == null) {
            return null;
        }
        return this.getMenuBarRad(rADComponent.getParentComponent());
    }

    public void configure() {
        this.listener = new KeyboardFinishListener();
        this.menuEditLayer.formDesigner.getInPlaceEditLayer().addFinishListener(this.listener);
    }

    public void unconfigure() {
        this.menuEditLayer.formDesigner.getInPlaceEditLayer().removeFinishListener(this.listener);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.selectOffsetMenuItem(1);
        }
        if (keyEvent.getKeyCode() == 38) {
            this.selectOffsetMenuItem(-1);
        }
        if (keyEvent.getKeyCode() == 37) {
            this.selectOffsetMenu(-1);
        }
        if (keyEvent.getKeyCode() == 39) {
            this.selectOffsetMenu(1);
        }
        if (keyEvent.getKeyCode() == 32) {
            this.startEditing();
        }
        if (keyEvent.getKeyCode() == 65) {
            if (keyEvent.isShiftDown()) {
                this.selectNextMenuItem(-1);
            } else {
                this.selectNextMenuItem(1);
            }
        }
    }

    private void selectNextMenuItem(int n) {
        RADVisualContainer rADVisualContainer;
        RADComponent rADComponent;
        if (this.currentMenuRAD == null) {
            return;
        }
        if (!this.menuEditLayer.isComponentSelected()) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(0));
        }
        if (this.isJMenu(rADComponent = this.menuEditLayer.getSingleSelectedComponent()) && n == 1 && (rADVisualContainer = (RADVisualContainer)rADComponent).getSubComponents().length > 0) {
            this.currentMenuRAD = rADVisualContainer;
            this.selectOffsetMenuItem(n);
            return;
        }
        if (this.isLastItem(rADComponent, this.currentMenuRAD) && n == 1) {
            this.goUpOneLevelAndNext();
            return;
        }
        if (this.isFirstItem(rADComponent, this.currentMenuRAD) && n == -1) {
            this.goUpOneLevel();
            return;
        }
        this.selectOffsetMenuItem(n);
    }

    private void selectOffsetMenuItem(int n) {
        if (this.currentMenuRAD == null) {
            return;
        }
        if (this.currentMenuRAD.getSubComponents().length == 0) {
            this.menuEditLayer.setSelectedRADComponent(null);
            return;
        }
        if (!this.menuEditLayer.isComponentSelected()) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(0));
            return;
        }
        int n2 = this.currentMenuRAD.getIndexOf(this.menuEditLayer.getSingleSelectedComponent());
        if (n2 + n >= 0 && n2 + n < this.currentMenuRAD.getSubComponents().length) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(n2 + n));
        } else if (n2 >= 0 && n2 < this.currentMenuRAD.getSubComponents().length) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(n2));
        }
    }

    private boolean isJMenu(RADComponent rADComponent) {
        return this.menuEditLayer.formDesigner.getComponent(rADComponent) instanceof JMenu;
    }

    private void selectOffsetMenu(int n) {
        RADVisualContainer rADVisualContainer;
        if (this.isJMenu(this.menuEditLayer.getSingleSelectedComponent()) && (rADVisualContainer = (RADVisualContainer)this.menuEditLayer.getSingleSelectedComponent()).getSubComponents() != null && rADVisualContainer.getSubComponents().length > 0 && rADVisualContainer.getSubComponent(0) != null) {
            RADVisualComponent rADVisualComponent = rADVisualContainer.getSubComponent(0);
            this.menuEditLayer.showMenuPopup((JMenu)this.menuEditLayer.formDesigner.getComponent(this.menuEditLayer.getSingleSelectedComponent()));
            this.menuEditLayer.setSelectedRADComponent(rADVisualComponent);
            this.currentMenuRAD = rADVisualContainer;
            return;
        }
        int n2 = this.menuBarRAD.getIndexOf(this.currentMenuRAD);
        if (n2 < 0) {
            if (n < 0) {
                this.goUpOneLevel();
                return;
            }
            if (n > 0) {
                this.currentMenuRAD = this.getTopLevelMenu(this.currentMenuRAD);
                n2 = this.menuBarRAD.getIndexOf(this.currentMenuRAD);
            }
        }
        if ((n2 += n) < 0) {
            n2 = this.menuBarRAD.getSubComponents().length - 1;
        }
        if (n2 >= this.menuBarRAD.getSubComponents().length) {
            n2 = 0;
        }
        this.currentMenuRAD = (RADVisualContainer)this.menuBarRAD.getSubComponent(n2);
        JMenu jMenu = (JMenu)this.menuEditLayer.formDesigner.getComponent(this.currentMenuRAD);
        this.menuEditLayer.openMenu(this.currentMenuRAD, jMenu);
        if (this.currentMenuRAD.getSubComponents().length > 0) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponents()[0]);
        }
    }

    private void goUpOneLevel() {
        this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD);
        this.currentMenuRAD = this.currentMenuRAD.getParentContainer();
    }

    private void goUpOneLevelAndNext() {
        this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD);
        this.currentMenuRAD = this.currentMenuRAD.getParentContainer();
        if (this.isLastItem(this.menuEditLayer.getSingleSelectedComponent(), this.currentMenuRAD)) {
            this.goUpOneLevelAndNext();
            return;
        }
        this.selectOffsetMenuItem(1);
    }

    private boolean isFirstItem(RADComponent rADComponent, RADVisualContainer rADVisualContainer) {
        int n = rADVisualContainer.getIndexOf(rADComponent);
        return n == 0;
    }

    private boolean isLastItem(RADComponent rADComponent, RADVisualContainer rADVisualContainer) {
        int n = rADVisualContainer.getIndexOf(rADComponent);
        return n == rADVisualContainer.getSubComponents().length - 1;
    }

    private RADVisualContainer getTopLevelMenu(RADVisualContainer rADVisualContainer) {
        if (this.menuBarRAD.getIndexOf(rADVisualContainer) >= 0) {
            return rADVisualContainer;
        }
        return this.getTopLevelMenu(rADVisualContainer.getParentContainer());
    }

    private void startEditing() {
        this.menuEditLayer.configureEditedComponent(this.menuEditLayer.getSingleSelectedComponent());
        this.menuEditLayer.formDesigner.startInPlaceEditing(this.menuEditLayer.getSingleSelectedComponent());
    }

    private class KeyboardFinishListener
    implements InPlaceEditLayer.FinishListener {
        private KeyboardFinishListener() {
        }

        public void editingFinished(boolean bl) {
            if (KeyboardMenuNavigator.this.menuEditLayer.isVisible()) {
                KeyboardMenuNavigator.this.menuEditLayer.glassLayer.requestFocusInWindow();
            }
        }
    }
}

