/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutUtils
implements LayoutConstants {
    private LayoutUtils() {
    }

    public static LayoutInterval getAdjacentEmptySpace(LayoutComponent layoutComponent, int n, int n2) {
        LayoutInterval layoutInterval;
        LayoutInterval layoutInterval2 = layoutComponent.getLayoutInterval(n);
        LayoutInterval layoutInterval3 = LayoutInterval.getNeighbor(layoutInterval2, n2, false, true, false);
        if (layoutInterval3 != null && layoutInterval3.isEmptySpace() && ((layoutInterval = LayoutInterval.getDirectNeighbor(layoutInterval3, n2 ^ 1, true)) == layoutInterval2 || LayoutInterval.isPlacedAtBorder(layoutInterval2, layoutInterval, n, n2))) {
            return layoutInterval3;
        }
        return null;
    }

    public static boolean hasAdjacentComponent(LayoutComponent layoutComponent, int n, int n2) {
        return LayoutInterval.getNeighbor(layoutComponent.getLayoutInterval(n), n2, true, true, false) != null;
    }

    static LayoutInterval getOutermostComponent(LayoutInterval layoutInterval, int n, int n2) {
        if (layoutInterval.isComponent()) {
            return layoutInterval;
        }
        assert (n2 == 0 || n2 == 1);
        if (layoutInterval.isSequential()) {
            int n3;
            int n4 = n2 == 0 ? 1 : -1;
            int n5 = n3 = n2 == 0 ? 0 : layoutInterval.getSubIntervalCount() - 1;
            while (n3 >= 0 && n3 < layoutInterval.getSubIntervalCount()) {
                LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(n3);
                if (layoutInterval2.isEmptySpace()) {
                    n3 += n4;
                    continue;
                }
                return LayoutUtils.getOutermostComponent(layoutInterval2, n, n2);
            }
        } else if (layoutInterval.isParallel()) {
            LayoutInterval layoutInterval3 = null;
            int n6 = Integer.MAX_VALUE;
            int n7 = layoutInterval.getSubIntervalCount();
            for (int i = 0; i < n7; ++i) {
                LayoutInterval layoutInterval4 = LayoutUtils.getOutermostComponent(layoutInterval.getSubInterval(i), n, n2);
                if (layoutInterval4 == null) continue;
                if (LayoutInterval.isAlignedAtBorder(layoutInterval4, layoutInterval, n2)) {
                    return layoutInterval4;
                }
                int n8 = layoutInterval4.getCurrentSpace().positions[n][n2] * (n2 == 0 ? 1 : -1);
                if (n8 >= n6) continue;
                layoutInterval3 = layoutInterval4;
                n6 = n8;
            }
            return layoutInterval3;
        }
        return null;
    }

    static int getSizeOfDefaultGap(LayoutInterval layoutInterval, VisualMapper visualMapper) {
        assert (layoutInterval.isEmptySpace());
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2.isParallel()) {
            return layoutInterval.getPreferredSize();
        }
        LayoutInterval layoutInterval3 = layoutInterval;
        LayoutInterval layoutInterval4 = null;
        LayoutInterval layoutInterval5 = null;
        while (layoutInterval2 != null && (layoutInterval4 == null || layoutInterval5 == null)) {
            int n = layoutInterval2.indexOf(layoutInterval3);
            if (layoutInterval4 == null && n > 0) {
                layoutInterval4 = layoutInterval2.getSubInterval(n - 1);
            }
            if (layoutInterval5 == null && n < layoutInterval2.getSubIntervalCount() - 1) {
                layoutInterval5 = layoutInterval2.getSubInterval(n + 1);
            }
            if (layoutInterval4 != null && layoutInterval5 != null) continue;
            do {
                layoutInterval3 = layoutInterval2;
            } while ((layoutInterval2 = layoutInterval2.getParent()) != null && layoutInterval2.isParallel());
        }
        List<LayoutInterval> list = LayoutUtils.edgeSubComponents(layoutInterval4, 1);
        List<LayoutInterval> list2 = LayoutUtils.edgeSubComponents(layoutInterval5, 0);
        return LayoutUtils.getSizesOfDefaultGap(list, list2, layoutInterval.getPaddingType(), visualMapper, null, Collections.EMPTY_MAP)[0];
    }

    static int[] getSizesOfDefaultGap(List list, List list2, LayoutConstants.PaddingType paddingType, VisualMapper visualMapper, String string, Map<String, LayoutRegion> map) {
        int n;
        Object object;
        Object object22;
        if (list != null && list.isEmpty() || list2 != null && list2.isEmpty()) {
            return new int[]{0};
        }
        list = list == null ? Collections.EMPTY_LIST : list;
        list2 = list2 == null ? Collections.EMPTY_LIST : list2;
        boolean bl = false;
        int n2 = -1;
        LayoutInterval layoutInterval = null;
        if (list.isEmpty()) {
            if (list2.isEmpty()) {
                return new int[]{0};
            }
            bl = true;
            n2 = 0;
            layoutInterval = (LayoutInterval)list2.get(0);
        } else {
            layoutInterval = (LayoutInterval)list.get(0);
            if (list2.isEmpty()) {
                bl = true;
                n2 = 1;
            }
        }
        int n3 = layoutInterval == layoutInterval.getComponent().getLayoutInterval(0) ? 0 : 1;
        int n4 = Short.MIN_VALUE;
        int n5 = Short.MAX_VALUE;
        boolean bl2 = false;
        for (Object object22 : list) {
            object = LayoutUtils.sizeOfEmptySpaceHelper((LayoutInterval)object22, map);
            n = ((LayoutRegion)object).positions[n3][1];
            if (n == Integer.MIN_VALUE) {
                bl2 = true;
                break;
            }
            n4 = Math.max(n4, n);
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object22 = (LayoutInterval)iterator.next();
            object = LayoutUtils.sizeOfEmptySpaceHelper((LayoutInterval)object22, map);
            n = ((LayoutRegion)object).positions[n3][0];
            if (n == Integer.MIN_VALUE) {
                bl2 = true;
                break;
            }
            n5 = Math.min(n5, n);
        }
        if (bl) {
            object22 = new int[1];
            Iterator iterator2 = iterator = list.isEmpty() ? list2.iterator() : list.iterator();
            while (iterator.hasNext()) {
                int n6;
                object = (LayoutInterval)iterator.next();
                LayoutComponent layoutComponent = ((LayoutInterval)object).getComponent();
                LayoutRegion layoutRegion = LayoutUtils.sizeOfEmptySpaceHelper((LayoutInterval)object, map);
                String string2 = string == null ? layoutComponent.getParent().getId() : string;
                int n7 = visualMapper.getPreferredPaddingInParent(string2, layoutComponent.getId(), n3, n2);
                int n8 = layoutRegion.positions[n3][n2];
                int n9 = n6 = n2 == 0 ? n8 - n5 : n4 - n8;
                if (!bl2) {
                    n7 -= n6;
                }
                object22[0] = Math.max((int)object22[0], n7);
            }
        } else {
            LayoutConstants.PaddingType[] paddingTypeArray;
            if (paddingType != null) {
                LayoutConstants.PaddingType[] paddingTypeArray2 = new LayoutConstants.PaddingType[1];
                paddingTypeArray = paddingTypeArray2;
                paddingTypeArray2[0] = paddingType;
            } else {
                paddingTypeArray = PADDINGS;
            }
            object = paddingTypeArray;
            object22 = new int[((LayoutConstants.PaddingType[])object).length];
            for (LayoutInterval layoutInterval2 : list) {
                String string3 = layoutInterval2.getComponent().getId();
                LayoutRegion layoutRegion = LayoutUtils.sizeOfEmptySpaceHelper(layoutInterval2, map);
                int n10 = n4 - layoutRegion.positions[n3][1];
                for (LayoutInterval layoutInterval3 : list2) {
                    String string4 = layoutInterval3.getComponent().getId();
                    LayoutRegion layoutRegion2 = LayoutUtils.sizeOfEmptySpaceHelper(layoutInterval3, map);
                    int n11 = layoutRegion2.positions[n3][0] - n5;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        Object object3 = object[i];
                        int n12 = visualMapper.getPreferredPadding(string3, string4, n3, 0, (LayoutConstants.PaddingType)((Object)object3));
                        if (!bl2) {
                            n12 -= n10 + n11;
                        }
                        object22[i] = Math.max((int)object22[i], n12);
                    }
                }
            }
        }
        return object22;
    }

    private static LayoutRegion sizeOfEmptySpaceHelper(LayoutInterval layoutInterval, Map<String, LayoutRegion> map) {
        LayoutComponent layoutComponent = layoutInterval.getComponent();
        String string = layoutComponent.getId();
        if (map.containsKey(string)) {
            return map.get(string);
        }
        return layoutInterval.getCurrentSpace();
    }

    static int getVisualPosition(LayoutInterval layoutInterval, int n, int n2) {
        if (layoutInterval.isEmptySpace()) {
            assert (n2 == 0 || n2 == 1);
            LayoutInterval layoutInterval2 = LayoutInterval.getDirectNeighbor(layoutInterval, n2, false);
            if (layoutInterval2 != null) {
                layoutInterval = layoutInterval2;
                n2 ^= 1;
            } else {
                layoutInterval = LayoutInterval.getFirstParent(layoutInterval, 103);
            }
        }
        return layoutInterval.getCurrentSpace().positions[n][n2];
    }

    static List<LayoutInterval> edgeSubComponents(LayoutInterval layoutInterval, int n) {
        LinkedList<LayoutInterval> linkedList = null;
        LinkedList<LayoutInterval> linkedList2 = new LinkedList<LayoutInterval>();
        if (layoutInterval != null) {
            linkedList = new LinkedList<LayoutInterval>();
            linkedList2.add(layoutInterval);
        }
        while (!linkedList2.isEmpty()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)linkedList2.get(0);
            linkedList2.remove(layoutInterval2);
            if (layoutInterval2.isGroup()) {
                if (layoutInterval2.isSequential()) {
                    int n2 = n == 0 ? 0 : layoutInterval2.getSubIntervalCount() - 1;
                    linkedList2.add(layoutInterval2.getSubInterval(n2));
                    continue;
                }
                Iterator<LayoutInterval> iterator = layoutInterval2.getSubIntervals();
                while (iterator.hasNext()) {
                    linkedList2.add(iterator.next());
                }
                continue;
            }
            if (!layoutInterval2.isComponent()) continue;
            linkedList.add(layoutInterval2);
        }
        return linkedList;
    }

    static boolean contentOverlap(LayoutRegion layoutRegion, LayoutInterval layoutInterval, int n) {
        return LayoutUtils.contentOverlap(layoutRegion, layoutInterval, -1, -1, n);
    }

    static boolean contentOverlap(LayoutRegion layoutRegion, LayoutInterval layoutInterval, int n, int n2, int n3) {
        boolean bl;
        LayoutRegion layoutRegion2 = layoutInterval.getCurrentSpace();
        if (!layoutInterval.isGroup()) {
            return LayoutRegion.overlap(layoutRegion, layoutRegion2, n3, 0);
        }
        boolean bl2 = bl = !layoutRegion2.isSet(n3) || LayoutRegion.overlap(layoutRegion, layoutRegion2, n3, 0);
        if (bl) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = layoutInterval.getSubIntervalCount() - 1;
            }
            assert (n <= n2);
            bl = false;
            for (int i = n; i <= n2; ++i) {
                LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
                if (layoutInterval2.isEmptySpace() || !LayoutUtils.contentOverlap(layoutRegion, layoutInterval2, n3)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static boolean contentOverlap(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        return LayoutUtils.contentOverlap(layoutInterval, layoutInterval2, -1, -1, n);
    }

    static boolean contentOverlap(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2, int n3) {
        Object object;
        if (!layoutInterval2.isGroup()) {
            if (!layoutInterval.isGroup()) {
                return LayoutRegion.overlap(layoutInterval.getCurrentSpace(), layoutInterval2.getCurrentSpace(), n3, 0);
            }
            object = layoutInterval;
            layoutInterval = layoutInterval2;
            layoutInterval2 = object;
        }
        object = null;
        Object object2 = null;
        Iterator iterator = LayoutUtils.getComponentIterator(layoutInterval);
        while (iterator.hasNext()) {
            Iterator iterator2;
            LayoutRegion layoutRegion = ((LayoutInterval)iterator.next()).getCurrentSpace();
            Iterator iterator3 = iterator2 = object != null ? object.iterator() : LayoutUtils.getComponentIterator(layoutInterval2, n, n2);
            if (object == null && iterator.hasNext()) {
                object2 = object = new LinkedList();
            }
            while (iterator2.hasNext()) {
                LayoutInterval layoutInterval3 = (LayoutInterval)iterator2.next();
                if (LayoutRegion.overlap(layoutRegion, layoutInterval3.getCurrentSpace(), n3, 0)) {
                    return true;
                }
                if (object2 == null) continue;
                object2.add(layoutInterval3);
            }
            object2 = null;
        }
        return false;
    }

    static boolean isOverlapPreventedInOtherDimension(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        int n2 = n ^ 1;
        layoutInterval = (LayoutInterval)LayoutUtils.getComponentIterator(layoutInterval).next();
        LayoutComponent layoutComponent = layoutInterval.getComponent();
        LayoutInterval layoutInterval3 = layoutComponent.getLayoutInterval(n2);
        Iterator iterator = LayoutUtils.getComponentIterator(layoutInterval2);
        assert (iterator.hasNext());
        do {
            LayoutComponent layoutComponent2;
            LayoutInterval layoutInterval4;
            LayoutInterval layoutInterval5;
            if ((layoutInterval5 = LayoutInterval.getCommonParent(layoutInterval3, layoutInterval4 = (layoutComponent2 = ((LayoutInterval)iterator.next()).getComponent()).getLayoutInterval(n2))) != null && !layoutInterval5.isParallel()) continue;
            return false;
        } while (iterator.hasNext());
        return true;
    }

    static Iterator getComponentIterator(LayoutInterval layoutInterval) {
        return new ComponentIterator(layoutInterval, 0, layoutInterval.getSubIntervalCount() - 1);
    }

    static Iterator getComponentIterator(LayoutInterval layoutInterval, int n, int n2) {
        return new ComponentIterator(layoutInterval, n, n2);
    }

    private static class ComponentIterator
    implements Iterator {
        private LayoutInterval root;
        private int startIndex;
        private int endIndex;
        private boolean initialized;
        private int index;
        private LayoutInterval next;

        ComponentIterator(LayoutInterval layoutInterval, int n, int n2) {
            this.root = layoutInterval;
            this.startIndex = n;
            this.endIndex = n2;
            this.findNext();
            this.initialized = true;
        }

        private void findNext() {
            int n;
            LayoutInterval layoutInterval;
            if (this.next == null) {
                if (this.initialized) {
                    return;
                }
                if (!this.root.isGroup()) {
                    if (this.root.isComponent()) {
                        this.next = this.root;
                    }
                    return;
                }
                layoutInterval = this.root;
                n = this.startIndex;
            } else if (this.next != this.root) {
                layoutInterval = this.next.getParent();
                n = this.index + 1;
            } else {
                this.next = null;
                return;
            }
            this.next = null;
            while (true) {
                if (n < layoutInterval.getSubIntervalCount()) {
                    if (layoutInterval == this.root && n > this.endIndex) {
                        return;
                    }
                    LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(n);
                    if (layoutInterval2.isComponent()) {
                        this.next = layoutInterval2;
                        this.index = n;
                        return;
                    }
                    if (layoutInterval2.isGroup()) {
                        layoutInterval = layoutInterval2;
                        n = 0;
                        continue;
                    }
                    ++n;
                    continue;
                }
                if (layoutInterval == this.root) break;
                n = layoutInterval.getParent().indexOf(layoutInterval) + 1;
                layoutInterval = layoutInterval.getParent();
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LayoutInterval layoutInterval = this.next;
            this.findNext();
            return layoutInterval;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

