/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors2.TreeModelCustomizer;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeModelEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
FormCodeAwareEditor {
    private static final String NODE_VARIABLE_NAME = "treeNode";
    private FormModel formModel;
    private FormProperty property;
    private static final String XML_TREE_MODEL = "TreeModel";
    private static final String ATTR_CODE = "code";

    public String getSourceCode() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getValue();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.generateCode(defaultMutableTreeNode, null, 0, stringBuilder);
        RADProperty rADProperty = (RADProperty)this.property;
        RADComponent rADComponent = rADProperty.getRADComponent();
        CodeVariable codeVariable = rADComponent.getCodeExpression().getVariable();
        String string2 = codeVariable == null ? null : codeVariable.getName();
        String string3 = rADProperty.getPropertyDescriptor().getWriteMethod().getName();
        if (string2 != null) {
            string3 = string2 + '.' + string3;
        }
        stringBuilder.append(string3).append("(new ");
        stringBuilder.append(DefaultTreeModel.class.getName()).append('(').append(string).append("));\n");
        return stringBuilder.toString();
    }

    private String generateCode(DefaultMutableTreeNode defaultMutableTreeNode, String string, int n, StringBuilder stringBuilder) {
        String string2;
        String string3;
        CodeVariable codeVariable;
        CodeStructure codeStructure = this.formModel.getCodeStructure();
        while ((codeVariable = codeStructure.getVariable(string3 = NODE_VARIABLE_NAME + ++n)) != null && !DefaultMutableTreeNode.class.equals((Object)codeVariable.getDeclaredType())) {
        }
        if (codeVariable == null) {
            string2 = codeStructure.getExternalVariableName(DefaultMutableTreeNode.class, string3, true);
            assert (string3.equals(string2));
            stringBuilder.append(DefaultMutableTreeNode.class.getName()).append(' ');
        }
        stringBuilder.append(string3).append(" = new ");
        stringBuilder.append(DefaultMutableTreeNode.class.getName()).append('(').append('\"');
        string2 = defaultMutableTreeNode.getUserObject().toString();
        string2 = string2.replace("\"", "\\\"");
        stringBuilder.append(string2).append("\");\n");
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.generateCode(defaultMutableTreeNode2, string3, n, stringBuilder);
        }
        if (string != null) {
            stringBuilder.append(string).append(".add(").append(string3).append(");\n");
        }
        return string3;
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.formModel = formModel;
        this.property = formProperty;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new TreeModelCustomizer(this);
    }

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = NbBundle.getMessage(TreeModelEditor.class, (String)"MSG_TreeModel");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    public String getDisplayName() {
        return NbBundle.getBundle(TreeModelEditor.class).getString("CTL_TreeModelEditor_DisplayName");
    }

    TreeModel createTreeModel(String string) {
        int n;
        Object object;
        Object object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            object = ((String)object2).trim();
            if (((String)object).length() == 0) continue;
            n = 0;
            while (((String)object2).charAt(n) == ' ') {
                ++n;
            }
            arrayList.add(n);
            arrayList2.add(object);
        }
        object2 = null;
        object = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            Object object3;
            int n2;
            int n3;
            int n4 = (Integer)arrayList.get(n);
            String string2 = (String)arrayList2.get(n);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
            object.add(defaultMutableTreeNode);
            if (n == 0) continue;
            for (n3 = n - 1; n3 >= 0 && (n2 = ((Integer)arrayList.get(n3)).intValue()) >= n4; --n3) {
            }
            if (n3 >= 0) {
                object3 = (DefaultMutableTreeNode)object.get(n3);
            } else {
                if (object2 == null) {
                    object2 = new DefaultMutableTreeNode("root");
                    ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object.get(0));
                }
                object3 = object2;
            }
            ((DefaultMutableTreeNode)object3).add(defaultMutableTreeNode);
        }
        if (object.size() == 0) {
            object2 = new DefaultMutableTreeNode("root");
        }
        if (object2 == null) {
            object2 = (DefaultMutableTreeNode)object.get(0);
        }
        ((DefaultMutableTreeNode)object2).setUserObject(new CodeUserObject(((DefaultMutableTreeNode)object2).getUserObject().toString(), string));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)object2);
        return defaultTreeModel;
    }

    String getCodeValue() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        DefaultTreeModel defaultTreeModel;
        Object object2;
        Object object3 = this.getValue();
        if (object3 instanceof DefaultTreeModel && (object2 = (defaultTreeModel = (DefaultTreeModel)object3).getRoot()) instanceof DefaultMutableTreeNode && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)object2).getUserObject()) instanceof CodeUserObject) {
            CodeUserObject codeUserObject = (CodeUserObject)object;
            return codeUserObject.code;
        }
        return null;
    }

    public void updateFormVersionLevel() {
        this.formModel.raiseVersionLevel(FormModel.FormVersion.NB65, FormModel.FormVersion.NB65);
    }

    public void readFromXML(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_CODE);
        String string = node2.getNodeValue();
        this.setValue(this.createTreeModel(string));
    }

    public Node storeToXML(Document document) {
        String string = this.getCodeValue();
        if (string != null) {
            Element element = document.createElement(XML_TREE_MODEL);
            element.setAttribute(ATTR_CODE, string);
            return element;
        }
        return null;
    }

    static class CodeUserObject
    implements Serializable {
        String name;
        String code;

        CodeUserObject(String string, String string2) {
            this.name = string;
            this.code = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

