/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors2.TableColumnModelEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JTableHeaderEditor
extends PropertyEditorSupport
implements NamedPropertyEditor,
FormCodeAwareEditor,
XMLPropertyEditor {
    private FormProperty property;
    private boolean initialized;
    private static final String XML_TABLE_HEADER = "TableHeader";
    private static final String ATTR_RESIZING = "resizingAllowed";
    private static final String ATTR_REORDERING = "reorderingAllowed";
    private JPanel customizer;
    private JCheckBox reorderingCheckBox;
    private JCheckBox resizingCheckBox;

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"TableHeaderEditor");
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.property = formProperty;
    }

    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (!this.initialized) {
            this.initialized = true;
            this.initComponents();
        }
        this.updateUI();
        return this.customizer;
    }

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = NbBundle.getMessage(TableColumnModelEditor.class, (String)"TableHeaderEditor_TableHeader");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    private void initComponents() {
        this.customizer = new JPanel();
        this.resizingCheckBox = new JCheckBox();
        this.reorderingCheckBox = new JCheckBox();
        FormListener formListener = new FormListener();
        this.resizingCheckBox.setText(NbBundle.getMessage(JTableHeaderEditor.class, (String)"TableHeaderEditor_Resizing"));
        this.resizingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resizingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.resizingCheckBox.addActionListener(formListener);
        this.reorderingCheckBox.setText(NbBundle.getMessage(JTableHeaderEditor.class, (String)"TableHeaderEditor_Reordering"));
        this.reorderingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reorderingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.reorderingCheckBox.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this.customizer);
        this.customizer.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.resizingCheckBox).add((Component)this.reorderingCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.resizingCheckBox).addPreferredGap(0).add((Component)this.reorderingCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void headerChanged(ActionEvent actionEvent) {
        this.updateFromUI();
        this.firePropertyChange();
    }

    private void updateFromUI() {
        this.setValue(new FormTableHeader(this.property, this.resizingCheckBox.isSelected(), this.reorderingCheckBox.isSelected()));
    }

    private void updateUI() {
        Object object = this.getValue();
        boolean bl = true;
        boolean bl2 = true;
        if (object instanceof FormTableHeader) {
            FormTableHeader formTableHeader = (FormTableHeader)object;
            bl = formTableHeader.isResizingAllowed();
            bl2 = formTableHeader.isReorderingAllowed();
        } else if (object instanceof JTableHeader) {
            JTableHeader jTableHeader = (JTableHeader)object;
            bl = jTableHeader.getResizingAllowed();
            bl2 = jTableHeader.getReorderingAllowed();
        }
        this.resizingCheckBox.setSelected(bl);
        this.reorderingCheckBox.setSelected(bl2);
    }

    public String getSourceCode() {
        Object object;
        RADProperty rADProperty = (RADProperty)this.property;
        RADComponent rADComponent = rADProperty.getRADComponent();
        CodeVariable codeVariable = rADComponent.getCodeExpression().getVariable();
        String string = codeVariable == null ? null : codeVariable.getName();
        String string2 = rADProperty.getPropertyDescriptor().getReadMethod().getName();
        String string3 = string2 + "()";
        if (string != null) {
            string3 = string + '.' + string3;
        }
        boolean bl = true;
        boolean bl2 = true;
        Object object2 = this.getValue();
        if (object2 instanceof FormTableHeader) {
            object = (FormTableHeader)object2;
            bl = ((FormTableHeader)object).isResizingAllowed();
            bl2 = ((FormTableHeader)object).isReorderingAllowed();
        }
        object = "";
        if (!bl) {
            object = (String)object + string3 + ".setResizingAllowed(false);\n";
        }
        if (!bl2) {
            object = (String)object + string3 + ".setReorderingAllowed(false);\n";
        }
        return bl && bl2 ? null : object;
    }

    public void readFromXML(Node node) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(ATTR_RESIZING);
        boolean bl = true;
        if (node2 != null) {
            bl = Boolean.valueOf(node2.getNodeValue());
        }
        node2 = namedNodeMap.getNamedItem(ATTR_REORDERING);
        boolean bl2 = true;
        if (node2 != null) {
            bl2 = Boolean.valueOf(node2.getNodeValue());
        }
        this.setValue(new FormTableHeader(this.property, bl, bl2));
    }

    public Node storeToXML(Document document) {
        Object object = this.getValue();
        Element element = null;
        if (object instanceof FormTableHeader) {
            FormTableHeader formTableHeader = (FormTableHeader)object;
            element = document.createElement(XML_TABLE_HEADER);
            element.setAttribute(ATTR_RESIZING, Boolean.toString(formTableHeader.isResizingAllowed()));
            element.setAttribute(ATTR_REORDERING, Boolean.toString(formTableHeader.isReorderingAllowed()));
        }
        return element;
    }

    public static class FormTableHeader
    extends FormDesignValueAdapter {
        private FormProperty property;
        private boolean resizingAllowed;
        private boolean reorderingAllowed;

        public FormTableHeader(FormProperty formProperty, boolean bl, boolean bl2) {
            this.property = formProperty;
            this.resizingAllowed = bl;
            this.reorderingAllowed = bl2;
        }

        public boolean isResizingAllowed() {
            return this.resizingAllowed;
        }

        public boolean isReorderingAllowed() {
            return this.reorderingAllowed;
        }

        public Object getDesignValue() {
            Object object = null;
            try {
                object = this.property.getTargetValue();
                if (object instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)object;
                    jTableHeader.setResizingAllowed(this.resizingAllowed);
                    jTableHeader.setReorderingAllowed(this.reorderingAllowed);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, invocationTargetException.getMessage(), invocationTargetException);
            }
            return object;
        }

        public Object getDesignValue(Object object) {
            JTableHeader jTableHeader = null;
            if (object instanceof JTable) {
                jTableHeader = ((JTable)object).getTableHeader();
                jTableHeader.setResizingAllowed(this.resizingAllowed);
                jTableHeader.setReorderingAllowed(this.reorderingAllowed);
            }
            return jTableHeader;
        }

        public Object copy(FormProperty formProperty) {
            return new FormTableHeader(formProperty, this.resizingAllowed, this.reorderingAllowed);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JTableHeaderEditor.this.resizingCheckBox) {
                JTableHeaderEditor.this.headerChanged(actionEvent);
            } else if (actionEvent.getSource() == JTableHeaderEditor.this.reorderingCheckBox) {
                JTableHeaderEditor.this.headerChanged(actionEvent);
            }
        }
    }
}

