/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FontEditor
extends ResourceWrapperEditor
implements XMLPropertyEditor {
    public static final String XML_FONT_ROOT = "FontInfo";
    public static final String XML_FONT = "Font";
    public static final String ATTR_RELATIVE = "relative";
    public static final String ATTR_RELATIVE_SIZE = "relativeSize";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_ITALIC_CHANGE = "italic";
    public static final String ATTR_BOLD_CHANGE = "bold";
    public static final String ATTR_COMP_NAME = "component";
    public static final String ATTR_PROP_NAME = "property";

    public FontEditor() {
        super(PropertyEditorManager.findEditor(Font.class));
    }

    public PropertyEditor getDelegatedPropertyEditor() {
        Object object = this.getValue();
        if (!(object instanceof NbFont)) {
            return super.getDelegatedPropertyEditor();
        }
        return this;
    }

    public void updateFormVersionLevel() {
        if (this.getValue() instanceof NbFont) {
            this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60_PRE, FormModel.FormVersion.NB60);
        } else {
            super.updateFormVersionLevel();
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        super.attachEnv(propertyEnv);
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor != null) {
            featureDescriptor.setValue("canEditAsText", Boolean.FALSE);
        }
    }

    public Object getUnwrappedValue() {
        Object object = this.getValue();
        return object instanceof ResourceValue ? ((ResourceValue)object).getDesignValue() : object;
    }

    protected void setValueToDelegate(Object object) {
        if (object instanceof ResourceValue) {
            object = ((ResourceValue)object).getValue();
        }
        if (object instanceof NbFont) {
            object = ((NbFont)object).getDesignValue();
        }
        this.delegateEditor.setValue(object);
    }

    public String getJavaInitializationString() {
        String string;
        Object object = this.getValue();
        if (object instanceof NbFont) {
            boolean bl;
            NbFont nbFont = (NbFont)object;
            RADProperty rADProperty = (RADProperty)this.property;
            RADComponent rADComponent = rADProperty.getRADComponent();
            CodeVariable codeVariable = rADComponent.getCodeExpression().getVariable();
            String string2 = codeVariable == null ? null : codeVariable.getName();
            String string3 = rADProperty.getPropertyDescriptor().getReadMethod().getName();
            String string4 = string3 + "()";
            if (string2 != null) {
                string4 = string2 + '.' + string4;
            }
            string = string4 + ".deriveFont(";
            boolean bl2 = bl = nbFont.italic != null || nbFont.bold != null;
            if (bl) {
                String string5 = null;
                if (nbFont.italic != null) {
                    string5 = string4 + ".getStyle()";
                    string5 = Boolean.TRUE.equals(nbFont.italic) ? string5 + " | " : string5 + " & ~";
                    string5 = string5 + "java.awt.Font.ITALIC";
                }
                string5 = string5 == null ? string4 + ".getStyle()" : "(" + string5 + ")";
                if (nbFont.bold != null) {
                    string5 = Boolean.TRUE.equals(nbFont.bold) ? string5 + " | " : string5 + " & ~";
                    string5 = string5 + "java.awt.Font.BOLD";
                }
                string = string + string5;
            }
            if (nbFont.absoluteSize) {
                string = string + (bl ? ", " : "(float)");
                string = string + nbFont.size + ")";
            } else if (nbFont.size == 0) {
                string = bl ? string + ')' : string4;
            } else {
                if (bl) {
                    string = string + ", ";
                }
                string = string + string4 + ".getSize()";
                if (nbFont.size > 0) {
                    string = string + '+';
                }
                string = string + nbFont.size;
                if (!bl) {
                    string = string + "f";
                }
                string = string + ")";
            }
        } else {
            string = object instanceof Font ? "*/\n\\1NOI18N*/\n\\0" + this.delegateEditor.getJavaInitializationString() : super.getJavaInitializationString();
        }
        return string;
    }

    public String getAsText() {
        Object object = this.getValue();
        return object instanceof NbFont ? ((NbFont)object).getDescription() : super.getAsText();
    }

    protected Component createCustomEditorGUI(final Component component) {
        Component component2;
        Object object = this.getUnwrappedValue();
        boolean bl = !(object instanceof NbFont);
        final Component component3 = bl ? this.createAbsolutePanel(component) : null;
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setVisible(this.property instanceof RADProperty);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)NbBundle.getMessage(FontEditor.class, (String)"CTL_DeriveFont"));
        jCheckBox.setSelected(!bl);
        final RelativeFontPanel relativeFontPanel = new RelativeFontPanel();
        Component component4 = component2 = bl ? component3 : relativeFontPanel;
        if (!bl) {
            relativeFontPanel.updateFromPropertyValue();
        }
        final JPanel jPanel = new JPanel();
        final GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jCheckBox)).add(component2));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jCheckBox).addPreferredGap(0).add(component2));
        jCheckBox.addItemListener(new ItemListener(){
            private Component absoluteInLayout;
            {
                this.absoluteInLayout = component3;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (jCheckBox.isSelected()) {
                    groupLayout.replace(this.absoluteInLayout, (Component)relativeFontPanel);
                    FontEditor.this.convertToRelative();
                    relativeFontPanel.updateFromPropertyValue();
                } else {
                    this.absoluteInLayout = FontEditor.this.createAbsolutePanel(component);
                    groupLayout.replace((Component)relativeFontPanel, this.absoluteInLayout);
                    FontEditor.this.convertToAbsolute();
                }
                jPanel.revalidate();
                jPanel.repaint();
            }
        });
        return jPanel;
    }

    private Component createAbsolutePanel(Component component) {
        Component component2 = this.delegateEditor.getCustomEditor();
        if (component == null) {
            return component2;
        }
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        groupLayout.setAutocreateGaps(true);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add(component2).add(component));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add(component2).add(component));
        return jPanel;
    }

    private void convertToRelative() {
        boolean bl;
        boolean bl2;
        Object object = this.getUnwrappedValue();
        if (!(object instanceof Font)) {
            return;
        }
        Font font = (Font)object;
        NbFont nbFont = new NbFont();
        nbFont.property = this.property;
        Font font2 = (Font)this.property.getDefaultValue();
        if (nbFont.absoluteSize) {
            nbFont.size = font.getSize();
        } else {
            if (font2 == null) {
                return;
            }
            nbFont.size = font.getSize() - font2.getSize();
        }
        if (font2 == null) {
            return;
        }
        int n = font.getStyle();
        int n2 = font2.getStyle();
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = bl2 = (n2 & 2) != 0;
        if (bl3 && !bl2) {
            nbFont.italic = Boolean.TRUE;
        }
        if (!bl3 && bl2) {
            nbFont.italic = Boolean.FALSE;
        }
        if (nbFont.italic != null && bl3 == bl2 && bl3 != nbFont.italic) {
            nbFont.italic = null;
        }
        boolean bl5 = (n & 1) != 0;
        boolean bl6 = bl = (n2 & 1) != 0;
        if (bl5 && !bl) {
            nbFont.bold = Boolean.TRUE;
        }
        if (!bl5 && bl) {
            nbFont.bold = Boolean.FALSE;
        }
        if (nbFont.bold != null && bl5 == bl && bl5 != nbFont.bold) {
            nbFont.bold = null;
        }
        this.setValue(nbFont);
    }

    private void convertToAbsolute() {
        Object object = this.getUnwrappedValue();
        if (object instanceof NbFont) {
            this.setValue(((NbFont)object).getDesignValue());
        }
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_FONT_ROOT.equals(node.getNodeName())) {
            ((XMLPropertyEditor)this.delegateEditor).readFromXML(node);
            this.setValue(this.delegateEditor.getValue());
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        boolean bl = Boolean.valueOf(namedNodeMap.getNamedItem(ATTR_RELATIVE).getNodeValue());
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (bl) {
                Node node3;
                if (!XML_FONT.equals(node2.getNodeName())) {
                    throw new IOException();
                }
                NbFont nbFont = new NbFont();
                nbFont.property = this.property;
                namedNodeMap = node2.getAttributes();
                nbFont.absoluteSize = Boolean.valueOf(namedNodeMap.getNamedItem(ATTR_RELATIVE_SIZE).getNodeValue()) == false;
                nbFont.size = Integer.parseInt(namedNodeMap.getNamedItem(ATTR_SIZE).getNodeValue());
                Node node4 = namedNodeMap.getNamedItem(ATTR_ITALIC_CHANGE);
                if (node4 != null) {
                    nbFont.italic = Boolean.valueOf(node4.getNodeValue());
                }
                if ((node3 = namedNodeMap.getNamedItem(ATTR_BOLD_CHANGE)) != null) {
                    nbFont.bold = Boolean.valueOf(node3.getNodeValue());
                }
                this.setValue(nbFont);
                break;
            }
            ((XMLPropertyEditor)this.delegateEditor).readFromXML(node2);
            break;
        }
    }

    public Node storeToXML(Document document) {
        Object object = this.getUnwrappedValue();
        Element element = document.createElement(XML_FONT_ROOT);
        element.setAttribute(ATTR_RELATIVE, Boolean.TRUE.toString());
        if (!(object instanceof NbFont)) {
            Node node = ((XMLPropertyEditor)this.delegateEditor).storeToXML(document);
            element.appendChild(node);
        } else {
            NbFont nbFont = (NbFont)object;
            Element element2 = document.createElement(XML_FONT);
            element.appendChild(element2);
            element2.setAttribute(ATTR_RELATIVE_SIZE, Boolean.toString(!nbFont.absoluteSize));
            element2.setAttribute(ATTR_SIZE, Integer.toString(nbFont.size));
            if (nbFont.italic != null) {
                element2.setAttribute(ATTR_ITALIC_CHANGE, nbFont.italic.toString());
            }
            if (nbFont.bold != null) {
                element2.setAttribute(ATTR_BOLD_CHANGE, nbFont.bold.toString());
            }
            element2.setAttribute(ATTR_COMP_NAME, ((RADProperty)this.property).getRADComponent().getName());
            element2.setAttribute(ATTR_PROP_NAME, this.property.getName());
        }
        return element;
    }

    private class RelativeFontPanel
    extends JPanel {
        private JRadioButton absoluteChoice;
        private JSpinner absoluteSize;
        private JRadioButton addBoldChoice;
        private JRadioButton addItalicChoice;
        private JCheckBox italicCheckBox;
        private JRadioButton relativeChoice;
        private JSpinner relativeSize;
        private JRadioButton removeBoldChoice;
        private JRadioButton removeItalicChoice;
        private JCheckBox thicknessCheckBox;
        private boolean ignoreUpdates;

        RelativeFontPanel() {
            this.initComponents();
        }

        void updateFromPropertyValue() {
            NbFont nbFont = (NbFont)FontEditor.this.getUnwrappedValue();
            this.ignoreUpdates = true;
            boolean bl = nbFont.italic != null;
            this.italicCheckBox.setSelected(bl);
            this.addItalicChoice.setEnabled(bl);
            this.removeItalicChoice.setEnabled(bl);
            if (!bl) {
                this.addItalicChoice.setSelected(true);
            } else if (Boolean.TRUE.equals(nbFont.italic)) {
                this.addItalicChoice.setSelected(true);
            } else if (Boolean.FALSE.equals(nbFont.italic)) {
                this.removeItalicChoice.setSelected(true);
            }
            boolean bl2 = nbFont.bold != null;
            this.thicknessCheckBox.setSelected(bl2);
            this.addBoldChoice.setEnabled(bl2);
            this.removeBoldChoice.setEnabled(bl2);
            if (!bl2) {
                this.addBoldChoice.setSelected(true);
            } else if (Boolean.TRUE.equals(nbFont.bold)) {
                this.addBoldChoice.setSelected(true);
            } else if (Boolean.FALSE.equals(nbFont.bold)) {
                this.removeBoldChoice.setSelected(true);
            }
            this.absoluteSize.setEnabled(nbFont.absoluteSize);
            this.relativeSize.setEnabled(!nbFont.absoluteSize);
            if (nbFont.absoluteSize) {
                this.absoluteSize.setValue(new Integer(nbFont.size));
                this.absoluteChoice.setSelected(true);
                this.synchronizeSizeControls(nbFont);
            } else {
                this.relativeSize.setValue(new Integer(nbFont.size));
                this.relativeChoice.setSelected(true);
                this.synchronizeSizeControls(nbFont);
            }
            this.ignoreUpdates = false;
        }

        private void synchronizeSizeControls(NbFont nbFont) {
            if (nbFont.absoluteSize) {
                Font font = (Font)FontEditor.this.property.getDefaultValue();
                if (font != null) {
                    this.relativeSize.setValue(new Integer(nbFont.size - font.getSize()));
                }
            } else {
                Font font = (Font)nbFont.getDesignValue();
                this.absoluteSize.setValue(new Integer(font == null ? 12 : font.getSize()));
            }
        }

        private void initComponents() {
            this.relativeSize = new JSpinner(new SpinnerNumberModel(0, Short.MIN_VALUE, Short.MAX_VALUE, 1));
            this.relativeSize.setEditor(new JSpinner.NumberEditor(this.relativeSize, "+#;-#"));
            this.absoluteSize = new JSpinner(new SpinnerNumberModel(12, 1, Short.MAX_VALUE, 1));
            ResourceBundle resourceBundle = NbBundle.getBundle(FontEditor.class);
            JLabel jLabel = new JLabel(resourceBundle.getString("CTL_FontSize"));
            JLabel jLabel2 = new JLabel(resourceBundle.getString("CTL_FontStyle"));
            this.absoluteChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.absoluteChoice, (String)resourceBundle.getString("CTL_AbsoluteFontSize"));
            this.relativeChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.relativeChoice, (String)resourceBundle.getString("CTL_RelativeFontSize"));
            this.italicCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.italicCheckBox, (String)resourceBundle.getString("CTL_ChangeItalic"));
            this.addItalicChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addItalicChoice, (String)resourceBundle.getString("CTL_AddItalic"));
            this.removeItalicChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.removeItalicChoice, (String)resourceBundle.getString("CTL_RemoveItalic"));
            this.thicknessCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.thicknessCheckBox, (String)resourceBundle.getString("CTL_ChangeBold"));
            this.addBoldChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addBoldChoice, (String)resourceBundle.getString("CTL_AddBold"));
            this.removeBoldChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.removeBoldChoice, (String)resourceBundle.getString("CTL_RemoveBold"));
            Listener listener = new Listener();
            this.relativeChoice.addItemListener(listener);
            this.thicknessCheckBox.addItemListener(listener);
            this.italicCheckBox.addItemListener(listener);
            this.relativeSize.addChangeListener(listener);
            this.absoluteSize.addChangeListener(listener);
            this.addItalicChoice.addItemListener(listener);
            this.addBoldChoice.addItemListener(listener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.addItalicChoice);
            buttonGroup.add(this.removeItalicChoice);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.addBoldChoice);
            buttonGroup2.add(this.removeBoldChoice);
            ButtonGroup buttonGroup3 = new ButtonGroup();
            buttonGroup3.add(this.absoluteChoice);
            buttonGroup3.add(this.relativeChoice);
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            Insets insets = new Insets(0, 0, 0, 0);
            this.absoluteChoice.setBorder(border);
            this.absoluteChoice.setMargin(insets);
            this.relativeChoice.setBorder(border);
            this.relativeChoice.setMargin(insets);
            this.italicCheckBox.setBorder(border);
            this.italicCheckBox.setMargin(insets);
            this.addItalicChoice.setBorder(border);
            this.addItalicChoice.setMargin(insets);
            this.removeItalicChoice.setBorder(border);
            this.removeItalicChoice.setMargin(insets);
            this.thicknessCheckBox.setBorder(border);
            this.thicknessCheckBox.setMargin(insets);
            this.addBoldChoice.setBorder(border);
            this.addBoldChoice.setMargin(insets);
            this.removeBoldChoice.setBorder(border);
            this.removeBoldChoice.setMargin(insets);
            GroupLayout groupLayout = new GroupLayout((Container)this);
            this.setLayout((LayoutManager)groupLayout);
            groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.relativeChoice).add((Component)this.absoluteChoice)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.relativeSize, -2, 50, -2).add((Component)this.absoluteSize, -2, 50, -2)))).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jLabel2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.italicCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.addItalicChoice).add((Component)this.removeItalicChoice)))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.thicknessCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.removeBoldChoice).add((Component)this.addBoldChoice)))))).addContainerGap());
            groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.relativeChoice).add((Component)this.relativeSize, -2, -1, -2).add((Component)this.italicCheckBox).add((Component)this.thicknessCheckBox)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.absoluteChoice).add((Component)this.absoluteSize, -2, -1, -2).add((Component)this.addItalicChoice).add((Component)this.addBoldChoice)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.removeItalicChoice).add((Component)this.removeBoldChoice)).addContainerGap(260, 260));
        }

        private class Listener
        implements ItemListener,
        ChangeListener {
            private Listener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (RelativeFontPanel.this.ignoreUpdates) {
                    return;
                }
                RelativeFontPanel.this.ignoreUpdates = true;
                NbFont nbFont = ((NbFont)FontEditor.this.getUnwrappedValue()).copy();
                Object object = itemEvent.getSource();
                if (object == RelativeFontPanel.this.relativeChoice) {
                    boolean bl = RelativeFontPanel.this.relativeChoice.isSelected();
                    RelativeFontPanel.this.relativeSize.setEnabled(bl);
                    RelativeFontPanel.this.absoluteSize.setEnabled(!bl);
                    nbFont.absoluteSize = !bl;
                    nbFont.size = ((Number)(bl ? RelativeFontPanel.this.relativeSize : RelativeFontPanel.this.absoluteSize).getValue()).intValue();
                } else if (object == RelativeFontPanel.this.italicCheckBox) {
                    boolean bl = RelativeFontPanel.this.italicCheckBox.isSelected();
                    RelativeFontPanel.this.addItalicChoice.setEnabled(bl);
                    RelativeFontPanel.this.removeItalicChoice.setEnabled(bl);
                    nbFont.italic = bl ? Boolean.valueOf(RelativeFontPanel.this.addItalicChoice.isSelected()) : null;
                } else if (object == RelativeFontPanel.this.thicknessCheckBox) {
                    boolean bl = RelativeFontPanel.this.thicknessCheckBox.isSelected();
                    RelativeFontPanel.this.addBoldChoice.setEnabled(bl);
                    RelativeFontPanel.this.removeBoldChoice.setEnabled(bl);
                    nbFont.bold = bl ? Boolean.valueOf(RelativeFontPanel.this.addBoldChoice.isSelected()) : null;
                } else if (object == RelativeFontPanel.this.addBoldChoice) {
                    nbFont.bold = RelativeFontPanel.this.addBoldChoice.isSelected();
                } else if (object == RelativeFontPanel.this.addItalicChoice) {
                    nbFont.italic = RelativeFontPanel.this.addItalicChoice.isSelected();
                }
                RelativeFontPanel.this.ignoreUpdates = false;
                FontEditor.this.setValue(nbFont);
            }

            public void stateChanged(ChangeEvent changeEvent) {
                if (RelativeFontPanel.this.ignoreUpdates) {
                    return;
                }
                RelativeFontPanel.this.ignoreUpdates = true;
                NbFont nbFont = ((NbFont)FontEditor.this.getUnwrappedValue()).copy();
                Object object = changeEvent.getSource();
                if (object == RelativeFontPanel.this.relativeSize) {
                    nbFont.size = ((Number)RelativeFontPanel.this.relativeSize.getValue()).intValue();
                    RelativeFontPanel.this.synchronizeSizeControls(nbFont);
                } else if (object == RelativeFontPanel.this.absoluteSize) {
                    nbFont.size = ((Number)RelativeFontPanel.this.absoluteSize.getValue()).intValue();
                    RelativeFontPanel.this.synchronizeSizeControls(nbFont);
                }
                RelativeFontPanel.this.ignoreUpdates = false;
                FontEditor.this.setValue(nbFont);
            }
        }
    }

    static class NbFont
    extends FormDesignValueAdapter {
        Boolean italic;
        Boolean bold;
        boolean absoluteSize;
        int size;
        FormProperty property;

        NbFont() {
        }

        public Object getDesignValue() {
            Font font = this.defaultValue(this.property);
            if (font != null) {
                int n;
                int n2;
                int n3 = n2 = font.getStyle();
                if (this.italic != null) {
                    n3 = this.italic.booleanValue() ? (n3 |= 2) : (n3 &= 0xFFFFFFFD);
                }
                if (this.bold != null) {
                    n3 = this.bold.booleanValue() ? (n3 |= 1) : (n3 &= 0xFFFFFFFE);
                }
                int n4 = font.getSize();
                int n5 = n = this.absoluteSize ? this.size : this.size + n4;
                if (n3 != n2 || n4 != n) {
                    font = font.deriveFont(n3, n);
                }
            }
            return font;
        }

        private Font defaultValue(FormProperty formProperty) {
            RADProperty rADProperty;
            PropertyDescriptor propertyDescriptor;
            Method method;
            if (formProperty instanceof RADProperty && FormLAF.getUsePreviewDefaults() && (method = (propertyDescriptor = (rADProperty = (RADProperty)formProperty).getPropertyDescriptor()).getReadMethod()) != null) {
                try {
                    Class<? extends Object> clazz = rADProperty.getRADComponent().getBeanClass();
                    Object object = BeanSupport.createBeanInstance(clazz);
                    return (Font)method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (Font)formProperty.getDefaultValue();
        }

        public String getDescription() {
            ResourceBundle resourceBundle = NbBundle.getBundle(FontEditor.class);
            String string = Integer.toString(this.size);
            if (!this.absoluteSize && this.size > 0) {
                string = '+' + string;
            }
            if (this.italic != null) {
                string = string + " " + (this.italic != false ? (char)'+' : '-') + resourceBundle.getString("CTL_FontStyleItalic");
            }
            if (this.bold != null) {
                string = string + " " + (this.bold != false ? (char)'+' : '-') + resourceBundle.getString("CTL_FontStyleBold");
            }
            if (string.charAt(0) == '0') {
                string = string.substring(Math.min(2, string.length()));
            }
            return string;
        }

        public FormDesignValue copy(FormProperty formProperty) {
            NbFont nbFont = this.copy();
            nbFont.property = formProperty;
            return nbFont;
        }

        NbFont copy() {
            NbFont nbFont = new NbFont();
            nbFont.italic = this.italic;
            nbFont.bold = this.bold;
            nbFont.absoluteSize = this.absoluteSize;
            nbFont.size = this.size;
            nbFont.property = this.property;
            return nbFont;
        }
    }
}

