/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassPathFileChooser
extends JPanel
implements ExplorerManager.Provider {
    private boolean choosingFolder;
    private ExplorerManager explorerManager;
    private List<FileObject> packageRoots;
    private FileObject selectedFile;
    private FileObject selectedFolder;
    private boolean confirmed;
    private BeanTreeView treeView;
    private JButton newButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField fileNameTextField;
    public static final String PROP_SELECTED_FILE = "selectedFile";

    public ClassPathFileChooser(FileObject fileObject, Filter filter, boolean bl, boolean bl2) {
        this.choosingFolder = bl;
        Listener listener = new Listener();
        Node node = this.getRootNode(fileObject, filter);
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext(node);
        try {
            this.explorerManager.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
        }
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)listener);
        if (bl) {
            this.newButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_CreateNewButton"));
            this.newButton.addActionListener(listener);
            this.newButton.setEnabled(false);
            this.newButton.setToolTipText(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_CreateNewButtonHint"));
        }
        if (bl2) {
            this.okButton = new JButton(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_OKButton"));
            this.okButton.addActionListener(listener);
            this.okButton.setEnabled(false);
            this.cancelButton = new JButton(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_CancelButton"));
        }
        this.treeView = new BeanTreeView();
        this.treeView.setPopupAllowed(false);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClassPathFileChooser.class, (String)"ACSN_FileSelectorTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClassPathFileChooser.class, (String)"ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClassPathFileChooser.class, (String)"ACSD_FileSelectorPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(ClassPathFileChooser.class, (String)(bl ? "LBL_FolderName" : "LBL_FileName")));
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.getDocument().addDocumentListener(listener);
        this.fileNameTextField.addActionListener(listener);
        jLabel.setLabelFor(this.fileNameTextField);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutocreateGaps(true);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup().add((Component)jLabel).add((Component)this.fileNameTextField);
        if (!bl2 && this.newButton != null) {
            sequentialGroup.add((Component)this.newButton);
        }
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.treeView, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)sequentialGroup));
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.fileNameTextField);
        if (!bl2 && this.newButton != null) {
            parallelGroup.add((Component)this.newButton);
        }
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.treeView, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)parallelGroup));
    }

    public Dialog getDialog(String string, ActionListener actionListener) {
        Object[] objectArray;
        if (this.okButton == null) {
            throw new IllegalStateException("Can't create dialog for a chooser without OK and Cancel buttons.");
        }
        ((GroupLayout)this.getLayout()).setAutocreateContainerGaps(true);
        if (this.newButton != null) {
            JButton[] jButtonArray = new JButton[3];
            jButtonArray[0] = this.newButton;
            jButtonArray[1] = this.okButton;
            objectArray = jButtonArray;
            jButtonArray[2] = this.cancelButton;
        } else {
            Object[] objectArray2 = new JButton[2];
            objectArray2[0] = this.okButton;
            objectArray = objectArray2;
            objectArray2[1] = this.cancelButton;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string, true, objectArray, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, null);
        dialogDescriptor.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
        if (actionListener != null) {
            this.okButton.addActionListener(actionListener);
        }
        return DialogDisplayer.getDefault().createDialog(dialogDescriptor);
    }

    public void addNotify() {
        this.confirmed = false;
        super.addNotify();
        this.treeView.requestFocusInWindow();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public FileObject getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(FileObject fileObject) {
        if (fileObject != null) {
            if (this.getRoot(fileObject) == null) {
                throw new IllegalArgumentException("File not within the classpath.");
            }
            this.selectFileNode(fileObject);
        }
        this.selectedFile = fileObject;
    }

    public FileObject getSelectedPackageRoot() {
        return this.getRoot(this.getSelectedFile());
    }

    private void checkNameField() {
        if (this.selectedFolder != null) {
            FileObject fileObject;
            this.selectedFile = null;
            String string = this.fileNameTextField.getText();
            Node[] nodeArray = this.explorerManager.getSelectedNodes();
            if (nodeArray.length == 1 && (fileObject = ClassPathFileChooser.fileFromNode(nodeArray[0])) != null) {
                if (!fileObject.isFolder()) {
                    fileObject = fileObject.getParent();
                }
                this.selectedFile = fileObject.getFileObject(string);
                this.selectedFolder = fileObject;
            }
            if (this.okButton != null) {
                this.okButton.setEnabled(this.selectedFile != null && (!this.selectedFile.isFolder() || this.choosingFolder));
            }
            if (this.newButton != null) {
                this.newButton.setEnabled(this.selectedFile == null && this.choosingFolder && Utilities.isJavaIdentifier((String)string));
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private static FileObject fileFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    private void selectFileNode(FileObject fileObject) {
        this.selectNode(this.explorerManager.getRootContext(), fileObject);
    }

    private void selectNode(Node node, FileObject fileObject) {
        for (Node node2 : node.getChildren().getNodes(true)) {
            FileObject fileObject2 = ClassPathFileChooser.fileFromNode(node2);
            if (fileObject2 == fileObject) {
                try {
                    this.explorerManager.setSelectedNodes(new Node[]{node2});
                }
                catch (PropertyVetoException propertyVetoException) {
                    ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
                }
                break;
            }
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            this.selectNode(node2, fileObject);
            break;
        }
    }

    private FileObject getRoot(FileObject fileObject) {
        if (fileObject != null) {
            for (FileObject fileObject2 : this.packageRoots) {
                if (fileObject2 != fileObject && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                return fileObject2;
            }
        }
        return null;
    }

    private Node getRootNode(FileObject fileObject, Filter filter) {
        Children.Array array = new Children.Array();
        array.add(this.createPackageRootNodes(fileObject, this.choosingFolder, filter));
        AbstractNode abstractNode = new AbstractNode((Children)array);
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/form/editors2/iconResourceRoot.gif");
        abstractNode.setDisplayName(NbBundle.getMessage(ClassPathFileChooser.class, (String)"CTL_ClassPathName"));
        return abstractNode;
    }

    private Node[] createPackageRootNodes(FileObject fileObject, boolean bl, Filter filter) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (classPath == null || project == null) {
            return new Node[0];
        }
        this.packageRoots = new LinkedList<FileObject>();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (ClassPath.Entry entry : classPath.entries()) {
            Node node;
            FileObject fileObject2;
            ClassPath.Entry entry2 = entry;
            URL uRL = entry2.getURL();
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
            FileObject fileObject3 = result.getRoots();
            if (((FileObject[])fileObject3).length > 0) {
                fileObject2 = fileObject3;
                int n = ((FileObject[])fileObject2).length;
                for (int i = 0; i < n; ++i) {
                    Node node2;
                    FileObject fileObject4 = fileObject2[i];
                    if (bl && !fileObject4.canWrite() || (node2 = ClassPathFileChooser.createPackageRootNode(fileObject4, project, filter)) == null) continue;
                    this.packageRoots.add(fileObject4);
                    linkedList.add(node2);
                }
                continue;
            }
            if (bl || (node = ClassPathFileChooser.createPackageRootNode(fileObject2 = entry2.getRoot(), project, filter)) == null) continue;
            this.packageRoots.add(fileObject2);
            linkedList.add(node);
        }
        Node[] nodeArray = new Node[linkedList.size()];
        linkedList.toArray(nodeArray);
        return nodeArray;
    }

    private static Node createPackageRootNode(FileObject fileObject, Project project, Filter filter) {
        String string;
        Node node;
        try {
            node = DataObject.find((FileObject)fileObject).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project2 != null) {
            SourceGroup sourceGroup = ClassPathFileChooser.getSourceGroup(fileObject, project2);
            String string2 = string = sourceGroup != null ? sourceGroup.getDisplayName() : FileUtil.getFileDisplayName((FileObject)fileObject);
            if (project != project2) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project2);
                string = string + " [" + projectInformation.getDisplayName() + "]";
            }
        } else {
            string = FileUtil.getFileDisplayName((FileObject)fileObject);
        }
        return new FilteredNode(node, string, filter);
    }

    private static SourceGroup getSourceGroup(FileObject fileObject, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sources.getSourceGroups("java")) {
            if (fileObject != sourceGroup.getRootFolder()) continue;
            return sourceGroup;
        }
        return null;
    }

    public static class FilteredChildren
    extends FilterNode.Children {
        private Filter filter;

        public FilteredChildren(Node node, Filter filter) {
            super(node);
            this.filter = filter;
        }

        protected Node copyNode(Node node) {
            return this.filter != null ? new FilteredNode(node, null, this.filter) : super.copyNode(node);
        }

        protected Node[] createNodes(Node node) {
            FileObject fileObject;
            if (!(this.filter == null || (fileObject = ClassPathFileChooser.fileFromNode(node)) != null && this.filter.accept(fileObject))) {
                return new Node[0];
            }
            return super.createNodes(node);
        }
    }

    private static class FilteredNode
    extends FilterNode {
        FilteredNode(Node node, String string, Filter filter) {
            super(node, (Children)new FilteredChildren(node, filter));
            if (string != null) {
                this.disableDelegation(12);
                this.setDisplayName(string);
            }
        }
    }

    private class Listener
    implements PropertyChangeListener,
    ActionListener,
    DocumentListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ClassPathFileChooser.this.okButton) {
                ClassPathFileChooser.this.confirmed = true;
            } else if (actionEvent.getSource() == ClassPathFileChooser.this.newButton) {
                if (ClassPathFileChooser.this.selectedFolder == null || ClassPathFileChooser.this.selectedFile != null) {
                    return;
                }
                String string = ClassPathFileChooser.this.fileNameTextField.getText();
                try {
                    ClassPathFileChooser.this.selectedFile = ClassPathFileChooser.this.selectedFolder.createFolder(string);
                    ClassPathFileChooser.this.selectFileNode(ClassPathFileChooser.this.selectedFile);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (ClassPathFileChooser.this.choosingFolder && ClassPathFileChooser.this.selectedFile != null) {
                    ClassPathFileChooser.this.firePropertyChange(ClassPathFileChooser.PROP_SELECTED_FILE, null, ClassPathFileChooser.this.selectedFile);
                }
            } else if (actionEvent.getSource() == ClassPathFileChooser.this.fileNameTextField) {
                Object object;
                if (ClassPathFileChooser.this.selectedFile == null) {
                    object = ClassPathFileChooser.this.fileNameTextField.getText();
                    if (object.startsWith("/")) {
                        object = object.substring(1);
                    }
                    for (FileObject fileObject : ClassPathFileChooser.this.packageRoots) {
                        FileObject fileObject2 = fileObject.getFileObject((String)object);
                        if (fileObject2 == null) continue;
                        ClassPathFileChooser.this.selectedFile = fileObject2;
                        ClassPathFileChooser.this.selectedFolder = fileObject2.getParent();
                        break;
                    }
                }
                if (ClassPathFileChooser.this.selectedFile != null) {
                    object = ClassPathFileChooser.this.explorerManager.getSelectedNodes();
                    if (((Node[])object).length != 1 || ClassPathFileChooser.fileFromNode(object[0]) != ClassPathFileChooser.this.selectedFile) {
                        ClassPathFileChooser.this.selectFileNode(ClassPathFileChooser.this.selectedFile);
                        ClassPathFileChooser.this.treeView.requestFocus();
                    } else if (ClassPathFileChooser.this.okButton != null) {
                        ClassPathFileChooser.this.okButton.doClick();
                        return;
                    }
                    if (ClassPathFileChooser.this.okButton != null) {
                        ClassPathFileChooser.this.okButton.setEnabled(ClassPathFileChooser.this.selectedFile != null && (!ClassPathFileChooser.this.selectedFile.isFolder() || ClassPathFileChooser.this.choosingFolder));
                    }
                    if (ClassPathFileChooser.this.newButton != null) {
                        ClassPathFileChooser.this.newButton.setEnabled(false);
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                FileObject fileObject;
                Node[] nodeArray = ClassPathFileChooser.this.explorerManager.getSelectedNodes();
                FileObject fileObject2 = ClassPathFileChooser.this.selectedFile;
                ClassPathFileChooser.this.selectedFile = null;
                ClassPathFileChooser.this.selectedFolder = null;
                if (nodeArray.length == 1 && (fileObject = ClassPathFileChooser.fileFromNode(nodeArray[0])) != null) {
                    ClassPathFileChooser.this.fileNameTextField.setText(!fileObject.isFolder() || ClassPathFileChooser.this.choosingFolder ? fileObject.getNameExt() : "");
                    ClassPathFileChooser.this.selectedFile = fileObject;
                    ClassPathFileChooser.this.selectedFolder = fileObject.getParent();
                }
                if (ClassPathFileChooser.this.okButton != null) {
                    ClassPathFileChooser.this.okButton.setEnabled(ClassPathFileChooser.this.selectedFile != null && (!ClassPathFileChooser.this.selectedFile.isFolder() || ClassPathFileChooser.this.choosingFolder));
                }
                if (ClassPathFileChooser.this.newButton != null) {
                    ClassPathFileChooser.this.newButton.setEnabled(false);
                }
                ClassPathFileChooser.this.firePropertyChange(ClassPathFileChooser.PROP_SELECTED_FILE, fileObject2, ClassPathFileChooser.this.selectedFile);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ClassPathFileChooser.this.checkNameField();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ClassPathFileChooser.this.checkNameField();
        }
    }

    public static interface Filter {
        public boolean accept(FileObject var1);
    }
}

