/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;

public class TestAction
extends CallableSystemAction
implements Runnable {
    private static String name;
    private Map<String, Map<String, Frame>> previews = new HashMap<String, Map<String, Frame>>();
    private FormDesigner formDesigner;
    private Class selectedLaf;

    public TestAction() {
        this.setEnabled(false);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(TestAction.class).getString("ACT_TestMode");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.testing");
    }

    protected String iconResource() {
        return "org/netbeans/modules/form/resources/test_form.png";
    }

    public void performAction() {
        if (this.formDesigner != null) {
            this.selectedLaf = null;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }
    }

    public void run() {
        RADVisualComponent rADVisualComponent = this.formDesigner.getTopDesignComponent();
        if (rADVisualComponent == null) {
            return;
        }
        RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
        while (rADVisualContainer != null) {
            rADVisualComponent = rADVisualContainer;
            rADVisualContainer = rADVisualComponent.getParentContainer();
        }
        FormModel formModel = this.formDesigner.getFormModel();
        RADVisualFormContainer rADVisualFormContainer = rADVisualComponent instanceof RADVisualFormContainer ? (RADVisualFormContainer)rADVisualComponent : null;
        try {
            Frame frame;
            FileObject fileObject;
            Map<String, Frame> map;
            if (this.selectedLaf == null) {
                this.selectedLaf = UIManager.getLookAndFeel().getClass();
            }
            if ((map = this.previews.get((fileObject = FormEditor.getFormDataObject(formModel).getFormFile()).getPath())) == null) {
                map = new HashMap<String, Frame>();
                this.previews.put(fileObject.getPath(), map);
            }
            if ((frame = map.get(this.selectedLaf.getName())) != null) {
                frame.dispose();
            }
            final ClassLoader classLoader = ClassPathUtils.getProjectClassLoader(fileObject);
            final FormLAF.PreviewInfo previewInfo = FormLAF.initPreviewLaf(this.selectedLaf, classLoader);
            final Frame frame2 = (Frame)FormDesigner.createFormView(rADVisualComponent, previewInfo);
            frame2.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    frame2.dispose();
                }
            });
            map.put(this.selectedLaf.getName(), frame2);
            String string = frame2.getTitle();
            if (string == null || "".equals(string)) {
                string = rADVisualComponent == formModel.getTopRADComponent() ? formModel.getName() : rADVisualComponent.getName();
                frame2.setTitle(MessageFormat.format(NbBundle.getBundle(TestAction.class).getString("FMT_TestingForm"), string));
            }
            if (frame2 instanceof JFrame) {
                ((JFrame)frame2).setDefaultCloseOperation(2);
                HelpCtx.setHelpIDString((JComponent)((JFrame)frame2).getRootPane(), (String)"gui.modes");
            } else {
                frame2.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        frame2.dispose();
                    }
                });
            }
            boolean bl = false;
            if (rADVisualFormContainer != null && rADVisualFormContainer.getFormSizePolicy() == 0 && rADVisualFormContainer.getGenerateSize()) {
                Dimension dimension = rADVisualFormContainer.getFormSize();
                if (frame2.isUndecorated()) {
                    Dimension dimension2 = RADVisualFormContainer.getDecoratedWindowContentDimensionDiff();
                    dimension = new Dimension(dimension.width + dimension2.width, dimension.height + dimension2.height);
                }
                frame2.setSize(dimension);
            } else {
                bl = true;
            }
            frame2.setUndecorated(false);
            frame2.setFocusableWindowState(true);
            final boolean bl2 = bl;
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (bl2) {
                        try {
                            FormLAF.setUsePreviewDefaults(classLoader, previewInfo);
                            frame2.pack();
                        }
                        finally {
                            FormLAF.setUsePreviewDefaults(null, null);
                        }
                    }
                    frame2.setBounds(Utilities.findCenterBounds((Dimension)frame2.getSize()));
                    frame2.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        LAFMenu lAFMenu = new LAFMenu(this.getName());
        lAFMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)lAFMenu, (String)SelectLayoutAction.class.getName());
        return lAFMenu;
    }

    public void setFormDesigner(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.setEnabled(this.formDesigner != null && this.formDesigner.getTopDesignComponent() != null);
    }

    static class LookAndFeelItem {
        private String className;
        private PaletteItem pitem;

        public LookAndFeelItem(String string) {
            this.className = string;
        }

        public LookAndFeelItem(PaletteItem paletteItem) {
            this.pitem = paletteItem;
            this.className = paletteItem.getComponentClassName();
        }

        public String getClassName() {
            return this.className;
        }

        public Class getLAFClass() throws ClassNotFoundException {
            Class<?> clazz = this.pitem == null ? (this.className == null ? UIManager.getLookAndFeel().getClass() : Class.forName(this.className)) : this.pitem.getComponentClass();
            return clazz;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LookAndFeelItem)) {
                return false;
            }
            LookAndFeelItem lookAndFeelItem = (LookAndFeelItem)object;
            return this.pitem == lookAndFeelItem.pitem && (this.pitem != null || (this.className == null ? lookAndFeelItem.className == null : this.className.equals(lookAndFeelItem.className)));
        }

        public int hashCode() {
            return this.className == null ? this.pitem.hashCode() : this.className.hashCode();
        }
    }

    private class LAFMenu
    extends JMenu
    implements ActionListener {
        private boolean initialized;

        private LAFMenu(String string) {
            super(string);
            this.initialized = false;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu jPopupMenu = super.getPopupMenu();
            if (!this.initialized) {
                JMenuItem jMenuItem;
                Node node;
                jPopupMenu.removeAll();
                boolean bl = UIManager.getLookAndFeel() instanceof SynthLookAndFeel;
                String string = UIManager.getLookAndFeel().getClass().getName();
                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                    String string2 = lookAndFeelInfoArray[i].getClassName();
                    if (bl) {
                        try {
                            node = Class.forName(string2);
                            if (!string.equals(string2) && SynthLookAndFeel.class.isAssignableFrom((Class<?>)node)) {
                                continue;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                        }
                    }
                    jMenuItem = new JMenuItem(lookAndFeelInfoArray[i].getName());
                    jMenuItem.putClientProperty("lafInfo", new LookAndFeelItem(lookAndFeelInfoArray[i].getClassName()));
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
                Node[] nodeArray = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false);
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (!"LookAndFeels".equals(nodeArray[i].getName())) continue;
                    node = nodeArray[i];
                    Node[] nodeArray2 = PaletteUtils.getItemNodes(node, true);
                    if (nodeArray2.length != 0) {
                        jPopupMenu.add(new JSeparator());
                    }
                    for (int j = 0; j < nodeArray2.length; ++j) {
                        PaletteItem paletteItem = (PaletteItem)nodeArray2[j].getLookup().lookup(PaletteItem.class);
                        boolean bl2 = false;
                        try {
                            LookAndFeel lookAndFeel;
                            Class clazz = paletteItem.getComponentClass();
                            if (clazz != null && LookAndFeel.class.isAssignableFrom(clazz) && (bl2 = (lookAndFeel = (LookAndFeel)clazz.newInstance()).isSupportedLookAndFeel()) && bl && !string.equals(paletteItem.getComponentClassName()) && SynthLookAndFeel.class.isAssignableFrom(clazz)) {
                                bl2 = false;
                            }
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify(1, (Throwable)exception);
                        }
                        catch (LinkageError linkageError) {
                            ErrorManager.getDefault().notify(1, (Throwable)linkageError);
                        }
                        if (!bl2) continue;
                        jMenuItem = new JMenuItem(nodeArray2[j].getDisplayName());
                        jMenuItem.putClientProperty("lafInfo", new LookAndFeelItem(paletteItem));
                        jMenuItem.addActionListener(this);
                        jPopupMenu.add(jMenuItem);
                    }
                }
                this.initialized = true;
            }
            return jPopupMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                LookAndFeelItem lookAndFeelItem = (LookAndFeelItem)jComponent.getClientProperty("lafInfo");
                try {
                    TestAction.this.selectedLaf = lookAndFeelItem.getLAFClass();
                    TestAction.this.run();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        }
    }
}

