/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.debugger.registry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DebuggerServiceRegistration;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(ActionsProvider.Registration.class.getCanonicalName(), DebuggerEngineProvider.Registration.class.getCanonicalName(), SessionProvider.Registration.class.getCanonicalName(), LazyActionsManagerListener.Registration.class.getCanonicalName(), DebuggerServiceRegistration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        String string;
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        int n = 0;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionsProvider.Registration.class)) {
            annotation = element.getAnnotation(ActionsProvider.Registration.class);
            string = annotation.path();
            this.handleProviderRegistrationInner(element, ActionsProvider.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LazyActionsManagerListener.Registration.class)) {
            annotation = element.getAnnotation(LazyActionsManagerListener.Registration.class);
            string = annotation.path();
            this.handleProviderRegistrationInner(element, LazyActionsManagerListener.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(DebuggerEngineProvider.Registration.class)) {
            annotation = element.getAnnotation(DebuggerEngineProvider.Registration.class);
            string = annotation.path();
            this.handleProviderRegistrationInner(element, DebuggerEngineProvider.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(SessionProvider.Registration.class)) {
            annotation = element.getAnnotation(SessionProvider.Registration.class);
            string = annotation.path();
            this.handleProviderRegistrationInner(element, SessionProvider.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(DebuggerServiceRegistration.class)) {
            annotation = element.getAnnotation(DebuggerServiceRegistration.class);
            string = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(DebuggerServiceRegistration.class.getName())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (ExecutableElement executableElement : map.keySet()) {
                    if (!executableElement.getSimpleName().contentEquals("types")) continue;
                    string = map.get(executableElement).getValue().toString();
                }
            }
            if (!this.implementsInterfaces(element, string = this.translateClassNames(string))) {
                throw new IllegalArgumentException("Annotated element " + element + " does not implement all interfaces " + string);
            }
            Object object = annotation.path();
            object = object != null && ((String)object).length() > 0 ? "Debugger/" + (String)object : "Debugger";
            this.layer(new Element[]{element}).instanceFile((String)object, null, null).stringvalue("serviceName", this.instantiableClassOrMethod(element)).stringvalue("instanceOf", string).methodvalue("instanceCreate", "org.netbeans.spi.debugger.ContextAwareSupport", "createService").write();
            ++n;
        }
        return n == set.size();
    }

    private void handleProviderRegistrationInner(Element element, Class clazz, String string) throws IllegalArgumentException, LayerGenerationException {
        String string2 = this.instantiableClassOrMethod(element);
        if (!this.isClassOf(element, clazz)) {
            throw new IllegalArgumentException("Annotated element " + element + " is not an instance of " + clazz);
        }
        string = string != null && string.length() > 0 ? "Debugger/" + string : "Debugger";
        this.layer(new Element[]{element}).instanceFile(string, null, clazz).stringvalue("serviceName", string2).stringvalue("serviceClass", clazz.getName()).stringvalue("instanceOf", clazz.getName()).methodvalue("instanceCreate", clazz.getName() + "$ContextAware", "createService").write();
    }

    private boolean isClassOf(Element element, Class clazz) {
        switch (element.getKind()) {
            case CLASS: {
                TypeElement typeElement = (TypeElement)element;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
            case METHOD: {
                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }

    private boolean implementsInterfaces(Element element, String string) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string.split("[, ]+")));
        return this.implementsInterfaces(element, hashSet);
    }

    private boolean implementsInterfaces(Element element, Set<String> set) {
        switch (element.getKind()) {
            case CLASS: 
            case INTERFACE: {
                TypeElement typeElement = (TypeElement)element;
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                for (TypeMirror typeMirror : list) {
                    element = ((DeclaredType)typeMirror).asElement();
                    String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                    boolean bl = set.remove(string);
                    if (bl) continue;
                    this.implementsInterfaces(element, set);
                }
                break;
            }
            case METHOD: {
                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                for (TypeMirror typeMirror2 : list) {
                    element = ((DeclaredType)typeMirror2).asElement();
                    String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                    set.remove(string);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
            }
        }
        return set.isEmpty();
    }

    private String instantiableClassOrMethod(Element element) throws IllegalArgumentException, LayerGenerationException {
        switch (element.getKind()) {
            case CLASS: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string + " must not be abstract", element);
                }
                boolean bl = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new LayerGenerationException(string + " must have a no-argument constructor", element);
                }
                return string;
            }
            case METHOD: {
                ExecutableElement executableElement = (ExecutableElement)element;
                String string = executableElement.getSimpleName().toString();
                String string2 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)executableElement.getEnclosingElement()).toString();
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(executableElement + " must be static", element);
                }
                if (executableElement.getParameters().size() > 0) {
                    throw new LayerGenerationException(executableElement + " must not have any parameters", element);
                }
                return string2 + "." + string + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }

    private String translateClassNames(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = string.indexOf(44, n2)) > 0) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.translateClass(string.substring(n2, n).trim()));
            n2 = n + 1;
        }
        if (n2 > 0) {
            stringBuilder.append(',');
        }
        stringBuilder.append(this.translateClass(string.substring(n2).trim()));
        return stringBuilder.toString();
    }

    private String translateClass(String string) {
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - ".class".length());
        }
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(string);
        return this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
    }
}

