/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.cnd.debugger.common.utils.ContextBindingSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatchPanel.this.editorPane.setText(WatchPanel.this.expression);
                WatchPanel.this.editorPane.selectAll();
            }
        };
        ContextBindingSupport.getDefault().setupContext(this.editorPane, actionListener);
        JScrollPane jScrollPane = ContextBindingSupport.createScrollableLineEditor((JEditorPane)this.editorPane);
        FontMetrics fontMetrics = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int n = 2 * fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
        Insets insets = this.editorPane.getInsets();
        Insets insets2 = jScrollPane.getInsets();
        jScrollPane.setPreferredSize(new Dimension(30 * n, n + 2 + insets.bottom + insets.top + insets2.bottom + insets2.top));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", jScrollPane);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    private static final class Context {
        public final FileObject fileObject;
        public final int line;

        private Context(FileObject fileObject, int n) {
            this.fileObject = fileObject;
            this.line = n <= 0 ? 0 : n;
        }
    }
}

