/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessList;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbAttachPanel
extends JPanel
implements ProcessListReader {
    private ProcessList procList = null;
    private final AttachTableModel processModel = new AttachTableModel();
    private Controller controller = null;
    private static String lastFilterValue = "";
    private static boolean showAll = false;
    private boolean updateColumns = true;
    private JCheckBox allCheckBox;
    private JTextField filterField;
    private JLabel filterLabel;
    private JComboBox hostComboBox;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel procLabel;
    private JTable processTable;
    private JComboBox projectCB;
    private JLabel projectLabel;

    public GdbAttachPanel() {
        this.initComponents();
        this.postComponentsInit();
        this.updateProcessList(true);
    }

    private void postComponentsInit() {
        for (ServerRecord serverRecord : ServerList.getRecords()) {
            this.hostComboBox.addItem(serverRecord);
        }
        this.filterField.setText(lastFilterValue);
        this.allCheckBox.setSelected(showAll);
        GdbAttachPanel.fillProjectsCombo(this.projectCB);
        this.hostComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GdbAttachPanel.this.hostComboBoxItemStateChanged(itemEvent);
            }
        });
        this.filterField.getDocument().addDocumentListener(new AnyChangeDocumentListener(){

            public void documentChanged(DocumentEvent documentEvent) {
                GdbAttachPanel.this.filterTextChanged();
            }
        });
    }

    private ExecutionEnvironment getCurrentExecutionEnvironment() {
        return ((ServerRecord)this.hostComboBox.getSelectedItem()).getExecutionEnvironment();
    }

    private synchronized void filterTextChanged() {
        lastFilterValue = this.filterField.getText();
        this.updateProcessList(false);
    }

    private void setupColumns() {
        this.processModel.setColumnCount(0);
        for (AttachTableColumn attachTableColumn : this.procList.getColumnHeaders()) {
            this.processModel.addColumn(attachTableColumn);
        }
        int n = this.processTable.getColumnModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.processTable.getColumnModel().getColumn(i);
            if (tableColumn.getIdentifier() == null || !tableColumn.getIdentifier().equals(this.procList.getArgsHeader())) continue;
            tableColumn.setPreferredWidth(300);
            tableColumn.setMinWidth(75);
            break;
        }
    }

    public static void fillProjectsCombo(JComboBox jComboBox) {
        Project project = OpenProjects.getDefault().getMainProject();
        for (Project project2 : OpenProjects.getDefault().getOpenProjects()) {
            if (project2.getLookup().lookup(ConfigurationDescriptorProvider.class) == null) continue;
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project2);
            ProjectCBItem projectCBItem = new ProjectCBItem(projectInformation);
            jComboBox.addItem(projectCBItem);
            if (project == null || project2 != project) continue;
            jComboBox.setSelectedItem(projectCBItem);
        }
    }

    private void updateProcessList(boolean bl) {
        if (bl) {
            this.procList = new ProcessList(this.getCurrentExecutionEnvironment());
            this.updateColumns = true;
        }
        if (showAll) {
            this.procList.requestFull(this);
        } else {
            this.procList.requestSimple(this);
        }
    }

    Controller getController() {
        if (this.controller == null) {
            this.controller = new GdbAttachController();
        }
        return this.controller;
    }

    @Override
    public void processListCallback(List<String> list) {
        Pattern pattern = this.getFilterRE();
        final Vector<Vector<String>> vector = new Vector<Vector<String>>();
        for (String string : list) {
            Vector<String> vector2 = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken());
            }
            if (pattern != null && !pattern.matcher(string).find()) continue;
            Vector<String> vector3 = null;
            if (this.procList.isWindowsPsFound()) {
                vector3 = this.reorderWindowsProcLine(vector2);
            } else if (this.procList.isStd()) {
                vector3 = this.combineArgs(vector2);
            }
            if (vector3 == null) continue;
            vector.add(vector3);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GdbAttachPanel.this.updateColumns) {
                    GdbAttachPanel.this.setupColumns();
                    GdbAttachPanel.this.updateColumns = false;
                }
                GdbAttachPanel.this.processModel.setRowCount(0);
                for (Vector vector2 : vector) {
                    GdbAttachPanel.this.processModel.addRow(vector2);
                }
            }
        });
    }

    private Vector<String> reorderWindowsProcLine(Vector<String> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        Vector<String> vector2 = new Vector<String>(vector.size() - 2);
        String string = vector.get(0);
        if (string.length() == 1 && (string.equals("I") || string.equals("C") || string.equals("O"))) {
            int n;
            vector2.add(0, vector.get(6));
            vector2.add(1, vector.get(4));
            vector2.add(2, vector.get(1));
            vector2.add(3, vector.get(2));
            vector2.add(4, vector.get(7));
            String string2 = vector.get(7);
            if (Character.isDigit(string2.charAt(0))) {
                n = 8;
            } else {
                string2 = string2 + ' ' + vector.get(8);
                n = 9;
            }
            vector2.add(4, string2);
            while (n < vector.size()) {
                stringBuilder.append(vector.get(n++));
            }
        } else {
            int n;
            vector2.add(0, vector.get(5));
            vector2.add(1, vector.get(3));
            vector2.add(2, vector.get(0));
            vector2.add(3, vector.get(1));
            String string3 = vector.get(6);
            if (Character.isDigit(string3.charAt(0))) {
                n = 7;
            } else {
                string3 = string3 + ' ' + vector.get(7);
                n = 8;
            }
            vector2.add(4, string3);
            while (n < vector.size()) {
                stringBuilder.append(vector.get(n++));
            }
        }
        vector2.add(5, stringBuilder.toString());
        return vector2;
    }

    private Vector<String> combineArgs(Vector<String> vector) {
        Vector<String> vector2 = new Vector<String>(vector.size());
        vector2.add(0, vector.get(0));
        vector2.add(1, vector.get(1));
        vector2.add(2, vector.get(2));
        vector2.add(3, vector.get(3));
        vector2.add(4, vector.get(4));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 5; i < vector.size(); ++i) {
            stringBuilder.append(vector.get(i) + ' ');
        }
        vector2.add(5, stringBuilder.toString());
        return vector2;
    }

    private Pattern getFilterRE() {
        try {
            return Pattern.compile(lastFilterValue);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbAttachPanel.class, (String)"ERR_BadFilterPattern")));
            return null;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.processTable = new JTable();
        this.filterLabel = new JLabel();
        this.procLabel = new JLabel();
        this.projectLabel = new JLabel();
        this.projectCB = new JComboBox();
        this.allCheckBox = new JCheckBox();
        this.filterField = new JTextField();
        this.hostComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.processTable.setModel(this.processModel);
        this.processTable.setColumnSelectionAllowed(false);
        this.processTable.setRowSelectionAllowed(true);
        this.processTable.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.processTable);
        this.filterLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachFilterMNEM").charAt(0));
        this.filterLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachFilterLabel"));
        this.procLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachProcessMNEM").charAt(0));
        this.procLabel.setLabelFor(this.jScrollPane1);
        this.procLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachProcessLabel"));
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachProjectMNEM").charAt(0));
        this.projectLabel.setLabelFor(this.projectCB);
        this.projectLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachProjectLabel"));
        this.allCheckBox.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachPanel.allCheckBox.text"));
        this.allCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdbAttachPanel.this.allCheckBoxActionPerformed(actionEvent);
            }
        });
        this.hostComboBox.setRenderer(new MyDevHostListCellRenderer());
        this.jLabel1.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachPanel.jLabel1.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectLabel).addPreferredGap(0).add((Component)this.projectCB, 0, 517, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.allCheckBox).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.hostComboBox, 0, 534, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.filterField, -1, 534, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.procLabel).addContainerGap()).add((Component)this.jScrollPane1, -1, 588, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.hostComboBox, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.filterField, -2, -1, -2)).addPreferredGap(0).add((Component)this.procLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 201, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.allCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.projectCB, -2, -1, -2))));
    }

    private void allCheckBoxActionPerformed(ActionEvent actionEvent) {
        showAll = this.allCheckBox.isSelected();
        this.updateProcessList(false);
    }

    private void hostComboBoxItemStateChanged(ItemEvent itemEvent) {
        ExecutionEnvironment executionEnvironment = this.getCurrentExecutionEnvironment();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                GdbAttachPanel.this.updateProcessList(true);
            }
        });
    }

    static class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        MyDevHostListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ServerRecord serverRecord = (ServerRecord)object;
            jLabel.setText(serverRecord.getServerDisplayName());
            return jLabel;
        }
    }

    public static abstract class AnyChangeDocumentListener
    implements DocumentListener {
        public abstract void documentChanged(DocumentEvent var1);

        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }
    }

    private class GdbAttachController
    implements Controller {
        private GdbAttachController() {
        }

        public boolean cancel() {
            return true;
        }

        public boolean ok() {
            int n = GdbAttachPanel.this.processTable.getSelectedRow();
            if (n >= 0) {
                String string = GdbAttachPanel.this.processModel.getValueAt(n, 1).toString();
                ProjectCBItem projectCBItem = (ProjectCBItem)GdbAttachPanel.this.projectCB.getSelectedItem();
                if (projectCBItem != null) {
                    try {
                        GdbDebugger.attach(Long.valueOf(string), projectCBItem.getProjectInformation(), GdbAttachPanel.this.getCurrentExecutionEnvironment());
                    }
                    catch (DebuggerStartException debuggerStartException) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbAttachPanel.class, (String)"ERR_UnexpecedAttachFailure", (Object)string)));
                    }
                }
            }
            return true;
        }

        public boolean isValid() {
            return GdbAttachPanel.this.projectCB.getItemCount() > 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    static class AttachTableModel
    extends DefaultTableModel {
        AttachTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public static class ProjectCBItem {
        private ProjectInformation pinfo;

        public ProjectCBItem(ProjectInformation projectInformation) {
            this.pinfo = projectInformation;
        }

        public String toString() {
            return this.pinfo.getDisplayName();
        }

        public Project getProject() {
            return this.pinfo.getProject();
        }

        public ProjectInformation getProjectInformation() {
            return this.pinfo;
        }
    }
}

