/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private final Logger log = Logger.getLogger("gdb.breakpoint.annotations");
    private final GdbDebugger debugger;

    public ToggleBreakpointActionProvider() {
        this.debugger = null;
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentURL();
        if (string.trim().equals("")) {
            return;
        }
        CndBreakpoint cndBreakpoint = ToggleBreakpointActionProvider.findBreakpoint(string, n);
        if (cndBreakpoint != null) {
            this.log.fine("ToggleBreakpointActionProvider.doAction: Removing breakpoint at " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
            debuggerManager.removeBreakpoint((Breakpoint)cndBreakpoint);
            return;
        }
        cndBreakpoint = LineBreakpoint.create((String)string, (int)n);
        cndBreakpoint.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        this.log.fine("ToggleBreakpointActionProvider.doAction: Adding breakpoint at " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
        debuggerManager.addBreakpoint((Breakpoint)cndBreakpoint);
    }

    static CndBreakpoint findBreakpoint(String string, int n) {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        Disassembly disassembly = Disassembly.getCurrent();
        boolean bl = Disassembly.isDisasm(string);
        for (Breakpoint breakpoint : breakpointArray) {
            LineBreakpoint lineBreakpoint;
            if (!(breakpoint instanceof LineBreakpoint ? (lineBreakpoint = (LineBreakpoint)breakpoint).getURL().equals(string) && lineBreakpoint.getLineNumber() == n : bl && breakpoint instanceof AddressBreakpoint && disassembly != null && disassembly.getAddressLine((lineBreakpoint = (AddressBreakpoint)breakpoint).getAddress()) == n)) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentMIMEType();
        boolean bl = (MIMENames.isFortranOrHeaderOrCppOrC((String)string) || string.equals("text/x-asm")) && n > 0;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
        if (this.debugger != null && this.debugger.getState() == GdbDebugger.State.EXITED) {
            this.destroy();
        }
    }
}

