/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachOutputActionProvider
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String string, ProjectActionEvent[] projectActionEventArray) {
        if (projectActionEventArray != null && projectActionEventArray.length > 0 && projectActionEventArray[projectActionEventArray.length - 1].getType() == ProjectActionEvent.Type.RUN) {
            return Collections.singletonList(new AttachAction(projectActionEventArray));
        }
        return Collections.emptyList();
    }

    private static final class AttachAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction {
        ProjectActionEvent[] events;
        private int step = -1;
        private long pid = -1L;

        public AttachAction(ProjectActionEvent[] projectActionEventArray) {
            this.events = projectActionEventArray;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/actions/Attach.gif", (boolean)false));
            this.putValue("ShortDescription", NbBundle.getBundle(AttachOutputActionProvider.class).getString("OUTPUT_ATTACH_ACTION_TEXT"));
            this.setEnabled(false);
        }

        public void executionStarted(int n) {
            if (this.step == this.events.length - 1 && n != -1) {
                this.pid = n;
                this.setEnabled(true);
            }
        }

        public void executionFinished(int n) {
            this.setEnabled(false);
        }

        public void setStep(int n) {
            this.step = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.pid == -1L) {
                return;
            }
            ProjectActionEvent projectActionEvent = this.events[this.step];
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)projectActionEvent.getProject());
            if (projectInformation == null) {
                return;
            }
            try {
                GdbDebugger.attach(this.pid, projectInformation, projectActionEvent.getConfiguration().getDevelopmentHost().getExecutionEnvironment());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

