/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.classhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.navigation.classhierarchy.HierarchyNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyChildren
extends Children.Keys<CsmClass> {
    private static Comparator<CsmClass> COMARATOR = new MyComparator();
    private CsmClass object;
    private HierarchyModel model;
    private HierarchyChildren parent;
    private boolean isInited = false;

    public HierarchyChildren(CsmClass csmClass, HierarchyModel hierarchyModel, HierarchyChildren hierarchyChildren) {
        this.object = csmClass;
        this.model = hierarchyModel;
        this.parent = hierarchyChildren;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.setKeys(new CsmClass[0]);
        }
    }

    private synchronized void resetKeys() {
        Set<CsmClass> set;
        if (this.object.isValid() && (set = this.model.getModel().get(this.object)) != null && set.size() > 0) {
            ArrayList<CsmClass> arrayList = new ArrayList<CsmClass>(set);
            Collections.sort(arrayList, COMARATOR);
            this.setKeys(arrayList);
            return;
        }
        this.setKeys(new CsmClass[0]);
    }

    protected Node[] createNodes(CsmClass csmClass) {
        HierarchyNode hierarchyNode = null;
        Set<CsmClass> set = this.model.getModel().get(csmClass);
        hierarchyNode = set == null || set.size() == 0 ? new HierarchyNode(csmClass, Children.LEAF, this.model, false) : (this.checkRecursion(csmClass) ? new HierarchyNode(csmClass, Children.LEAF, this.model, true) : new HierarchyNode(csmClass, this.model, this));
        return new Node[]{hierarchyNode};
    }

    private boolean checkRecursion(CsmClass csmClass) {
        if (csmClass.equals(this.object)) {
            return true;
        }
        HierarchyChildren hierarchyChildren = this.parent;
        while (hierarchyChildren != null) {
            if (csmClass.equals(hierarchyChildren.object)) {
                return true;
            }
            hierarchyChildren = hierarchyChildren.parent;
        }
        return false;
    }

    protected void addNotify() {
        this.isInited = true;
        this.resetKeys();
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyComparator
    implements Comparator<CsmClass> {
        private MyComparator() {
        }

        @Override
        public int compare(CsmClass csmClass, CsmClass csmClass2) {
            String string = ((Object)csmClass.getName()).toString();
            String string2 = ((Object)csmClass2.getName()).toString();
            return string.compareTo(string2);
        }
    }
}

