/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.api.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.api.customization.model.JavaClass;
import org.netbeans.modules.websvc.api.customization.model.PortTypeCustomization;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.DefinitionsPanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortTypePanel
extends SaveableSectionInnerPanel {
    private PortType portType;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultItemListener;
    private ModelChangeListener modelListener;
    private PortTypeActionListener listener;
    private Definitions primaryDefinitions;
    private JCheckBox defaultJavaClassCB;
    private ButtonGroup eamButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel javaClassLabel;
    private JTextField javaClassText;

    public PortTypePanel(SectionView sectionView, PortType portType, Node node, Definitions definitions) {
        super(sectionView);
        this.portType = portType;
        this.primaryDefinitions = definitions;
        this.model = this.portType.getModel();
        this.initComponents();
        this.disableEnterKey();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.javaClassText.setToolTipText(NbBundle.getMessage(PortTypePanel.class, (String)"TOOLTIP_PORTTYPE_CLASS"));
        this.syncButtons();
        this.syncJavaClass();
        this.defaultItemListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultItemListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(itemListener);
        this.modelListener = new ModelChangeListener();
        WSDLModel wSDLModel = definitions.getModel();
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)wSDLModel);
        wSDLModel.addPropertyChangeListener(propertyChangeListener);
        this.listener = new PortTypeActionListener();
        ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableAsyncMappingCB);
        this.enableAsyncMappingCB.addActionListener(actionListener);
        ActionListener actionListener2 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableWrapperStyleCB);
        this.enableWrapperStyleCB.addActionListener(actionListener2);
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
    }

    private void syncJavaClass() {
        List list = this.portType.getExtensibilityElements(PortTypeCustomization.class);
        if (list.size() > 0) {
            PortTypeCustomization portTypeCustomization = (PortTypeCustomization)list.get(0);
            JavaClass javaClass = portTypeCustomization.getJavaClass();
            if (javaClass != null) {
                this.setJavaClass(javaClass.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
        }
    }

    private void syncButtons() {
        List list = this.portType.getExtensibilityElements(PortTypeCustomization.class);
        if (list.size() > 0) {
            PortTypeCustomization portTypeCustomization = (PortTypeCustomization)list.get(0);
            EnableAsyncMapping enableAsyncMapping = portTypeCustomization.getEnableAsyncMapping();
            if (enableAsyncMapping != null) {
                this.setEnableAsyncMapping(enableAsyncMapping.isEnabled());
            } else {
                this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            }
            EnableWrapperStyle enableWrapperStyle = portTypeCustomization.getEnableWrapperStyle();
            if (enableWrapperStyle != null) {
                this.setEnableWrapperStyle(enableWrapperStyle.isEnabled());
            } else {
                this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
            }
        } else {
            this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
        }
    }

    private boolean getAsyncMappingOfParent() {
        DefinitionsCustomization definitionsCustomization;
        EnableAsyncMapping enableAsyncMapping;
        List list = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() > 0 && (enableAsyncMapping = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getEnableAsyncMapping()) != null) {
            return enableAsyncMapping.isEnabled();
        }
        return false;
    }

    private boolean getWrapperStyleOfParent() {
        DefinitionsCustomization definitionsCustomization;
        EnableWrapperStyle enableWrapperStyle;
        List list = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() > 0 && (enableWrapperStyle = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getEnableWrapperStyle()) != null) {
            return enableWrapperStyle.isEnabled();
        }
        return true;
    }

    public void setEnableAsyncMapping(boolean bl) {
        this.enableAsyncMappingCB.setSelected(bl);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean bl) {
        this.enableWrapperStyleCB.setSelected(bl);
    }

    public Boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public String getJavaClass() {
        return this.javaClassText.getText();
    }

    public void setJavaClass(String string) {
        this.javaClassText.setText(string);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.portType.getExtensibilityElements(PortTypeCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
            String string = this.javaClassText.getText();
            if (string != null && !string.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                if (!JaxWsUtils.isJavaIdentifier((String)string)) {
                    return;
                }
                if (list.size() == 1) {
                    PortTypeCustomization portTypeCustomization = (PortTypeCustomization)list.get(0);
                    JavaClass javaClass = portTypeCustomization.getJavaClass();
                    if (javaClass == null) {
                        try {
                            javaClass = customizationComponentFactory.createJavaClass(this.model);
                            this.model.startTransaction();
                            javaClass.setName(string);
                            portTypeCustomization.setJavaClass(javaClass);
                            this.wsdlDirty = true;
                            return;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            javaClass.setName(string);
                            this.wsdlDirty = true;
                            return;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    PortTypeCustomization portTypeCustomization = customizationComponentFactory.createPortTypeCustomization(this.model);
                    JavaClass javaClass = customizationComponentFactory.createJavaClass(this.model);
                    try {
                        this.model.startTransaction();
                        javaClass.setName(string);
                        portTypeCustomization.setJavaClass(javaClass);
                        this.portType.addExtensibilityElement((ExtensibilityElement)portTypeCustomization);
                        this.wsdlDirty = true;
                        return;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                try {
                    PortTypeCustomization portTypeCustomization;
                    JavaClass javaClass;
                    if (list.size() != 1 || (javaClass = (portTypeCustomization = (PortTypeCustomization)list.get(0)).getJavaClass()) == null) return;
                    this.model.startTransaction();
                    portTypeCustomization.removeJavaClass(javaClass);
                    if (portTypeCustomization.getChildren().size() == 0) {
                        this.portType.removeExtensibilityElement((ExtensibilityElement)portTypeCustomization);
                    }
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
        if (jComponent == this.enableWrapperStyleCB) {
            if (list.size() == 1) {
                PortTypeCustomization portTypeCustomization = (PortTypeCustomization)list.get(0);
                EnableWrapperStyle enableWrapperStyle = portTypeCustomization.getEnableWrapperStyle();
                if (enableWrapperStyle == null) {
                    try {
                        this.model.startTransaction();
                        enableWrapperStyle = customizationComponentFactory.createEnableWrapperStyle(this.model);
                        enableWrapperStyle.setEnabled(this.getEnableWrapperStyle().booleanValue());
                        portTypeCustomization.setEnableWrapperStyle(enableWrapperStyle);
                        this.wsdlDirty = true;
                        return;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableWrapperStyle.setEnabled(this.getEnableWrapperStyle().booleanValue());
                        this.wsdlDirty = true;
                        return;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                PortTypeCustomization portTypeCustomization = customizationComponentFactory.createPortTypeCustomization(this.model);
                EnableWrapperStyle enableWrapperStyle = customizationComponentFactory.createEnableWrapperStyle(this.model);
                try {
                    this.model.startTransaction();
                    enableWrapperStyle.setEnabled(this.getEnableWrapperStyle().booleanValue());
                    portTypeCustomization.setEnableWrapperStyle(enableWrapperStyle);
                    this.portType.addExtensibilityElement((ExtensibilityElement)portTypeCustomization);
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
        if (jComponent != this.enableAsyncMappingCB) return;
        if (list.size() == 1) {
            PortTypeCustomization portTypeCustomization = (PortTypeCustomization)list.get(0);
            EnableAsyncMapping enableAsyncMapping = portTypeCustomization.getEnableAsyncMapping();
            if (enableAsyncMapping == null) {
                try {
                    this.model.startTransaction();
                    enableAsyncMapping = customizationComponentFactory.createEnableAsyncMapping(this.model);
                    enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                    portTypeCustomization.setEnableAsyncMapping(enableAsyncMapping);
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            } else {
                try {
                    this.model.startTransaction();
                    enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                    this.wsdlDirty = true;
                    return;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
        PortTypeCustomization portTypeCustomization = customizationComponentFactory.createPortTypeCustomization(this.model);
        EnableAsyncMapping enableAsyncMapping = customizationComponentFactory.createEnableAsyncMapping(this.model);
        try {
            this.model.startTransaction();
            enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
            portTypeCustomization.setEnableAsyncMapping(enableAsyncMapping);
            this.portType.addExtensibilityElement((ExtensibilityElement)portTypeCustomization);
            this.wsdlDirty = true;
            return;
        }
        finally {
            this.model.endTransaction();
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.javaClassText && !JaxWsUtils.isJavaIdentifier((String)string)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, string, (JComponent)jTextComponent));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.javaClassText) {
            PortTypeCustomization portTypeCustomization;
            JavaClass javaClass;
            String string = "";
            List list = this.portType.getExtensibilityElements(PortTypeCustomization.class);
            if (list.size() == 1 && (javaClass = (portTypeCustomization = (PortTypeCustomization)list.get(0)).getJavaClass()) != null) {
                string = javaClass.getName();
            }
            this.javaClassText.setText(string);
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.javaClassLabel.setText(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setContentAreaFilled(false);
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setContentAreaFilled(false);
        this.enableWrapperStyleCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setContentAreaFilled(false);
        this.enableAsyncMappingCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(23, 23, 23).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.enableAsyncMappingCB).add((Component)this.enableWrapperStyleCB).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.javaClassLabel).add(16, 16, 16).add((Component)this.javaClassText, -2, 237, -2).add(21, 21, 21).add((Component)this.defaultJavaClassCB))).addContainerGap(33, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(26, 26, 26).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.javaClassLabel).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.javaClassText, -2, 16, -2).add((Component)this.defaultJavaClassCB))).add(18, 18, 18).add((Component)this.enableWrapperStyleCB).add(15, 15, 15).add((Component)this.enableAsyncMappingCB).addContainerGap(25, Short.MAX_VALUE)));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EnableAsyncMapping enableAsyncMapping;
            WSDLComponent wSDLComponent;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof EnableWrapperStyle) {
                EnableWrapperStyle enableWrapperStyle = (EnableWrapperStyle)object;
                WSDLComponent wSDLComponent2 = (WSDLComponent)enableWrapperStyle.getParent();
                if (wSDLComponent2 instanceof DefinitionsCustomization) {
                    PortTypePanel.this.syncButtons();
                }
            } else if (object instanceof EnableAsyncMapping && (wSDLComponent = (WSDLComponent)(enableAsyncMapping = (EnableAsyncMapping)object).getParent()) instanceof DefinitionsCustomization) {
                PortTypePanel.this.syncButtons();
            }
        }
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (PortTypePanel.this.defaultJavaClassCB.isSelected()) {
                PortTypePanel.this.javaClassText.setEnabled(false);
            } else {
                PortTypePanel.this.javaClassText.setEnabled(true);
                PortTypePanel.this.javaClassText.requestFocus();
            }
        }
    }

    class PortTypeActionListener
    implements ActionListener {
        PortTypeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortTypePanel.this.setValue((JComponent)actionEvent.getSource(), null);
        }
    }
}

