/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.visitor.ChildVisitor;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceRefactorVisitor
extends ChildVisitor {
    private String namespace;
    private String prefix;
    private List<Node> path;
    private Set<String> prefixesUsedByAttributesForDefaultNS = new HashSet<String>();
    private XDMModel model;
    private static final Pattern p = Pattern.compile("\\s*(\\S+)\\s*");

    public NamespaceRefactorVisitor() {
        this(null);
    }

    public NamespaceRefactorVisitor(XDMModel xDMModel) {
        this.model = xDMModel;
    }

    public void refactor(NodeImpl nodeImpl, String string, String string2, List<Node> list) {
        if (this.model.getQNameValuedAttributes() == null) {
            return;
        }
        assert (string != null) : "Cannot refactor null namespace";
        this.namespace = string;
        this.prefix = string2;
        this.path = list;
        nodeImpl.accept(this);
    }

    @Override
    public void visit(Element element) {
        this.path.add(0, element);
        NamespaceCheck namespaceCheck = new NamespaceCheck(this.prefix, this.namespace, element);
        if (namespaceCheck.getPrefixRedeclaration() == null) {
            this.visitNode(element);
            if (this.namespace.equals(NodeImpl.lookupNamespace(element.getPrefix(), this.path))) {
                element.setPrefix(this.prefix);
            }
            for (Attribute attribute : namespaceCheck.getNamespaceRedeclaration()) {
                String string = attribute.getLocalName();
                if (this.prefixesUsedByAttributesForDefaultNS.remove(string)) continue;
                element.removeAttributeNode(attribute);
            }
            if (namespaceCheck.getDuplicateDeclaration() != null) {
                element.removeAttributeNode(namespaceCheck.getDuplicateDeclaration());
            }
        }
        this.path.remove(element);
    }

    @Override
    public void visit(Attribute attribute) {
        if (attribute.isXmlnsAttribute()) {
            return;
        }
        String string = attribute.getPrefix();
        if (!NamespaceRefactorVisitor.isDefaultPrefix(string) && this.namespace.equals(NodeImpl.lookupNamespace(string, this.path))) {
            if (NamespaceRefactorVisitor.isDefaultPrefix(this.prefix)) {
                this.prefixesUsedByAttributesForDefaultNS.add(string);
            } else {
                attribute.setPrefix(this.prefix);
            }
        }
        if (this.isQNameValued(attribute)) {
            this.prefixesUsedByAttributesForDefaultNS.addAll(NamespaceRefactorVisitor.refactorAttributeValue(attribute, this.namespace, this.prefix, this.path, this.model));
        }
    }

    private QName getQName(Element element) {
        String string = NodeImpl.lookupNamespace(element.getPrefix(), this.path);
        return new QName(string, element.getLocalName());
    }

    private QName getQName(Attribute attribute) {
        String string = attribute.getPrefix();
        String string2 = string == null || string.length() == 0 ? null : NodeImpl.lookupNamespace(string, this.path);
        return new QName(string2, attribute.getLocalName());
    }

    private boolean isQNameValued(Attribute attribute) {
        assert (this.path != null && this.path.size() > 0);
        Element element = (Element)this.path.get(0);
        QName qName = this.getQName(element);
        QName qName2 = this.getQName(attribute);
        List<QName> list = this.model.getQNameValuedAttributes().get(qName);
        if (list != null) {
            return list.contains(qName2);
        }
        return false;
    }

    public static boolean isDefaultPrefix(String string) {
        return string == null || string.equals("");
    }

    public static List<String> refactorAttributeValue(Attribute attribute, String string, String string2, List<Node> list, XDMModel xDMModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = attribute.getValue();
        StringBuilder stringBuilder = null;
        Matcher matcher = p.matcher(string3);
        while (matcher.find()) {
            String string4 = matcher.group(1);
            String[] stringArray = string4.split(":");
            if (stringArray.length <= 1) continue;
            String string5 = stringArray[0];
            String string6 = list.size() == 1 ? list.get(0).lookupNamespaceURI(string5) : NodeImpl.lookupNamespace(string5, list);
            if (!string.equals(string6)) continue;
            if (NamespaceRefactorVisitor.isDefaultPrefix(string2)) {
                arrayList.add(string5);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
            stringBuilder.append(":");
            stringBuilder.append(stringArray[1]);
            stringBuilder.append(" ");
        }
        if (stringBuilder != null) {
            attribute.setValue(stringBuilder.toString().trim());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamespaceCheck {
        Attribute duplicate;
        Attribute prefixRedeclaration;
        List<Attribute> namespaceRedeclaredAttributes = new ArrayList<Attribute>();

        public NamespaceCheck(String string, String string2, Element element) {
            this.init(string, string2, element);
        }

        public Attribute getPrefixRedeclaration() {
            return this.prefixRedeclaration;
        }

        public List<Attribute> getNamespaceRedeclaration() {
            return this.namespaceRedeclaredAttributes;
        }

        public Attribute getDuplicateDeclaration() {
            return this.duplicate;
        }

        private void init(String string, String string2, Element element) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attribute attribute;
                if (!(namedNodeMap.item(i) instanceof Attribute) || !(attribute = (Attribute)namedNodeMap.item(i)).isXmlnsAttribute()) continue;
                Attribute attribute2 = null;
                Attribute attribute3 = null;
                String string3 = attribute.getLocalName();
                if ("xmlns".equals(string3)) {
                    string3 = "";
                }
                if (string3.equals(string)) {
                    attribute2 = attribute;
                }
                if (string2.equals(attribute.getValue())) {
                    attribute3 = attribute;
                }
                if (attribute2 != null && attribute3 != null) {
                    this.duplicate = attribute;
                    continue;
                }
                if (attribute2 != null) {
                    this.prefixRedeclaration = attribute;
                    continue;
                }
                if (attribute3 == null) continue;
                this.namespaceRedeclaredAttributes.add(attribute);
            }
        }
    }
}

