/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Image;
import java.io.File;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public final class VisualClassPathItem {
    public static final int TYPE_JAR = 0;
    public static final int TYPE_LIBRARY = 1;
    public static final int TYPE_ARTIFACT = 2;
    public static final int TYPE_CLASSPATH = 3;
    public static final int TYPE_FOLDER = 4;
    private final String RESOURCE_ICON_JAR = "org/netbeans/modules/project/support/customizer/resources/jar.gif";
    private final String RESOURCE_ICON_FOLDER = "org/netbeans/modules/project/support/customizer/resources/folder.gif";
    private final String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/project/support/customizer/resources/libraries.gif";
    private final String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/project/support/customizer/resources/projectDependencies.gif";
    private final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/project/support/customizer/resources/project.gif";
    private final String RESOURCE_ICON_BROKEN = "org/netbeans/modules/project/support/customizer/resources/brokenProjectBadge.gif";
    private Icon ICON_JAR;
    private Icon ICON_LIBRARY;
    private Icon ICON_ARTIFACT;
    private Icon ICON_CLASSPATH;
    private Icon ICON_FOLDER;
    private Icon ICON_BROKEN_JAR;
    private Icon ICON_BROKEN_LIBRARY;
    private Icon ICON_BROKEN_ARTIFACT;
    private Icon ICON_BROKEN_CLASSPATH;
    private Icon ICON_BROKEN_FOLDER;
    private Image IMAGE_JAR;
    private Image IMAGE_LIBRARY;
    private Image IMAGE_ARTIFACT;
    private Image IMAGE_CLASSPATH;
    private Image IMAGE_FOLDER;
    private Image IMAGE_BROKEN_JAR;
    private Image IMAGE_BROKEN_LIBRARY;
    private Image IMAGE_BROKEN_ARTIFACT;
    private Image IMAGE_BROKEN_CLASSPATH;
    private Image IMAGE_BROKEN_FOLDER;
    private int type;
    private Object cpElement;
    private String display;
    private String rawText;
    private URI uri;
    private boolean extra;

    public static VisualClassPathItem create(Library library) {
        if (library == null) {
            throw new IllegalArgumentException("library must not be null");
        }
        String string = library.getName();
        return new VisualClassPathItem(library, 1, "${libs." + string + ".classpath}", library.getDisplayName());
    }

    public static VisualClassPathItem create(AntArtifact antArtifact, URI uRI) {
        String string;
        if (uRI == null) {
            throw new IllegalArgumentException("artifactURI must not be null");
        }
        if (antArtifact == null) {
            throw new IllegalArgumentException("artifact must not be null");
        }
        try {
            string = FileUtil.normalizeFile((File)new File(antArtifact.getScriptLocation().getParentFile().toURI().resolve(uRI))).getPath();
        }
        catch (Exception exception) {
            string = uRI.getPath();
        }
        return new VisualClassPathItem(antArtifact, uRI, 2, null, string);
    }

    public static VisualClassPathItem create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        return new VisualClassPathItem(file, VisualClassPathItem.isJar(file.getName()) ? 0 : 4, null, file.getPath());
    }

    private static boolean isJar(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip");
    }

    public void setExtra(boolean bl) {
        this.extra = bl;
    }

    public boolean isExtra() {
        return this.extra;
    }

    public VisualClassPathItem(AntArtifact antArtifact, URI uRI, int n, String string, String string2) {
        this(antArtifact, n, string, string2);
        this.uri = uRI;
    }

    public VisualClassPathItem(Object object, int n, String string, String string2) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/brokenProjectBadge.gif");
        this.IMAGE_JAR = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/jar.gif");
        this.ICON_JAR = new ImageIcon(this.IMAGE_JAR);
        this.IMAGE_BROKEN_JAR = ImageUtilities.mergeImages((Image)this.IMAGE_JAR, (Image)image, (int)8, (int)0);
        this.ICON_BROKEN_JAR = new ImageIcon(this.IMAGE_BROKEN_JAR);
        this.IMAGE_LIBRARY = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/libraries.gif");
        this.ICON_LIBRARY = new ImageIcon(this.IMAGE_LIBRARY);
        this.IMAGE_BROKEN_LIBRARY = ImageUtilities.mergeImages((Image)this.IMAGE_LIBRARY, (Image)image, (int)8, (int)0);
        this.ICON_BROKEN_LIBRARY = new ImageIcon(this.IMAGE_BROKEN_LIBRARY);
        this.IMAGE_ARTIFACT = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/projectDependencies.gif");
        this.ICON_ARTIFACT = new ImageIcon(this.IMAGE_ARTIFACT);
        this.IMAGE_BROKEN_ARTIFACT = ImageUtilities.mergeImages((Image)this.IMAGE_ARTIFACT, (Image)image, (int)8, (int)0);
        this.ICON_BROKEN_ARTIFACT = new ImageIcon(this.IMAGE_BROKEN_ARTIFACT);
        this.IMAGE_CLASSPATH = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/project.gif");
        this.ICON_CLASSPATH = new ImageIcon(this.IMAGE_CLASSPATH);
        this.IMAGE_BROKEN_CLASSPATH = ImageUtilities.mergeImages((Image)this.IMAGE_CLASSPATH, (Image)image, (int)8, (int)0);
        this.ICON_BROKEN_CLASSPATH = new ImageIcon(this.IMAGE_BROKEN_CLASSPATH);
        this.IMAGE_FOLDER = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/folder.gif");
        this.ICON_FOLDER = new ImageIcon(this.IMAGE_FOLDER);
        this.IMAGE_BROKEN_FOLDER = ImageUtilities.mergeImages((Image)this.IMAGE_FOLDER, (Image)image, (int)8, (int)0);
        this.ICON_BROKEN_FOLDER = new ImageIcon(this.IMAGE_BROKEN_FOLDER);
        this.extra = false;
        this.cpElement = object;
        this.type = n;
        this.display = string2;
        this.rawText = string;
    }

    public Object getElement() {
        return this.cpElement;
    }

    public URI getURI() {
        return this.uri;
    }

    public int getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.display;
    }

    public String getRawText() {
        return this.rawText;
    }

    public boolean canDelete() {
        return this.getType() != 3;
    }

    public Icon getIcon() {
        switch (this.getType()) {
            case 0: {
                return this.getElement() != null ? this.ICON_JAR : this.ICON_BROKEN_JAR;
            }
            case 4: {
                return this.getElement() != null ? this.ICON_FOLDER : this.ICON_BROKEN_FOLDER;
            }
            case 1: {
                return this.getElement() != null ? this.ICON_LIBRARY : this.ICON_BROKEN_LIBRARY;
            }
            case 2: {
                return this.getElement() != null ? this.ICON_ARTIFACT : this.ICON_BROKEN_ARTIFACT;
            }
            case 3: {
                return this.getElement() != null ? this.ICON_CLASSPATH : this.ICON_BROKEN_CLASSPATH;
            }
        }
        return null;
    }

    public Image getImage() {
        switch (this.getType()) {
            case 0: {
                return this.getElement() != null ? this.IMAGE_JAR : this.IMAGE_BROKEN_JAR;
            }
            case 4: {
                return this.getElement() != null ? this.IMAGE_FOLDER : this.IMAGE_BROKEN_FOLDER;
            }
            case 1: {
                return this.getElement() != null ? this.IMAGE_LIBRARY : this.IMAGE_BROKEN_LIBRARY;
            }
            case 2: {
                return this.getElement() != null ? this.IMAGE_ARTIFACT : this.IMAGE_BROKEN_ARTIFACT;
            }
            case 3: {
                return this.getElement() != null ? this.IMAGE_CLASSPATH : this.IMAGE_BROKEN_CLASSPATH;
            }
        }
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        int n = this.getType();
        switch (this.getType()) {
            case 2: {
                AntArtifact antArtifact = (AntArtifact)this.getElement();
                if (antArtifact == null) {
                    if (this.rawText == null) break;
                    n += this.rawText.hashCode();
                    break;
                }
                n += antArtifact.getType().hashCode();
                n += antArtifact.getScriptLocation().hashCode();
                n += this.uri.hashCode();
                break;
            }
            default: {
                Object object = this.getElement();
                if (object == null) break;
                n += object.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VisualClassPathItem)) {
            return false;
        }
        VisualClassPathItem visualClassPathItem = (VisualClassPathItem)object;
        if (this.getType() != visualClassPathItem.getType()) {
            return false;
        }
        switch (this.getType()) {
            case 2: {
                AntArtifact antArtifact = (AntArtifact)this.getElement();
                AntArtifact antArtifact2 = (AntArtifact)visualClassPathItem.getElement();
                if (antArtifact == null || antArtifact2 == null) {
                    return this.getRawText() != null && visualClassPathItem.getRawText() != null && this.getRawText().equals(visualClassPathItem.getRawText());
                }
                if (antArtifact.getType() != antArtifact2.getType()) {
                    return false;
                }
                if (!antArtifact.getScriptLocation().equals(antArtifact2.getScriptLocation())) {
                    return false;
                }
                return this.getURI().equals(visualClassPathItem.getURI());
            }
        }
        Object object2 = this.getElement();
        Object object3 = visualClassPathItem.getElement();
        if (object3 == null && object2 == null && visualClassPathItem.getRawText().equals(this.getRawText())) {
            return true;
        }
        if (object2 == null && object3 instanceof Library && this.toString().equals(visualClassPathItem.toString()) && visualClassPathItem.getRawText().equals(this.getRawText())) {
            return true;
        }
        if (object2 == null) {
            return false;
        }
        return object2.equals(visualClassPathItem.getElement());
    }
}

