/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.nodes.Hk2ApplicationsChildren;
import org.netbeans.modules.glassfish.common.nodes.Hk2InstanceNode;
import org.netbeans.modules.glassfish.common.nodes.Hk2ItemNode;
import org.netbeans.modules.glassfish.common.nodes.Hk2ResourceContainers;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.PluggableNodeProvider;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2InstanceChildren
extends Children.Keys<Node>
implements Refreshable,
ChangeListener {
    private GlassfishInstance serverInstance;

    Hk2InstanceChildren(GlassfishInstance glassfishInstance) {
        this.serverInstance = glassfishInstance;
        this.serverInstance.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.serverInstance));
    }

    @Override
    public void updateKeys() {
        Vector<Hk2ItemNode> vector = new Vector<Hk2ItemNode>();
        this.serverInstance.getCommonSupport().refresh();
        if (this.serverInstance.getServerState() == GlassfishModule.ServerState.RUNNING) {
            vector.add(new Hk2ItemNode(this.serverInstance.getLookup(), (Children)new Hk2ApplicationsChildren(this.serverInstance.getLookup()), NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_Apps"), Hk2ItemNode.J2EE_APPLICATION_FOLDER));
            vector.add(new Hk2ItemNode(this.serverInstance.getLookup(), (Children)new Hk2ResourceContainers(this.serverInstance.getLookup()), NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_Resources"), Hk2ItemNode.RESOURCES_FOLDER));
            List<Node> list = this.getExtensionNodes();
            Iterator<Node> iterator = list.iterator();
            while (iterator.hasNext()) {
                vector.add((Hk2ItemNode)iterator.next());
            }
        }
        this.setKeys(vector);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        Set set = Collections.emptySet();
        this.setKeys(set);
    }

    protected Node[] createNodes(Node node) {
        return new Node[]{node};
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                Hk2InstanceChildren.this.updateKeys();
            }
        });
    }

    List<Node> getExtensionNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        CommonServerSupport commonServerSupport = this.serverInstance.getCommonSupport();
        for (PluggableNodeProvider pluggableNodeProvider : Lookup.getDefault().lookupAll(PluggableNodeProvider.class)) {
            if (pluggableNodeProvider == null) continue;
            try {
                Node node = pluggableNodeProvider.getPluggableNode(commonServerSupport.getInstanceProperties());
                if (node == null) continue;
                arrayList.add(node);
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish-common").log(Level.SEVERE, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)pluggableNodeProvider.getClass().getName()));
                Logger.getLogger("glassfish-common").log(Level.FINER, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)pluggableNodeProvider.getClass().getName()), exception);
            }
            catch (AssertionError assertionError) {
                Logger.getLogger("glassfish-common").log(Level.SEVERE, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)(pluggableNodeProvider.getClass().getName() + ".")));
                Logger.getLogger("glassfish-common").log(Level.FINER, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)pluggableNodeProvider.getClass().getName()), (Throwable)((Object)assertionError));
            }
        }
        return arrayList;
    }
}

