/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyUtils {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    private static final Logger LOGGER = Logger.getLogger(RubyUtils.class.getName());
    public static final String[] RUBY_KEYWORDS = new String[]{"alias", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined?", "do", "else", "elsif", "END", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"};
    private static final String CONTROLLER_SUFFIX = "_controller.rb";
    public static final String[] RUBY_VIEW_EXTS;
    private static final String[] ACTIONMAILER_VIEW_EXTS;
    private static final Pattern RAILS_VERSION_PATTERN;

    private RubyUtils() {
    }

    public static boolean isRubyFile(FileObject fileObject) {
        return RUBY_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static boolean isMarkabyFile(FileObject fileObject) {
        return "mab".equals(fileObject.getExt());
    }

    public static boolean isRhtmlFile(FileObject fileObject) {
        return "application/x-httpd-eruby".equals(fileObject.getMIMEType());
    }

    public static boolean isRubyDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return RUBY_MIME_TYPE.equals(string);
    }

    public static boolean isRhtmlDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "application/x-httpd-eruby".equals(string);
    }

    public static boolean isYamlDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "text/x-yaml".equals(string);
    }

    public static boolean isYamlFile(FileObject fileObject) {
        return "text/x-yaml".equals(fileObject.getMIMEType());
    }

    public static boolean isRhtmlOrYamlFile(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        return "text/x-yaml".equals(string) || "application/x-httpd-eruby".equals(string);
    }

    public static boolean canContainRuby(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        return RUBY_MIME_TYPE.equals(string) || "text/x-yaml".equals(string) || "application/x-httpd-eruby".equals(string);
    }

    public static String camelToUnderlinedName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = Character.isUpperCase(c);
            if (bl2) {
                if (i > 0 && !bl) {
                    stringBuilder.append('_');
                    bl = true;
                }
                c = Character.toLowerCase(c);
            }
            stringBuilder.append(c);
            bl = c == '_';
        }
        return stringBuilder.toString();
    }

    public static boolean isOperator(String string) {
        if (string.length() == 0) {
            return false;
        }
        switch (string.charAt(0)) {
            case '+': {
                return string.equals("+") || string.equals("+@");
            }
            case '-': {
                return string.equals("-") || string.equals("-@");
            }
            case '*': {
                return string.equals("*") || string.equals("**");
            }
            case '<': {
                return string.equals("<") || string.equals("<<") || string.equals("<=") || string.equals("<=>");
            }
            case '>': {
                return string.equals(">") || string.equals(">>") || string.equals(">=");
            }
            case '=': {
                return string.equals("=") || string.equals("==") || string.equals("===") || string.equals("=~");
            }
            case '!': {
                return string.equals("!=") || string.equals("!~");
            }
            case '&': {
                return string.equals("&") || string.equals("&&");
            }
            case '|': {
                return string.equals("|") || string.equals("||");
            }
            case '[': {
                return string.equals("[]") || string.equals("[]=");
            }
            case '%': {
                return string.equals("%");
            }
            case '/': {
                return string.equals("/");
            }
            case '~': {
                return string.equals("~");
            }
            case '^': {
                return string.equals("^");
            }
            case '`': {
                return string.equals("`");
            }
        }
        return false;
    }

    public static boolean isSafeIdentifierName(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        if ("".equals(string.substring(n).trim())) {
            return false;
        }
        for (n2 = n; n2 < n3 && ((c = string.charAt(n2)) == '$' || c == '@' || c == ':'); ++n2) {
            if (n2 > 0 && c != '@') {
                return false;
            }
            if (n2 > 1) {
                return false;
            }
            if (n2 + 1 != n3) continue;
            return false;
        }
        if (Character.isDigit(string.charAt(n2))) {
            return false;
        }
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (!(c >= 'a' && c <= 'z' || c == '_' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '?' || c == '=' || c == '!')) {
                return RubyUtils.isOperator(string);
            }
            ++n2;
        }
        return true;
    }

    public static String getIdentifierWarning(String string, int n) {
        if (RubyUtils.isSafeIdentifierName(string, n)) {
            return null;
        }
        return NbBundle.getMessage(RubyUtils.class, (String)"UnsafeIdentifierName");
    }

    public static String underlinedNameToCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            if (c == '/') {
                bl = true;
                stringBuilder.append("::");
                continue;
            }
            if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidConstantFQN(String string) {
        String[] stringArray;
        if (string.trim().length() == 0) {
            return false;
        }
        for (String string2 : stringArray = string.split("::")) {
            if (RubyUtils.isValidConstantName(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidConstantName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!RubyUtils.isStrictIdentifierChar(c)) {
                return false;
            }
            if (c != '!' && c != '=' && c != '?') continue;
            return false;
        }
        return true;
    }

    static String[] parseConstantName(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf("::");
        if (n != -1) {
            string3 = string.substring(n + 2);
            string2 = string.substring(0, n);
        } else {
            string3 = string;
            string2 = "Kernel";
        }
        return new String[]{string2, string3};
    }

    static List<String> getParentModules(String string) {
        int n = string.lastIndexOf("::");
        if (n == -1) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n > 0) {
            String string2 = string.substring(0, n);
            arrayList.add(string2);
            n = string2.lastIndexOf("::");
        }
        return arrayList;
    }

    public static boolean isValidRubyLocalVarName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRubyMethodName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (RubyUtils.isOperator(string)) {
            return true;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return i == string.length() - 1 && (c == '!' || c == '=' || c == '?');
        }
        return true;
    }

    public static boolean isValidRubyIdentifier(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRubyKeyword(String string) {
        return Arrays.binarySearch(RUBY_KEYWORDS, string) >= 0;
    }

    public static String getLineCommentPrefix() {
        return "#";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '@' || c == '&' || c == ':' || c == '!' || c == '?' || c == '=';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '!' || c == '?' || c == '=';
    }

    public static String getControllerClass(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 != null) {
            String string = fileObject.getName();
            for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != fileObject2 && fileObject3 != null; fileObject3 = fileObject3.getParent()) {
                string = fileObject3.getName() + "/" + string;
            }
            return RubyUtils.underlinedNameToCamel(string);
        }
        return null;
    }

    public static List<String> getControllerNames(FileObject fileObject, boolean bl) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            RubyUtils.addControllerNames(fileObject2, arrayList, bl);
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static void addControllerNames(FileObject fileObject, List<String> list, boolean bl) {
        String string = fileObject.getNameExt();
        if (string.endsWith(CONTROLLER_SUFFIX)) {
            void var4_6;
            String object = string.substring(0, string.length() - CONTROLLER_SUFFIX.length());
            if (!bl) {
                String string2 = RubyUtils.underlinedNameToCamel(object);
            }
            list.add((String)var4_6);
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            RubyUtils.addControllerNames(fileObject2, list, bl);
        }
    }

    public static String getControllerName(FileObject fileObject) {
        String string;
        String string2 = "_controller";
        String string3 = "controllers";
        String string4 = string = fileObject.getName().substring(0, fileObject.getName().length() - string2.length());
        for (FileObject fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (fileObject2.getName().equals(string3) && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                fileObject2 = fileObject2.getParent();
                break;
            }
            string4 = fileObject2.getNameExt() + "/" + string4;
        }
        return string4;
    }

    public static FileObject getRailsViewFor(FileObject fileObject, String string, String string2, String string3, boolean bl) {
        FileObject fileObject2 = null;
        try {
            FileObject fileObject3;
            String string4;
            String string5 = string4 = fileObject.getName().substring(0, fileObject.getName().length() - string2.length());
            for (fileObject3 = fileObject.getParent(); fileObject3 != null; fileObject3 = fileObject3.getParent()) {
                if (fileObject3.getName().equals(string3) && (fileObject3.getParent() == null || fileObject3.getParent().getName().equals("app"))) {
                    fileObject3 = fileObject3.getParent();
                    break;
                }
                string5 = fileObject3.getNameExt() + "/" + string5;
            }
            if (fileObject3 == null) {
                return null;
            }
            FileObject fileObject4 = fileObject3.getFileObject("views/" + string5);
            if (fileObject4 == null) {
                return null;
            }
            if (string != null) {
                String string6;
                FileObject[] fileObjectArray = new ArrayList();
                fileObjectArray.addAll(Arrays.asList(RUBY_VIEW_EXTS));
                fileObjectArray.addAll(Arrays.asList(ACTIONMAILER_VIEW_EXTS));
                Iterator iterator = fileObjectArray.iterator();
                while (iterator.hasNext() && (fileObject2 = fileObject4.getFileObject(string, string6 = (String)iterator.next())) == null) {
                }
                if (fileObject2 == null && bl) {
                    return null;
                }
            }
            if (fileObject2 == null && string2.length() > 0 && (fileObject2 = fileObject4.getFileObject("index.rhtml")) == null) {
                block4: for (FileObject fileObject5 : fileObject4.getChildren()) {
                    String string7 = fileObject5.getExt();
                    for (String string8 : RUBY_VIEW_EXTS) {
                        if (!string7.equalsIgnoreCase(string8)) continue;
                        fileObject2 = fileObject5;
                        continue block4;
                    }
                }
            }
            if (fileObject2 == null) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (fileObject2 == null) {
            return null;
        }
        return fileObject2;
    }

    public static FileObject getRailsControllerFor(FileObject fileObject) {
        FileObject fileObject2;
        if (fileObject.getParent() == null) {
            return null;
        }
        FileObject fileObject3 = null;
        fileObject = fileObject.getParent();
        String string = fileObject.getName();
        String string2 = "";
        if (!string.startsWith("_")) {
            string2 = string;
        }
        for (fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (fileObject2.getName().equals("views") && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                fileObject2 = fileObject2.getParent();
                break;
            }
            string2 = fileObject2.getNameExt() + "/" + string2;
        }
        if (fileObject2 == null) {
            return null;
        }
        fileObject3 = fileObject2.getFileObject("controllers/" + string2 + CONTROLLER_SUFFIX);
        if (fileObject3 == null) {
            fileObject3 = fileObject2.getFileObject("models/" + string2 + ".rb");
        }
        return fileObject3;
    }

    static String join(String[] stringArray, String string) {
        return RubyUtils.join(Arrays.asList(stringArray), string);
    }

    static String join(Iterable<? extends String> iterable, String string) {
        return RubyUtils.join(iterable, string, string);
    }

    static String join(Iterable<? extends String> iterable, String string, String string2) {
        Iterator<? extends String> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(iterator.next());
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (iterator.hasNext()) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static BaseDocument getDocument(Parser.Result result) {
        return RubyUtils.getDocument(result, false);
    }

    public static BaseDocument getDocument(Parser.Result result, boolean bl) {
        return (BaseDocument)result.getSnapshot().getSource().getDocument(bl);
    }

    public static FileObject getFileObject(Parser.Result result) {
        return result.getSnapshot().getSource().getFileObject();
    }

    static boolean isRubyStubsURL(String string) {
        return string != null && string.indexOf("rubystubs") != -1;
    }

    static boolean isPlatformFile(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return true;
        }
        RubyPlatformProvider rubyPlatformProvider = (RubyPlatformProvider)project.getLookup().lookup(RubyPlatformProvider.class);
        return rubyPlatformProvider == null;
    }

    static boolean isRails23OrHigher(String string) {
        Matcher matcher = RAILS_VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String[] stringArray = matcher.group(2).split("\\.");
        if (Integer.parseInt(stringArray[0]) < 2) {
            return false;
        }
        return Integer.parseInt(stringArray[1]) >= 3;
    }

    static FileObject getFileObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        return null;
    }

    static boolean isRailsController(FileObject fileObject) {
        boolean bl = fileObject.getName().endsWith("_controller");
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return bl;
        }
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 == null) {
            return bl;
        }
        return FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) && bl;
    }

    static boolean isRailsProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app");
        FileObject fileObject3 = project.getProjectDirectory().getFileObject("config");
        FileObject fileObject4 = project.getProjectDirectory().getFileObject("db");
        return fileObject2 != null && fileObject3 != null && fileObject4 != null;
    }

    static FileObject getAppDir(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        return project.getProjectDirectory().getFileObject("app/");
    }

    static {
        Arrays.sort(RUBY_KEYWORDS);
        RUBY_VIEW_EXTS = new String[]{"rhtml", "erb", "dryml", "mab", "rjs", "haml", "rxml", "dryml", "html.erb"};
        ACTIONMAILER_VIEW_EXTS = new String[]{"text.rhtml", "html.erb", "html.rhtml", "text.html.rhtml", "text.html.erb"};
        RAILS_VERSION_PATTERN = Pattern.compile(".*/(action|active){1}.+-(\\d+\\.\\d+\\.?\\d*).+");
    }
}

