/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.classpath;

import java.util.Collections;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PlatformClassPathProvider
implements ClassPathProvider {
    private FileObject lastUsedRoot;
    private JavaPlatform lastUsedPlatform;
    private ClassPath emptyCp;

    public ClassPath findClassPath(FileObject fileObject, String string) {
        JavaPlatform[] javaPlatformArray;
        if (fileObject == null || string == null) {
            throw new IllegalArgumentException();
        }
        JavaPlatform javaPlatform = this.getLastUsedPlatform(fileObject);
        if (javaPlatform != null) {
            javaPlatformArray = new JavaPlatform[]{javaPlatform};
        } else {
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            javaPlatformArray = javaPlatformManager.getInstalledPlatforms();
        }
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            ClassPath classPath = javaPlatformArray[i].getBootstrapLibraries();
            ClassPath classPath2 = javaPlatformArray[i].getStandardLibraries();
            ClassPath classPath3 = javaPlatformArray[i].getSourceFolders();
            FileObject fileObject2 = null;
            if ("classpath/source".equals(string) && classPath3 != null && (fileObject2 = classPath3.findOwnerRoot(fileObject)) != null) {
                this.setLastUsedPlatform(fileObject2, javaPlatformArray[i]);
                return classPath3;
            }
            if ("classpath/boot".equals(string) && (classPath != null && (fileObject2 = classPath.findOwnerRoot(fileObject)) != null || classPath3 != null && (fileObject2 = classPath3.findOwnerRoot(fileObject)) != null || classPath2 != null && (fileObject2 = classPath2.findOwnerRoot(fileObject)) != null)) {
                this.setLastUsedPlatform(fileObject2, javaPlatformArray[i]);
                return classPath;
            }
            if (!"classpath/compile".equals(string)) continue;
            if (classPath2 != null && (fileObject2 = classPath2.findOwnerRoot(fileObject)) != null) {
                this.setLastUsedPlatform(fileObject2, javaPlatformArray[i]);
                return classPath2;
            }
            if ((classPath == null || (fileObject2 = classPath.findOwnerRoot(fileObject)) == null) && (classPath3 == null || (fileObject2 = classPath3.findOwnerRoot(fileObject)) == null)) continue;
            return this.getEmptyClassPath();
        }
        return null;
    }

    private synchronized ClassPath getEmptyClassPath() {
        if (this.emptyCp == null) {
            this.emptyCp = ClassPathSupport.createClassPath(Collections.emptyList());
        }
        return this.emptyCp;
    }

    private synchronized void setLastUsedPlatform(FileObject fileObject, JavaPlatform javaPlatform) {
        this.lastUsedRoot = fileObject;
        this.lastUsedPlatform = javaPlatform;
    }

    private synchronized JavaPlatform getLastUsedPlatform(FileObject fileObject) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)fileObject)) {
            return this.lastUsedPlatform;
        }
        return null;
    }
}

