/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.ui.FilteredKeymap;
import org.netbeans.modules.debugger.ui.Utils;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        WatchPanel.setupContext(this.editorPane, EditorContextDispatcher.getDefault().getMostRecentFile(), EditorContextDispatcher.getDefault().getMostRecentLineNumber());
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        JScrollPane jScrollPane = WatchPanel.createScrollableLineEditor(this.editorPane);
        int n = jScrollPane.getPreferredSize().height;
        int n2 = Math.min(70 * this.editorPane.getFontMetrics(this.editorPane.getFont()).charWidth('a'), WindowManager.getDefault().getMainWindow().getSize().width);
        jScrollPane.setPreferredSize(new Dimension(n2, n));
        this.panel.add("Center", jScrollPane);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setBorder(new CompoundBorder(this.editorPane.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        String string = Utils.getIdentifier();
        if (string != null) {
            this.editorPane.setText(string);
        } else {
            this.editorPane.setText(this.expression);
        }
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        this.editorPane.requestFocus();
        return this.panel;
    }

    private static void setupUI(final JEditorPane jEditorPane) {
        Runnable runnable = new Runnable(){

            public void run() {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
                if (editorUI != null) {
                    editorUI.removeLayer("highlight-row-layer");
                }
                try {
                    Field field = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    field.setAccessible(true);
                    field.set(editorUI, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void setupContext(JEditorPane jEditorPane, FileObject fileObject, int n) {
        StyledDocument styledDocument;
        if (n < 1) {
            n = 1;
        }
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
            DialogBinding.bindComponentToDocument((Document)styledDocument, (int)n2, (int)0, (JTextComponent)jEditorPane);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
        WatchPanel.setupUI(jEditorPane);
    }

    private static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField("M");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(jTextField.getBackground());
        jScrollPane.setBorder(jTextField.getBorder());
        jScrollPane.setBackground(jTextField.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jScrollPane.setViewportView(jPanel);
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        WatchPanel.setupUI(jEditorPane);
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }
}

