/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.web.servlet.tags.form.AbstractCheckboxTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractCheckboxTag {
    private Object value;
    private Object label;

    public void setValue(Object value) {
        Assert.notNull((Object)value, (String)"'value' must not be null");
        this.value = value;
    }

    protected Object getValue() {
        return this.value;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    protected Object getLabel() {
        return this.label;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "checkbox");
        Object boundValue = this.getBoundValue();
        Class valueType = this.getBindStatus().getValueType();
        if (Boolean.class.equals(valueType) || Boolean.TYPE.equals(valueType)) {
            if (boundValue instanceof String) {
                boundValue = Boolean.valueOf((String)boundValue);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            this.renderFromBoolean(booleanValue, tagWriter);
        } else {
            Object resolvedValue;
            Object value = this.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-boolean values");
            }
            Object object = resolvedValue = value instanceof String ? this.evaluate("value", (String)value) : value;
            if (boundValue != null && boundValue.getClass().isArray()) {
                this.renderFromCollection(resolvedValue, tagWriter);
            } else if (boundValue instanceof Collection) {
                this.renderFromCollection(resolvedValue, tagWriter);
            } else {
                this.renderSingleValue(resolvedValue, tagWriter);
            }
        }
        if (this.getLabel() != null) {
            tagWriter.appendValue(this.getLabel().toString());
        }
        tagWriter.endTag();
        if (!this.isDisabled()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            tagWriter.writeAttribute("name", "_" + this.getName());
            tagWriter.writeAttribute("value", "on");
            tagWriter.endTag();
        }
        return 6;
    }
}

