/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class GenericMap
implements Map {
    protected int size;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected int keyHash(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    protected boolean keyEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    protected int valueHash(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    protected boolean valueEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public void putAll(Map map) {
        if (map == this) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Iterator entryIterator();

    protected Iterator keyIterator() {
        return new KeyIterator();
    }

    protected Iterator valueIterator() {
        return new ValueIterator();
    }

    private static Object[] toArray(Object[] objectArray, int n, Iterator iterator) {
        Object[] objectArray2 = objectArray != null && objectArray.length >= n ? objectArray : (objectArray == null ? new Object[n] : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n));
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = iterator.next();
        }
        if (objectArray2.length > n) {
            objectArray2[n] = null;
        }
        return objectArray2;
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return GenericMap.this.valueIterator();
            }

            public int size() {
                return GenericMap.this.size();
            }

            public Object[] toArray(Object[] objectArray) {
                return GenericMap.toArray(objectArray, this.size(), this.iterator());
            }
        };
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return GenericMap.this.keyIterator();
            }

            public int size() {
                return GenericMap.this.size();
            }

            public Object[] toArray(Object[] objectArray) {
                return GenericMap.toArray(objectArray, this.size(), this.iterator());
            }
        };
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entryIterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.size() != this.size()) {
                return false;
            }
            Iterator iterator = this.entryIterator();
            while (iterator.hasNext()) {
                Object v;
                Entry entry = (Entry)iterator.next();
                Object k = entry.getKey();
                Object v2 = entry.getValue();
                if (!map.containsKey(k) || this.valueEquals(v2, v = map.get(k))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return GenericMap.this.entryIterator();
            }

            public int size() {
                return GenericMap.this.size;
            }

            public Object[] toArray(Object[] objectArray) {
                return GenericMap.toArray(objectArray, this.size(), this.iterator());
            }
        };
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.valueIterator();
        while (iterator.hasNext()) {
            if (!this.valueEquals(object, iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    class ValueIterator
    extends KeyOrValueIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    class KeyIterator
    extends KeyOrValueIterator {
        KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class KeyOrValueIterator
    implements Iterator {
        Iterator iter;

        KeyOrValueIterator() {
            this.iter = GenericMap.this.entryIterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        protected Map.Entry nextEntry() {
            return (Map.Entry)this.iter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class Entry
    implements Map.Entry {
        Entry() {
        }

        public int hashCode() {
            return GenericMap.this.keyHash(this.getKey()) ^ GenericMap.this.valueHash(this.getValue());
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return GenericMap.this.keyEquals(this.getKey(), entry.getKey()) && GenericMap.this.valueEquals(this.getValue(), entry.getValue());
            }
            return false;
        }
    }
}

