/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.lexer.yacc;

import java.io.Serializable;
import java.util.Collection;
import org.jruby.nb.ast.CommentNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDESourcePosition
implements ISourcePosition,
Serializable {
    private static final long serialVersionUID = 3762529027281400377L;
    private final String file;
    private final int startLine;
    private final int endLine;
    private int startOffset;
    private final int endOffset;
    private Collection<CommentNode> comments = Node.EMPTY_COMMENT_LIST;

    public IDESourcePosition() {
        this("", 0, 0);
    }

    public IDESourcePosition(String string, int n, int n2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.file = string;
        this.startLine = n;
        this.endLine = n2;
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public IDESourcePosition(String string, int n, int n2, int n3, int n4) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.file = string;
        this.startLine = n;
        this.endLine = n2;
        this.startOffset = n3;
        this.endOffset = n4;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IDESourcePosition)) {
            return false;
        }
        IDESourcePosition iDESourcePosition = (IDESourcePosition)object;
        return this.file.equals(iDESourcePosition.file) && this.endLine == iDESourcePosition.endLine;
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.endLine;
    }

    public String toString() {
        return this.file + ":[" + this.startLine + "," + this.endLine + "]:[" + this.getStartOffset() + "," + this.getEndOffset() + "]";
    }

    @Override
    public void adjustStartOffset(int n) {
        this.startOffset += n;
        if (this.startOffset < 0) {
            this.startOffset = 0;
        }
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public ISourcePosition union(ISourcePosition iSourcePosition) {
        return new IDESourcePosition(this.file, this.startLine, iSourcePosition.getEndLine(), this.startOffset, iSourcePosition.getEndOffset());
    }

    public static IDESourcePosition combinePosition(ISourcePosition iSourcePosition, ISourcePosition iSourcePosition2) {
        String string = iSourcePosition.getFile();
        int n = iSourcePosition.getStartOffset();
        int n2 = iSourcePosition.getEndOffset();
        int n3 = iSourcePosition.getStartLine();
        int n4 = iSourcePosition.getEndLine();
        if (n > iSourcePosition2.getStartOffset()) {
            n = iSourcePosition2.getStartOffset();
            n3 = iSourcePosition2.getStartLine();
        }
        if (n2 < iSourcePosition2.getEndOffset()) {
            n2 = iSourcePosition2.getEndOffset();
            n4 = iSourcePosition2.getEndLine();
        }
        IDESourcePosition iDESourcePosition = new IDESourcePosition(string, n3, n4, n, n2);
        return iDESourcePosition;
    }

    @Override
    public Collection<CommentNode> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(Collection<CommentNode> collection) {
        this.comments = collection;
    }
}

