/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject
extends RubyObject {
    protected JavaAccessibleObject(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static void registerRubyMethods(Ruby ruby, RubyClass rubyClass) {
        rubyClass.defineAnnotatedMethods(JavaAccessibleObject.class);
    }

    protected abstract AccessibleObject accessibleObject();

    public boolean equals(Object object) {
        return object instanceof JavaAccessibleObject && this.accessibleObject() == ((JavaAccessibleObject)object).accessibleObject();
    }

    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        return iRubyObject instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)iRubyObject).accessibleObject()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"})
    public IRubyObject same(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.equals(iRubyObject));
    }

    @JRubyMethod(name={"accessible?"})
    public RubyBoolean isAccessible() {
        return new RubyBoolean(this.getRuntime(), this.accessibleObject().isAccessible());
    }

    @JRubyMethod(name={"accessible="})
    public IRubyObject setAccessible(IRubyObject iRubyObject) {
        this.accessibleObject().setAccessible(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject annotation(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotation(((JavaClass)iRubyObject).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"})
    public IRubyObject annotation_present_p(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.accessibleObject().isAnnotationPresent(((JavaClass)iRubyObject).javaClass()));
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = ((Member)((Object)this.accessibleObject())).getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(((Member)((Object)this.accessibleObject())).getModifiers());
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(((Member)((Object)this.accessibleObject())).getName());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(((Member)((Object)this.accessibleObject())).isSynthetic());
    }

    @JRubyMethod(name={"to_s", "to_string"})
    public RubyString to_string() {
        return this.getRuntime().newString(this.accessibleObject().toString());
    }
}

