/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.CompiledMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule rubyModule, Arity arity, Visibility visibility, StaticScope staticScope, Object object, Method method, CallConfiguration callConfiguration) {
        super(rubyModule, arity, visibility, staticScope, object, callConfiguration);
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        this.callConfig.pre(threadContext, iRubyObject, this.getImplementationClass(), string, block, this.staticScope, this);
        Ruby ruby = threadContext.getRuntime();
        try {
            try {
                IRubyObject iRubyObject2;
                block12: {
                    boolean bl = ruby.hasEventHooks();
                    try {
                        if (bl) {
                            ruby.callEventHooks(threadContext, RubyEvent.CALL, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                        }
                        iRubyObject2 = (IRubyObject)this.method.invoke(this.$scriptObject, threadContext, iRubyObject, iRubyObjectArray, block);
                        Object var11_14 = null;
                        if (!bl) break block12;
                        Frame frame = threadContext.getPreviousFrame();
                        ruby.callEventHooks(threadContext, RubyEvent.RETURN, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (!bl) throw throwable;
                        Frame frame = threadContext.getPreviousFrame();
                        ruby.callEventHooks(threadContext, RubyEvent.RETURN, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
                        throw throwable;
                    }
                }
                Object var14_18 = null;
                this.callConfig.post(threadContext);
                return iRubyObject2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw RaiseException.createNativeRaiseException(ruby, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw RaiseException.createNativeRaiseException(ruby, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof JumpException.ReturnJump) {
                    IRubyObject iRubyObject3 = this.handleReturn(threadContext, (JumpException.ReturnJump)throwable);
                    Object var14_19 = null;
                    this.callConfig.post(threadContext);
                    return iRubyObject3;
                }
                if (throwable instanceof JumpException.RedoJump) {
                    IRubyObject iRubyObject4 = this.handleRedo(ruby);
                    Object var14_20 = null;
                    this.callConfig.post(threadContext);
                    return iRubyObject4;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof Error)) throw RaiseException.createNativeRaiseException(ruby, throwable);
                throw (Error)throwable;
            }
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            this.callConfig.post(threadContext);
            throw throwable;
        }
    }
}

