/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.MethodFactory;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class CompiledMethod
extends JavaMethod
implements JumpTarget,
Cloneable {
    protected Object $scriptObject;

    public CompiledMethod(RubyModule rubyModule, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        super(rubyModule, visibility, callConfiguration, staticScope, arity);
        this.$scriptObject = object;
    }

    protected CompiledMethod() {
    }

    protected void init(RubyModule rubyModule, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        this.$scriptObject = object;
        super.init(rubyModule, arity, visibility, staticScope, callConfiguration);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
        return this.call(threadContext, iRubyObject, rubyModule, string, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, iRubyObject4, Block.NULL_BLOCK);
    }

    public DynamicMethod dup() {
        try {
            CompiledMethod compiledMethod = (CompiledMethod)this.clone();
            return compiledMethod;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isNative() {
        return false;
    }

    public static class LazyCompiledMethod
    extends DynamicMethod
    implements JumpTarget,
    Cloneable {
        private final String method;
        private final Arity arity;
        private final StaticScope scope;
        private final Object scriptObject;
        private MethodFactory factory;
        private DynamicMethod compiledMethod;

        public LazyCompiledMethod(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration, MethodFactory methodFactory) {
            super(rubyModule, visibility, callConfiguration);
            this.method = string;
            this.arity = arity;
            this.scope = staticScope;
            this.scriptObject = object;
            this.factory = methodFactory;
        }

        private synchronized void initializeMethod() {
            if (this.compiledMethod != null) {
                return;
            }
            this.compiledMethod = this.factory.getCompiledMethod(this.implementationClass, this.method, this.arity, this.visibility, this.scope, this.scriptObject, this.callConfig);
            this.factory = null;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, iRubyObject4);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, block);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, block);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, block);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, iRubyObject4, block);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray, block);
        }

        public Arity getArity() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getArity();
        }

        public CallConfiguration getCallConfig() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getCallConfig();
        }

        public RubyModule getImplementationClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getImplementationClass();
        }

        protected RubyModule getProtectedClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getProtectedClass();
        }

        public DynamicMethod getRealMethod() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getRealMethod();
        }

        public Visibility getVisibility() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getVisibility();
        }

        public boolean isCallableFrom(IRubyObject iRubyObject, CallType callType) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isCallableFrom(iRubyObject, callType);
        }

        public boolean isNative() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isNative();
        }

        public void setCallConfig(CallConfiguration callConfiguration) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setCallConfig(callConfiguration);
        }

        public void setImplementationClass(RubyModule rubyModule) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setImplementationClass(rubyModule);
        }

        public void setVisibility(Visibility visibility) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setVisibility(visibility);
        }

        public DynamicMethod dup() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.dup();
        }
    }
}

