/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Function;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ext.ffi.Invoker;
import org.jruby.nb.ext.ffi.jna.DynamicMethodOneArg;
import org.jruby.nb.ext.ffi.jna.DynamicMethodThreeArg;
import org.jruby.nb.ext.ffi.jna.DynamicMethodTwoArg;
import org.jruby.nb.ext.ffi.jna.DynamicMethodZeroArg;
import org.jruby.nb.ext.ffi.jna.FunctionInvoker;
import org.jruby.nb.ext.ffi.jna.Invocation;
import org.jruby.nb.ext.ffi.jna.Marshaller;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.builtin.IRubyObject;

final class JNAInvoker
extends Invoker {
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final Marshaller[] marshallers;

    public JNAInvoker(Ruby ruby, Function function, FunctionInvoker functionInvoker, Marshaller[] marshallerArray) {
        super(ruby, marshallerArray.length);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallerArray;
    }

    public IRubyObject invoke(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        Object[] objectArray = new Object[iRubyObjectArray.length];
        Invocation invocation = new Invocation();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.marshallers[i].marshal(invocation, iRubyObjectArray[i]);
        }
        IRubyObject iRubyObject = this.functionInvoker.invoke(ruby, this.function, objectArray);
        invocation.finish();
        return iRubyObject;
    }

    public DynamicMethod createDynamicMethod(RubyModule rubyModule) {
        if (Arity.NO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodZeroArg(rubyModule, this.function, this.functionInvoker);
        }
        if (Arity.ONE_ARGUMENT.equals(this.arity)) {
            return new DynamicMethodOneArg(rubyModule, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.TWO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodTwoArg(rubyModule, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.THREE_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodThreeArg(rubyModule, this.function, this.functionInvoker, this.marshallers);
        }
        return super.createDynamicMethod(rubyModule);
    }
}

