/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarNode
extends Node
implements INameNode {
    private String name;

    public ClassVarNode(ISourcePosition iSourcePosition, String string) {
        super(iSourcePosition, NodeType.CLASSVARNODE);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitClassVarNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        return rubyModule.getClassVar(this.name);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2;
        RubyModule rubyModule = threadContext.getCurrentScope().getStaticScope().getModule();
        if (rubyModule == null && iRubyObject.getMetaClass().fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        if (rubyModule.fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        IRubyObject iRubyObject3 = iRubyObject2 = rubyModule.isSingleton() ? ((MetaClass)rubyModule).getAttached() : null;
        if (iRubyObject2 instanceof RubyModule && ((RubyModule)iRubyObject2).fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        return null;
    }
}

