/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.insane.model.ObjectSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class InsaneConverter {
    private File from;
    private File to;
    private Map<String, ClassInfo> classInfo = new LinkedHashMap<String, ClassInfo>();
    private Map<String, RefInfo> refInfo = new LinkedHashMap<String, RefInfo>();
    private ObjectSet instanceInfo = new ObjectSet();
    private int refsOffset;
    private int objsOffset;
    private int totalOffset;
    boolean prescan = true;
    MappedByteBuffer store;
    private static Object[] EMPTY = new Object[0];

    private InsaneConverter(File file, File file2) {
        this.from = file;
        this.to = file2;
    }

    ByteBuffer getByteBuffer(int n) {
        if (n < 12) {
            throw new IllegalArgumentException("bad offset " + n);
        }
        return ((ByteBuffer)this.store.duplicate().position(n)).slice();
    }

    private ClassInfo getClassInfo(String string) {
        ClassInfo classInfo = this.classInfo.get(string);
        if (classInfo == null) {
            classInfo = new ClassInfo(string);
            this.classInfo.put(string, classInfo);
        }
        return classInfo;
    }

    void createInstanceInfo(String string, String string2, int n, String string3) {
        InstanceInfo instanceInfo = new InstanceInfo(string);
        InstanceInfo instanceInfo2 = (InstanceInfo)this.instanceInfo.get(instanceInfo);
        if (instanceInfo2 == null) {
            if (!this.prescan) {
                throw new IllegalArgumentException("Unknown element during second pass:" + string);
            }
            instanceInfo2 = instanceInfo;
            this.instanceInfo.put(instanceInfo2);
        }
        ClassInfo classInfo = this.getClassInfo(string2);
        instanceInfo2.process(this, classInfo, n);
        classInfo.register(instanceInfo2);
    }

    InstanceInfo getInstance(String string) {
        InstanceInfo instanceInfo = new InstanceInfo(string);
        return (InstanceInfo)this.instanceInfo.get(instanceInfo);
    }

    void registerReference(String string, String string2, String string3) {
        InstanceInfo instanceInfo = string2 == null ? null : this.getInstance(string2);
        InstanceInfo instanceInfo2 = this.getInstance(string3);
        RefInfo refInfo = this.refInfo.get(string);
        if (refInfo == null) {
            refInfo = instanceInfo == null ? new RefInfo(string, instanceInfo2) : new RefInfo(string, null);
            this.refInfo.put(string, refInfo);
        }
        if (instanceInfo != null) {
            instanceInfo.registerOutgoingReference(this, refInfo, instanceInfo2);
        }
        instanceInfo2.registerIncommingReference(this, refInfo, instanceInfo);
    }

    private void process() throws Exception {
        this.parse(new FileInputStream(this.from));
        this.compute();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.to, "rw");
        this.store = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.totalOffset);
        randomAccessFile.close();
        this.storeHeaders();
        this.prescan = false;
        this.parse(new FileInputStream(this.from));
        this.store.force();
    }

    private void compute() {
        int n = 12;
        for (ClassInfo object : this.classInfo.values()) {
            n = object.computeNextOffset(n);
        }
        this.refsOffset = n;
        for (RefInfo refInfo : this.refInfo.values()) {
            n = refInfo.computeNextOffset(n);
        }
        this.objsOffset = n;
        Iterator<Object> iterator = this.instanceInfo.iterator();
        while (iterator.hasNext()) {
            InstanceInfo instanceInfo = (InstanceInfo)iterator.next();
            n = instanceInfo.computeNextOffset(n);
        }
        this.totalOffset = n;
    }

    private void storeHeaders() throws IOException {
        this.store.put("SBIH".getBytes());
        this.store.putInt(this.refsOffset);
        this.store.putInt(this.objsOffset);
        for (ClassInfo object : this.classInfo.values()) {
            object.storeHeader();
        }
        for (RefInfo refInfo : this.refInfo.values()) {
            refInfo.storeHeader();
        }
    }

    private static void storeString(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
    }

    private static int computeStringSize(String string) {
        return 4 + string.getBytes().length;
    }

    private void parse(InputStream inputStream) throws Exception {
        class Handler
        extends DefaultHandler {
            private int depth = 0;

            Handler() {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (this.depth == 0) {
                    if (!"insane".equals(string3)) {
                        throw new SAXException("format");
                    }
                } else {
                    if (this.depth != 1) {
                        throw new SAXException("format");
                    }
                    if ("object".equals(string3)) {
                        String string4 = attributes.getValue("id");
                        String string5 = attributes.getValue("type");
                        String string6 = attributes.getValue("size");
                        String string7 = attributes.getValue("value");
                        InsaneConverter.this.createInstanceInfo(string4, string5, Integer.parseInt(string6), string7);
                    } else if ("ref".equals(string3)) {
                        String string8 = attributes.getValue("from");
                        String string9 = attributes.getValue("name");
                        String string10 = attributes.getValue("to");
                        InsaneConverter.this.registerReference(string9, string8, string10);
                    } else {
                        throw new SAXException("format");
                    }
                }
                ++this.depth;
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                --this.depth;
            }
        }
        Handler handler = new Handler();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.getXMLReader().setContentHandler(handler);
        sAXParser.getXMLReader().parse(new InputSource(inputStream));
    }

    public static void convert(File file, File file2) throws Exception {
        InsaneConverter insaneConverter = new InsaneConverter(file, file2);
        insaneConverter.process();
    }

    private class RefInfo {
        int offset;
        String refName;
        InstanceInfo instance;

        RefInfo(String string, InstanceInfo instanceInfo) {
            this.refName = string;
            this.instance = instanceInfo;
        }

        int computeNextOffset(int n) {
            this.offset = n;
            return n + InsaneConverter.computeStringSize(this.refName) + 4;
        }

        void storeHeader() throws IOException {
            ByteBuffer byteBuffer = InsaneConverter.this.getByteBuffer(this.offset);
            InsaneConverter.storeString(byteBuffer, this.refName);
            if (this.instance == null) {
                byteBuffer.putInt(-1);
            } else {
                this.instance.storeOffset(byteBuffer);
            }
        }

        void storeOffset(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.offset);
        }
    }

    private static class InstanceInfo {
        private int id1;
        private int offset;
        private int incommingCountOrPtr;
        private int outgoingCountOrPtr;

        InstanceInfo(String string) {
            this.id1 = Integer.parseInt(string, 16);
        }

        void process(InsaneConverter insaneConverter, ClassInfo classInfo, int n) {
            if (!insaneConverter.prescan) {
                ByteBuffer byteBuffer = insaneConverter.getByteBuffer(this.offset);
                classInfo.storeOffset(byteBuffer);
                byteBuffer.putInt(n);
                byteBuffer.putInt(this.outgoingCountOrPtr);
                byteBuffer.putInt(this.incommingCountOrPtr);
                int n2 = this.outgoingCountOrPtr;
                this.outgoingCountOrPtr = this.offset + byteBuffer.position();
                this.incommingCountOrPtr = this.outgoingCountOrPtr + 8 * n2;
            }
        }

        void registerIncommingReference(InsaneConverter insaneConverter, RefInfo refInfo, InstanceInfo instanceInfo) {
            this.incommingCountOrPtr = this.registerReference(insaneConverter, this.incommingCountOrPtr, refInfo, instanceInfo);
        }

        void registerOutgoingReference(InsaneConverter insaneConverter, RefInfo refInfo, InstanceInfo instanceInfo) {
            this.outgoingCountOrPtr = this.registerReference(insaneConverter, this.outgoingCountOrPtr, refInfo, instanceInfo);
        }

        private int registerReference(InsaneConverter insaneConverter, int n, RefInfo refInfo, InstanceInfo instanceInfo) {
            if (insaneConverter.prescan) {
                return n + 1;
            }
            ByteBuffer byteBuffer = insaneConverter.getByteBuffer(n);
            refInfo.storeOffset(byteBuffer);
            if (instanceInfo == null) {
                byteBuffer.putInt(0);
            } else {
                instanceInfo.storeOffset(byteBuffer);
            }
            return n + 8;
        }

        int computeNextOffset(int n) {
            this.offset = n;
            return n + 4 + 4 + 4 + 4 + 8 * this.outgoingCountOrPtr + 8 * this.incommingCountOrPtr;
        }

        void storeOffset(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.offset);
        }

        public boolean equals(Object object) {
            if (object instanceof InstanceInfo) {
                return this.id1 == ((InstanceInfo)object).id1;
            }
            return false;
        }

        public int hashCode() {
            return 61315 * this.id1;
        }
    }

    private class ClassInfo {
        String className;
        int offset;
        int countOrOffset;

        ClassInfo(String string) {
            this.className = string;
        }

        void register(InstanceInfo instanceInfo) {
            if (InsaneConverter.this.prescan) {
                ++this.countOrOffset;
            } else {
                ByteBuffer byteBuffer = InsaneConverter.this.getByteBuffer(this.countOrOffset);
                instanceInfo.storeOffset(byteBuffer);
                this.countOrOffset += 4;
            }
        }

        int computeNextOffset(int n) {
            this.offset = n;
            return n + InsaneConverter.computeStringSize(this.className) + 4 + 4 * this.countOrOffset;
        }

        void storeHeader() {
            ByteBuffer byteBuffer = InsaneConverter.this.getByteBuffer(this.offset);
            InsaneConverter.storeString(byteBuffer, this.className);
            byteBuffer.putInt(this.countOrOffset);
            this.countOrOffset = byteBuffer.position() + this.offset;
        }

        void storeOffset(ByteBuffer byteBuffer) {
            byteBuffer.putInt(this.offset);
        }
    }
}

