/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class GenerateJavadocFix
implements Fix {
    private static final int NOPOS = -2;
    private String name;
    private final ElementHandle handle;
    private final FileObject file;
    private Position position;
    private final SourceVersion spec;

    GenerateJavadocFix(String string, ElementHandle elementHandle, FileObject fileObject, SourceVersion sourceVersion) {
        this.name = string;
        this.handle = elementHandle;
        this.file = fileObject;
        this.spec = sourceVersion;
    }

    public String getText() {
        return NbBundle.getMessage(GenerateJavadocFix.class, (String)"MISSING_JAVADOC_HINT", (Object)this.name);
    }

    public ChangeInfo implement() {
        return this.implement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement(final boolean bl) {
        final String[] stringArray = new String[1];
        final Document[] documentArray = new Document[1];
        final JavadocGenerator javadocGenerator = new JavadocGenerator(this.spec);
        javadocGenerator.updateSettings(this.file);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        try {
            javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = GenerateJavadocFix.this.handle.resolve((CompilationInfo)workingCopy);
                    Tree tree = null;
                    if (element != null) {
                        tree = workingCopy.getTrees().getTree(element);
                    }
                    if (tree != null) {
                        String string;
                        stringArray[0] = string = javadocGenerator.generateComment(element, (CompilationInfo)workingCopy);
                        documentArray[0] = workingCopy.getDocument();
                        if (documentArray[0] == null) {
                            return;
                        }
                        GenerateJavadocFix.this.position = documentArray[0].createPosition((int)workingCopy.getTrees().getSourcePositions().getStartPosition(workingCopy.getCompilationUnit(), tree));
                    }
                }
            }).commit();
        }
        catch (IOException iOException) {
            Logger.getLogger(GenerateJavadocFix.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        if (documentArray[0] == null) {
            return null;
        }
        final Indent indent = Indent.get((Document)documentArray[0]);
        final Reformat reformat = Reformat.get((Document)documentArray[0]);
        try {
            indent.lock();
            reformat.lock();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)documentArray[0]), (Runnable)new Runnable(){

                public void run() {
                    try {
                        String string = stringArray[0];
                        int n = GenerateJavadocFix.this.position.getOffset();
                        Position[] positionArray = null;
                        if (GenerateJavadocFix.makeJavadocAloneOnLine(documentArray[0], n)) {
                            string = '\n' + string;
                            int[] nArray = GenerateJavadocFix.findReformatSpan(documentArray[0], n);
                            positionArray = new Position[]{documentArray[0].createPosition(nArray[0]), documentArray[0].createPosition(nArray[1])};
                        }
                        documentArray[0].insertString(n, string, null);
                        int n2 = string.indexOf("/**");
                        n2 = string.indexOf("\n", n2 + 1);
                        n2 = string.indexOf("\n", n2 + 1);
                        Position position = documentArray[0].createPosition(n + n2);
                        indent.reindent(n, n + string.length() + 1);
                        if (positionArray != null) {
                            reformat.reformat(positionArray[0].getOffset(), positionArray[1].getOffset());
                        }
                        if (bl) {
                            JavadocUtilities.open(GenerateJavadocFix.this.file, position.getOffset());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(GenerateJavadocFix.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
        }
        finally {
            reformat.unlock();
            indent.unlock();
        }
        return null;
    }

    private static boolean makeJavadocAloneOnLine(Document document, int n) throws BadLocationException {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = document.getText(0, n);
        }
        if (n - 1 >= charSequence.length()) {
            return false;
        }
        for (int i = n - 1; i >= 0; --i) {
            char c = charSequence.charAt(i);
            if (Character.isWhitespace(c)) {
                if (c != '\n') continue;
                break;
            }
            return true;
        }
        return false;
    }

    private static int[] findReformatSpan(Document document, int n) throws BadLocationException {
        char c;
        int[] nArray = new int[]{n, n};
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = document.getText(0, document.getLength());
        }
        while (nArray[0] > 0 && (c = charSequence.charAt(nArray[0])) != '\n') {
            nArray[0] = nArray[0] - 1;
        }
        while (nArray[1] < charSequence.length() - 1 && (c = charSequence.charAt(nArray[1])) != '\n') {
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }
}

